/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.xml;

import java.text.ParseException;
import java.util.StringTokenizer;

public final class MomInfo {
    private String name = "";
    private int release;
    private int version;
    private int minorVersion;

    private MomInfo() {
    }

    public static MomInfo getMomInfo(String versionStr) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(versionStr, "._");
        if (tokenizer.countTokens() < 3 || tokenizer.countTokens() > 4) {
            throw new ParseException("Illegal MOM version string: " + versionStr, 0);
        }
        MomInfo momInfo = new MomInfo();
        String token = tokenizer.nextToken();
        int index = 0;
        MomInfo.checkToken(token, index, versionStr);
        momInfo.name = token;
        index += token.length() + 1;
        token = tokenizer.nextToken();
        momInfo.release = MomInfo.convertTokenToInt(token, 99, versionStr, index);
        index += token.length() + 1;
        token = tokenizer.nextToken();
        momInfo.version = MomInfo.convertTokenToInt(token, 999, versionStr, index);
        if (tokenizer.hasMoreTokens()) {
            index += token.length() + 1;
            token = tokenizer.nextToken();
            momInfo.minorVersion = MomInfo.convertTokenToInt(token, 99, versionStr, index);
        }
        return momInfo;
    }

    public int intValue() {
        int versionInt = 10000000 * (Character.getNumericValue(this.name.charAt(0)) - Character.getNumericValue('A') + 1) + 100000 * this.release + 100 * this.version + this.minorVersion;
        return versionInt;
    }

    public String toString() {
        StringBuffer momInfoBuf = new StringBuffer(this.name).append('_').append(this.release).append('_').append(this.version);
        if (this.minorVersion > 0) {
            momInfoBuf.append('_').append(this.minorVersion);
        }
        return momInfoBuf.toString();
    }

    private static void checkToken(String token, int index, String versionStr) throws ParseException {
        for (int i = 0; i < token.length(); ++i) {
            if (Character.isLetter(token.charAt(i))) continue;
            throw new ParseException("Illegal MOM version string: " + versionStr, index + i);
        }
        if (token.length() != 1) {
            throw new ParseException("Illegal MOM version string: " + versionStr, index);
        }
    }

    private static int convertTokenToInt(String token, int max, String versionStr, int index) throws ParseException {
        int result = -1;
        try {
            result = Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Illegal MOM version string: " + versionStr, index);
        }
        if (result < 0 || result > max) {
            throw new ParseException("Illegal MOM version string: " + versionStr, index);
        }
        return result;
    }
}

