/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.sequencer;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.DataConverterMopplet;
import se.ericsson.cello.aueframework.converter.UpgradeHandler;
import se.ericsson.cello.aueframework.converter.WriteableConverterContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step2.common.RbsDataConverter;
import se.ericsson.crbs.omf.aue.step2.sequencer.RbsAueStep2Sequencer;
import se.ericsson.crbs.omf.aue.step2.sequencer.RbsAueStep2SequencerFactory;

public class RbsAueStep2SequencerImpl
extends DataConverterMopplet
implements RbsAueStep2Sequencer,
UpgradeHandler {
    private static final Class THIS_CLASS = RbsAueStep2SequencerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final SortedSet participants;

    public RbsAueStep2SequencerImpl() {
        logger.traceEnter(THIS_CLASS, "RbsAueStep2SequencerImpl()");
        this.participants = Collections.synchronizedSortedSet(new TreeSet(new ParticipantComparator()));
        RbsAueStep2SequencerFactory.setRbsAueSte2Sequencer(this);
        logger.traceReturn(THIS_CLASS, "RbsAueStep2SequencerImpl()");
    }

    public String getConverterNamePrefix() {
        return "RbsAueStep2Sequencer";
    }

    public UpgradeHandler getUpgradeHandler(WriteableConverterContext writeableconvertercontext) {
        logger.traceEnter(THIS_CLASS, "getUpgradeHandler()");
        logger.traceEnter(THIS_CLASS, "getUpgradeHandler()");
        return this;
    }

    public void subscribe(String converterName, RbsDataConverter rbsDataConverter, Integer[] wantedSequenceNumbers) {
        StringBuffer message = new StringBuffer("Participant " + converterName + " has successfully subscribed for upgrade with triggers: ");
        for (int index = 0; index < wantedSequenceNumbers.length; ++index) {
            message.append(wantedSequenceNumbers[index]).append(',');
            this.participants.add(new Participant(converterName, rbsDataConverter, wantedSequenceNumbers[index]));
        }
        message.deleteCharAt(message.length() - 1).append('.');
        logger.traceDebug(THIS_CLASS, message.toString());
    }

    public void upgrade(ConverterContext converterContext) throws CrbsAueException {
        converterContext.setAttribute("BEFORE_REBOOT_KEY", (Object)Boolean.FALSE);
        if (!this.participants.isEmpty()) {
            Iterator participantsIterator = this.participants.iterator();
            while (participantsIterator.hasNext()) {
                Participant currentParticipant = (Participant)participantsIterator.next();
                try {
                    currentParticipant.upgrade(converterContext);
                }
                catch (CrbsAueException aueException) {
                    throw new CrbsAueException("Exception caught executing trigger " + currentParticipant.getWantedSequenceNumber() + " on converter participant " + currentParticipant.getConverterName(), (Throwable)((Object)aueException));
                }
            }
        }
        try {
            DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            dbWrapper.openConnection();
            try {
                this.cleanUp(dbWrapper);
            }
            catch (CrbsAueException e) {
                // empty catch block
            }
            dbWrapper.closeConnection(2);
        }
        catch (SQLException se) {
            throw new CrbsAueException("Database error", se);
        }
    }

    protected void cleanUp(DbWrapper inputDbWrapper) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "cleanUp()");
        String[] oldTables = null;
        try {
            if (inputDbWrapper.doTableExist("cleanup_table_for_rbs_aue")) {
                oldTables = this.getOldTableNames(inputDbWrapper);
            } else {
                logger.traceEnter(THIS_CLASS, "cleanUp() Nothing to clean. Table :cleanup_table_for_rbs_aue do not exists in DB step 1 is not executed! ");
            }
        }
        catch (SQLException e) {
            String errorMsg = "Failed to read from table: cleanup_table_for_rbs_aue";
            logger.traceError(THIS_CLASS, AueUtil.appendReason("Failed to read from table: cleanup_table_for_rbs_aue", e), e);
            throw new CrbsAueException("Failed to read from table: cleanup_table_for_rbs_aue", e);
        }
        if (oldTables != null) {
            for (int i = 0; i < oldTables.length; ++i) {
                try {
                    String deleteSqlStr = "DROP TABLE " + oldTables[i];
                    inputDbWrapper.executeUpdate(deleteSqlStr);
                    continue;
                }
                catch (SQLException e) {
                    String errorMsg = "Failed to delete old table: " + oldTables[i];
                    logger.traceGeneral(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
                }
            }
            try {
                String deleteSqlStr = "DROP TABLE cleanup_table_for_rbs_aue";
                inputDbWrapper.executeUpdate("DROP TABLE cleanup_table_for_rbs_aue");
            }
            catch (SQLException e) {
                String errorMsg = "Failed to delete the temporary table: cleanup_table_for_rbs_aue";
                logger.traceGeneral(THIS_CLASS, AueUtil.appendReason("Failed to delete the temporary table: cleanup_table_for_rbs_aue", e));
            }
        }
        logger.traceReturn(THIS_CLASS, "cleanUp()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getOldTableNames(DbWrapper inputDbWrapper) throws SQLException {
        ResultSet resultSet = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            resultSet = inputDbWrapper.executeQuery("SELECT tables_to_be_removed FROM cleanup_table_for_rbs_aue");
            while (resultSet != null && resultSet.next()) {
                String tmpName = resultSet.getString(1);
                tableNames.add(tmpName);
            }
            String[] tableNamesArr = new String[tableNames.size()];
            tableNames.toArray(tableNamesArr);
            String[] stringArray = tableNamesArr;
            return stringArray;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTableForDeletion(String tableToDrop) {
        DbWrapper dbWrapper = null;
        try {
            dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            dbWrapper.openConnection();
            dbWrapper.executeUpdate("INSERT INTO cleanup_table_for_rbs_aue VALUES ( " + AueUtil.quote("cleanup_table_for_rbs_aue") + ", " + AueUtil.quote(tableToDrop) + " )");
        }
        catch (SQLException sqle) {
            logger.traceAbnormal(THIS_CLASS, sqle.getMessage());
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, e.getMessage());
        }
        finally {
            if (dbWrapper != null) {
                try {
                    dbWrapper.closeConnection(2);
                }
                catch (SQLException ignore) {}
            }
        }
    }

    private class Participant {
        private final RbsDataConverter participantRbsDataConverter;
        private final Integer participantWantedSequenceNumber;
        private final String participantConverterName;

        protected Participant(String converterName, RbsDataConverter rbsDataConverter, Integer wantedSequenceNumber) {
            this.participantConverterName = converterName;
            this.participantRbsDataConverter = rbsDataConverter;
            this.participantWantedSequenceNumber = wantedSequenceNumber;
        }

        protected void upgrade(ConverterContext context) throws CrbsAueException {
            this.participantRbsDataConverter.upgrade(context, this.participantWantedSequenceNumber);
        }

        protected String getConverterName() {
            return this.participantConverterName;
        }

        protected Integer getWantedSequenceNumber() {
            return this.participantWantedSequenceNumber;
        }
    }

    private class ParticipantComparator
    implements Comparator {
        private ParticipantComparator() {
        }

        public int compare(Object firstParticipant, Object secondParticipant) {
            int result;
            Integer secondWantedSequenceNumber;
            Integer firstWantedSequenceNumber = ((Participant)firstParticipant).getWantedSequenceNumber();
            int comparedSequenceNumber = firstWantedSequenceNumber.compareTo(secondWantedSequenceNumber = ((Participant)secondParticipant).getWantedSequenceNumber());
            if (comparedSequenceNumber == 0) {
                String firstName = ((Participant)firstParticipant).getConverterName();
                String secondName = ((Participant)secondParticipant).getConverterName();
                result = firstName.compareTo(secondName);
            } else {
                result = comparedSequenceNumber;
            }
            return result;
        }
    }
}

