/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.nodeservicestool;

import java.awt.Image;
import java.util.Properties;
import se.ericsson.cello.emt.nodeservicestool.Configuration;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.neal.NodeConfig;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.utils.EmLogger;

public class ConfigurationImpl
implements Configuration {
    private static final EmLogger LOGGER = EmLogger.NODE_SERVICE;
    private String myHost;
    private String title;
    static final String XML_FILE_KEY = "XML_FILE";
    static final String DTD_FILE_KEY = "DTD_FILE";
    static final String NODESERVICES_TITLE_KEY = "CUSTOM_APPL_NAME";
    public static final String MANAGER_TITLE_KEY = "MANAGER_TITLE";
    public static final String DEFAULT_MANAGER_TITLE = "CPP Element Manager";
    static final String TOOL_ICON_KEY = "TOOL_ICON";
    static final String DEFAULT_TITLE = "Node Services ";
    private static final String PROPERTY_ADDRESS = "address";
    private Image iconImage = null;
    private String iconToPassOn = null;
    private Properties myProperties = null;

    public ConfigurationImpl(String host, Properties props, LauncherInterface launcher, Launchable launchable) {
        this.myHost = host;
        this.myProperties = props;
        if (this.myProperties == null || this.myHost == null) {
            throw new RuntimeException("ConfigurationImpl.constructor: (myProperties == null) || (myHost == null)");
        }
        if (props != null) {
            this.title = this.getHostAddress() + " - " + props.getProperty(MANAGER_TITLE_KEY, DEFAULT_MANAGER_TITLE) + " - " + props.getProperty(NODESERVICES_TITLE_KEY, DEFAULT_TITLE);
            LOGGER.fine(ConfigurationImpl.class + " reads the property title", new Object[0]);
            this.iconToPassOn = props.getProperty(TOOL_ICON_KEY);
            IconHelper helper = new IconHelper();
            this.iconImage = helper.getIconImage(this.iconToPassOn);
            LOGGER.fine(ConfigurationImpl.class + " reads the property icon", new Object[0]);
        }
    }

    public String getMomFileUrl() {
        return this.generateUrlString(this.myProperties.getProperty(XML_FILE_KEY, "XML_FILE is not defined"));
    }

    public String getDtdFileUrl() {
        return this.generateUrlString(this.myProperties.getProperty(DTD_FILE_KEY, "DTD_FILE is not defined"));
    }

    private String generateUrlString(String path) {
        String protocol = this.myProperties.getProperty("protocol");
        LOGGER.fine("Protocol is : " + protocol, new Object[0]);
        StringBuffer buf = new StringBuffer(protocol);
        buf.append("://");
        buf.append(this.getHost());
        if (!path.startsWith("/")) {
            buf.append("/");
        }
        buf.append(path);
        return buf.toString();
    }

    public NodeConfig getNodeConfig() {
        if (this.myHost != null) {
            return new NodeConfig(this.myHost);
        }
        throw new RuntimeException("The host is not set.");
    }

    public String getTitle() {
        return this.title;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public String getIconToPassOn() {
        return this.iconToPassOn;
    }

    public String getHost() {
        return this.myHost;
    }

    public String getHostAddress() {
        return this.myProperties.getProperty(PROPERTY_ADDRESS, "");
    }
}

