/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl;

import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import se.ericsson.cello.emt.sshsftpservice.EmSsh;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshTimeoutException;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.ifc.Connection;
import se.ericsson.security.utils.EmLogger;

public class SynchronousSshCommandSender
implements EmSsh {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String IO_EXCEPTION = "IO exception when %s";
    private static final String OPENING_STREAM = "opening stream: %s";
    private static final String READING_WRITING = "writing/reading to/from stream for command: %s";
    private static final String CLOSING_STREAM = "closing stream: %s";
    private static final String ILLEGAL_TIMEOUT_VALUE = "Illegal timeout value (0-): ";
    private static final String CMD_COMPLETE_SIGNALLING = "ENDANDOVER";
    private static final String ECHO_STRING = "echo ENDANDOVER";
    private Connection connector = null;
    private SshSession sshSession = null;
    private SshClient sshClient = null;
    private String newline = null;
    private OutputStream out = null;
    private InputStream in = null;

    public SynchronousSshCommandSender(Connection connection) throws EmSshLoginException, EmSshException {
        this.connector = connection;
        try {
            this.sshClient = this.connector.connect();
            if (this.sshClient != null) {
                this.sshSession = this.sshClient.openSessionChannel();
            }
            if (this.sshSession != null) {
                this.sshSession.requestPseudoTerminal("vt100", 80, 24, 0, 0);
                this.sshSession.startShell();
                this.out = this.sshSession.getOutputStream();
                this.in = this.sshSession.getInputStream();
                this.newline = System.getProperties().getProperty("line.separator");
            }
        }
        catch (EmSshLoginException e) {
            String msg = "Login Failure: " + e.getMessage();
            LOG.severe(msg, new Object[0]);
            throw e;
        }
        catch (SshException e) {
            String msg = "Connecting SSH failure: " + e.getMessage();
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg, e);
        }
        catch (ChannelOpenException e) {
            String msg = "Opening channel failure: " + e.getMessage();
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg, e);
        }
        catch (SshIOException e) {
            String msg = String.format(IO_EXCEPTION, String.format(OPENING_STREAM, e.getMessage()));
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg, e);
        }
    }

    public String send(String cmd, long timeout) throws EmSshTimeoutException, EmSshException {
        String errorNoActiveSession = "No active session when sending SSH command: " + cmd;
        if (this.sshSession == null) {
            LOG.severe(errorNoActiveSession, new Object[0]);
            throw new EmSshException(errorNoActiveSession);
        }
        long until = 0L;
        long now = 0L;
        boolean checkTimeout = true;
        if (timeout < 0L) {
            throw new EmSshException(ILLEGAL_TIMEOUT_VALUE + timeout);
        }
        if (timeout == 0L) {
            checkTimeout = false;
        } else {
            checkTimeout = true;
            until = System.currentTimeMillis() + timeout;
        }
        StringBuffer allLines = new StringBuffer();
        try {
            this.out.write((cmd + "\n").getBytes());
            this.out.write("echo ENDANDOVER\n".getBytes());
            BufferedReader inbuffer = new BufferedReader(new InputStreamReader(this.in));
            String line = inbuffer.readLine();
            while (line != null) {
                if (checkTimeout && (now = System.currentTimeMillis()) > until) {
                    String reason = "Timeout occured while sending the cmd: " + cmd;
                    throw new EmSshTimeoutException(reason);
                }
                if (line.endsWith(CMD_COMPLETE_SIGNALLING) && !line.endsWith(ECHO_STRING)) break;
                if (!line.endsWith(cmd) && !line.endsWith(ECHO_STRING)) {
                    allLines.append(line);
                    allLines.append(this.newline);
                }
                line = inbuffer.readLine();
            }
            inbuffer.close();
        }
        catch (IOException e) {
            String msg = String.format(IO_EXCEPTION, String.format(READING_WRITING, e.getMessage()));
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg, e);
        }
        return allLines.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exit() {
        try {
            if (this.sshClient != null) {
                this.sshClient.disconnect();
            }
            if (this.sshSession != null) {
                this.sshSession.close();
                String msg = "SSH Session is closed";
                LOG.info(msg, new Object[0]);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out == null) throw throwable;
                this.out.close();
                throw throwable;
            }
            catch (IOException e) {
                String msg = String.format(IO_EXCEPTION, String.format(CLOSING_STREAM, e.getMessage()));
                LOG.severe(msg, new Object[0]);
                throw new EmSshException(msg, e);
            }
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out == null) return;
            this.out.close();
            return;
        }
        catch (IOException e) {
            String msg = String.format(IO_EXCEPTION, String.format(CLOSING_STREAM, e.getMessage()));
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg, e);
        }
    }

    public boolean isOpen() {
        return !this.sshSession.isClosed();
    }
}

