/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.userpreferences.storage.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import se.ericsson.cello.emt.userpreferences.storage.ifc.StorageAccess;
import se.ericsson.cello.emt.userpreferences.utils.impl.UserPreferencesLog;

public class Storage
implements StorageAccess {
    private Properties properties = null;
    private File preferencesFile;
    private boolean fileChecked = false;

    public static StorageAccess getInstance(String fileName) {
        return new Storage(fileName);
    }

    private Storage(String fileName) {
        this.preferencesFile = new File(fileName);
        this.properties = new Properties();
    }

    public void savePreferences() throws IOException {
        FileOutputStream outFileStream = new FileOutputStream(this.preferencesFile);
        this.properties.store(outFileStream, "User Preferences");
        outFileStream.close();
    }

    public String getPreference(String key, String defaultValue) {
        this.loadProperties();
        return this.properties.getProperty(key, defaultValue);
    }

    public void setPreference(String key, String value) {
        this.loadProperties();
        if (null == value) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    public void removePreference(String preferenceKey) {
        this.properties.remove(preferenceKey);
    }

    private void loadProperties() {
        if (!this.fileChecked) {
            this.fileChecked = true;
            if (this.preferencesFile.exists()) {
                try {
                    FileInputStream inFileStream = new FileInputStream(this.preferencesFile);
                    this.properties.load(inFileStream);
                    inFileStream.close();
                }
                catch (IOException e) {
                    UserPreferencesLog.logger().log(Level.WARNING, "It was not possible to load properties.\n" + UserPreferencesLog.stackToString(e));
                }
            }
        }
    }
}

