/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.common;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.emas.fm.common.SortButtonRenderer;
import se.ericsson.cello.emas.fm.common.TimeFormatter;
import se.ericsson.cello.support.gui.guilib.table.SortedTable;

public class AlarmSortedTable
extends SortedTable {
    private static final long serialVersionUID = -6870960658196032085L;
    private ListMouseListener list_MouseListener = null;
    private JTableHeader tableHeader = null;
    private SortButtonRenderer renderer = null;

    public AlarmSortedTable() {
        this.setColumnSelectionAllowed(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int pointx = (int)e.getPoint().getX();
                int pointy = (int)e.getPoint().getY();
                Point point = new Point(pointx, pointy);
                int rowNo = AlarmSortedTable.this.rowAtPoint(point);
                int colNo = AlarmSortedTable.this.columnAtPoint(point);
                if (AlarmSortedTable.this.getColumnName(AlarmSortedTable.this.columnAtPoint(point)).equals("EVENT_TIME")) {
                    String value = TimeFormatter.setTimeFormat(AlarmSortedTable.this.getValueAt(rowNo, colNo).toString());
                    AlarmSortedTable.this.setToolTipText(value);
                } else {
                    AlarmSortedTable.this.setToolTipText(AlarmSortedTable.this.getValueAt(rowNo, colNo).toString());
                }
            }
        });
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.setTableHeader(this.createDefaultTableHeader());
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.removeMouseListenerToHeaderInTable();
        this.tableHeader = tableHeader;
        super.setTableHeader(tableHeader);
        this.addMouseListenerToHeaderInTable();
    }

    private void addMouseListenerToHeaderInTable() {
        TableColumnModel tcm = this.tableHeader.getColumnModel();
        this.renderer = new SortButtonRenderer();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setHeaderRenderer(this.renderer);
        }
        if (tcm.getColumnCount() > 0) {
            this.renderer.setSelectedColumn(0);
        }
        this.list_MouseListener = new ListMouseListener(this.tableHeader);
        this.tableHeader.addMouseListener(this.list_MouseListener);
    }

    private void removeMouseListenerToHeaderInTable() {
        if (this.list_MouseListener != null && this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.list_MouseListener);
        }
    }

    public void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        if (this.renderer != null) {
            if (this.renderer.isSelectedColumn(e.getFromIndex())) {
                this.renderer.pressedColumnMoved(e.getToIndex());
                this.renderer.repaint();
            } else if (this.renderer.isSelectedColumn(e.getToIndex())) {
                this.renderer.pressedColumnMoved(e.getFromIndex());
                this.renderer.repaint();
            }
            this.renderer.setPressedColumn(e.getToIndex());
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        JTableHeader header = null;

        public ListMouseListener(JTableHeader header) {
            this.header = header;
        }

        public void mousePressed(MouseEvent e) {
            if (AlarmSortedTable.this.renderer != null && this.header != null) {
                int col = this.header.columnAtPoint(e.getPoint());
                AlarmSortedTable.this.renderer.setPressedColumn(col);
                if (AlarmSortedTable.this.renderer.isSelectedColumn(col)) {
                    AlarmSortedTable.this.renderer.pressedColumnMoved(col);
                }
                this.header.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (AlarmSortedTable.this.renderer != null && this.header != null) {
                int col = this.header.columnAtPoint(e.getPoint());
                AlarmSortedTable.this.renderer.setPressedColumn(-1);
                this.header.repaint();
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (this.header != null) {
                AlarmSortedTable.this.renderer.setSelectedColumn(this.header.columnAtPoint(e.getPoint()));
                this.header.repaint();
            }
        }
    }
}

