/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.prngc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import se.ericsson.security.cppsec.prngc.PrngcException;

public class PrngcApi {
    private Socket socket;

    public PrngcApi() throws PrngcException {
        try {
            this.socket = new Socket(InetAddress.getByName("127.0.0.1"), 5555);
        }
        catch (IOException iOException) {
            throw new PrngcException("Failed to establish socket towards PRNGD", iOException);
        }
    }

    public byte[] getRandomBytes(byte by) throws PrngcException {
        if (by < 1 || by > 255) {
            throw new PrngcException("Input argument out of range: " + by);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[by];
        try {
            this.socket.setSoTimeout(10000);
            InputStream inputStream = this.socket.getInputStream();
            OutputStream outputStream = this.socket.getOutputStream();
            byArray[0] = by;
            outputStream.write(byArray, 0, 1);
            int n = inputStream.read(byArray2);
            if (n != by) {
                throw new PrngcException("Requesting " + by + " bytes, but read " + n + " bytes from socket");
            }
            return byArray2;
        }
        catch (IOException iOException) {
            throw new PrngcException("Failed to fetch I/O streams", iOException);
        }
    }

    protected void finalize() throws Throwable {
        this.socket.close();
    }
}

