/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.model.momodel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.model.momodel.ConfigurationVersionAddToListAction;
import se.ericsson.cello.swe.model.momodel.ConfigurationVersionDeleteAction;
import se.ericsson.cello.swe.model.momodel.ConfigurationVersionRemoveFromListAction;
import se.ericsson.cello.swe.model.momodel.ConfigurationVersionSetStartableAction;
import se.ericsson.cello.swe.model.momodel.CvMoModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvMoModelImpl
implements CvMoModel {
    private static final String CV_NAME = "name";
    private static final String CV_DATE = "date";
    private static final String CV_TYPE = "type";
    private static final String CV_OP_NAME = "operatorName";
    private static final String CV_OP_COMMENT = "operatorComment";
    private static final String CV_ID = "identity";
    private static final String CV_UP_ID = "upgradePackageId";
    private static final String CV_USAGE = "CV Usage";
    private static final String CV_RB_LIST = "Rollback List";
    private final String[] columnNames = new String[]{"name", "identity", "CV Usage", "Rollback List", "date", "type", "operatorName", "operatorComment", "upgradePackageId"};
    private final String yes = " yes ";
    private final String empty = "";
    private String myLDN = null;
    private Mo myMoRef = null;
    private MomClass myMomClass = null;
    private TreeMap<String, AttrMapping> myAttrMappingMap = null;
    private Node myNode = null;
    private MimModel myMimModel = null;
    private Transaction myNullTx = null;
    private List<HashMap<String, String>> myTableDataMapList = null;
    private HashMap<Object, Object> restartRankMap = null;
    private HashMap<Object, Object> restartReasonMap = null;
    private String currentLoadedCV;
    private String currentStartableCV;
    private String executingCv;
    private HashMap<String, Integer> rollbackListMap;

    public CvMoModelImpl(String aLDN, Node aNealNode, MimModel aMimParserMimModel) throws Exception {
        this.myLDN = aLDN;
        this.myNode = aNealNode;
        this.myMimModel = aMimParserMimModel;
        if (this.myLDN == null || this.myNode == null || this.myMimModel == null) {
            throw new RuntimeException("MoModelImpl.constructor: (myLDN==null) || (myNode==null) || (myMimModel==null)");
        }
        this.myMoRef = this.myNode.getCmService().getMo(this.myLDN);
        if (!this.myMoRef.exists()) {
            SweLog.logger().log(Level.INFO, "MoModelImpl.constructor: It does not exist any MO with the ldn='" + this.myLDN + "' on the node.");
            throw new RuntimeException("MoModelImpl.constructor: It does not exist any MO with the ldn='" + this.myLDN + "' on the node.");
        }
        this.myMomClass = this.myMimModel.getClass(this.myMoRef.getType());
        if (this.myMomClass == null) {
            throw new RuntimeException("MoModelImpl.constructor: The mo class of the ldn='" + this.myLDN + "' was not found in the mom.");
        }
        this.refreshModels();
    }

    @Override
    public List<NameValue> getAttributes() {
        return null;
    }

    private void getRequiredAttributes() throws Exception {
        this.myAttrMappingMap = new TreeMap();
        String[] requiredAttrNames = new String[]{"currentLoadedConfigurationVersion", "startableConfigurationVersion", "executingCv", "rollbackList", "storedConfigurationVersions"};
        AttrMapping aMapping = null;
        String aName = null;
        for (int i = 0; i < requiredAttrNames.length; ++i) {
            aMapping = new AttrMapping();
            aMapping.myMomAttr = null;
            NameValue attrNameValue = null;
            aName = requiredAttrNames[i];
            SweLog.logger().log(Level.INFO, "before getAttribute for momAttr.getName:" + aName);
            aMapping.myNameValue = attrNameValue = this.myMoRef.getAttribute(aName, this.myNullTx);
            SweLog.logger().log(Level.INFO, "after getAttribute for momAttr.getName:" + aName + " = " + attrNameValue);
            this.myAttrMappingMap.put(aName, aMapping);
        }
    }

    @Override
    public String getLDN() {
        return this.myLDN;
    }

    @Override
    public Mo getMoRef() {
        return this.myMoRef;
    }

    @Override
    public MomClass getMomClass() {
        return this.myMomClass;
    }

    @Override
    public List<MomAction> getActions() {
        return null;
    }

    @Override
    public void applyAttributeModelValues() {
    }

    @Override
    public void refreshModels() throws Exception {
        this.getRequiredAttributes();
        this.restartRankMap = new HashMap();
        this.restartReasonMap = new HashMap();
        this.makeEnumMap("RestartRank", this.restartRankMap);
        this.makeEnumMap("RestartReason", this.restartReasonMap);
        this.getCurrentLoadedCV();
        this.getCurrentStartableCV();
        this.getExecutingCV();
        this.getRollbackListMap();
        this.getStoredCvList();
        this.getTableData();
    }

    @Override
    public String getDescription() {
        String description = this.myMomClass.getDescription();
        if (description == null) {
            return "No information available.";
        }
        return description;
    }

    private void getStoredCvList() {
        this.myTableDataMapList = new LinkedList<HashMap<String, String>>();
        String STOREDCONFIGURATIONVERSIONS_NAME = "storedConfigurationVersions";
        AttrMapping storedCvsMapping = this.myAttrMappingMap.get(STOREDCONFIGURATIONVERSIONS_NAME);
        NameValue storedCvs = storedCvsMapping.myNameValue;
        if (storedCvs == null) {
            return;
        }
        Struct[] myStructArray = storedCvs.getStructArrayValue();
        Struct aCvStruct = null;
        HashMap<String, String> myTableRowDataMap = null;
        for (int i = 0; i < myStructArray.length; ++i) {
            aCvStruct = myStructArray[i];
            NameValue[] nvArray = null;
            nvArray = aCvStruct.getNameValueArray();
            NameValue aNV = null;
            myTableRowDataMap = new HashMap<String, String>();
            for (int j = 0; j < nvArray.length; ++j) {
                aNV = nvArray[j];
                myTableRowDataMap.put(aNV.getName(), aNV.getStringValue());
            }
            this.myTableDataMapList.add(myTableRowDataMap);
        }
    }

    @Override
    public String[] getTableHeader() {
        return this.columnNames;
    }

    public String getCurrentLoadedCV() throws Exception {
        String clCvName = "currentLoadedConfigurationVersion";
        this.currentLoadedCV = this.myAttrMappingMap.get((Object)clCvName).myNameValue.getStringValue();
        return this.currentLoadedCV;
    }

    public String getCurrentStartableCV() throws Exception {
        String startableCvName = "startableConfigurationVersion";
        this.currentStartableCV = this.myAttrMappingMap.get((Object)startableCvName).myNameValue.getStringValue();
        return this.currentStartableCV;
    }

    public String getExecutingCV() throws Exception {
        String startableCvName = "executingCv";
        this.executingCv = this.myAttrMappingMap.get((Object)startableCvName).myNameValue.getStringValue();
        return this.executingCv;
    }

    public Map<String, Integer> getRollbackListMap() {
        String rollBackListName = "rollbackList";
        this.rollbackListMap = new HashMap();
        if (this.myAttrMappingMap.get((Object)rollBackListName).myNameValue == null) {
            return this.rollbackListMap;
        }
        String[] rollbackList = this.myAttrMappingMap.get((Object)rollBackListName).myNameValue.getStringArrayValue();
        this.rollbackListMap = new HashMap();
        if (rollbackList == null) {
            return this.rollbackListMap;
        }
        String aName = null;
        for (int i = 0; i < rollbackList.length; ++i) {
            aName = rollbackList[i];
            this.rollbackListMap.put(aName, new Integer(i + 1));
        }
        return this.rollbackListMap;
    }

    @Override
    public List<List<String>> getTableData() {
        LinkedList<List<String>> aTableDataList = new LinkedList<List<String>>();
        Map aRowMap = null;
        List<String> aRow = null;
        int n = this.myTableDataMapList.size();
        for (int i = 0; i < n; ++i) {
            aRowMap = this.myTableDataMapList.get(i);
            aRow = this.makeOneTableRow(aRowMap);
            aTableDataList.add(aRow);
        }
        return aTableDataList;
    }

    private List<String> makeOneTableRow(Map<String, String> aDataMap) {
        LinkedList<String> aRowList = new LinkedList<String>();
        String theCvName = aDataMap.get(CV_NAME);
        aRowList.add(theCvName);
        aRowList.add(aDataMap.get(CV_ID));
        aRowList.add(this.getCvUsage(theCvName));
        aRowList.add(this.getRbPosition(theCvName));
        aRowList.add(aDataMap.get(CV_DATE));
        aRowList.add(aDataMap.get(CV_TYPE));
        aRowList.add(aDataMap.get(CV_OP_NAME));
        aRowList.add(aDataMap.get(CV_OP_COMMENT));
        aRowList.add(aDataMap.get(CV_UP_ID));
        return aRowList;
    }

    private String getRbPosition(String cvName) {
        String rbPos = "";
        Integer pos = this.rollbackListMap.get(cvName);
        rbPos = pos == null ? "" : pos.toString();
        return rbPos;
    }

    private String getCvUsage(String cvName) {
        String usage = "";
        String aValue = null;
        aValue = this.getStartable(cvName);
        if (!aValue.equals("")) {
            usage = "Startable";
        }
        if (!(aValue = this.getExecuting(cvName)).equals("")) {
            if (!usage.equals("")) {
                usage = usage + ", ";
            }
            usage = usage + "Executing";
        }
        if (!(aValue = this.getLoaded(cvName)).equals("")) {
            if (!usage.equals("")) {
                usage = usage + ", ";
            }
            usage = usage + "Loaded";
        }
        return usage;
    }

    private String getStartable(String theCvName) {
        String status = "";
        if (theCvName.equals(this.currentStartableCV)) {
            status = " yes ";
        }
        return status;
    }

    private String getExecuting(String theCvName) {
        String status = "";
        if (theCvName.equals(this.executingCv)) {
            status = " yes ";
        }
        return status;
    }

    private String getLoaded(String theCvName) {
        String status = "";
        if (theCvName.equals(this.currentLoadedCV)) {
            status = " yes ";
        }
        return status;
    }

    @Override
    public void removeFromRollbackList(String aCvName) {
        ConfigurationVersionRemoveFromListAction aCvRemove = new ConfigurationVersionRemoveFromListAction(aCvName, this.myMoRef, this.myNode);
        aCvRemove.performAction();
    }

    @Override
    public void setFirstRollbackList(String aCvNam) {
        ConfigurationVersionAddToListAction aCvAdd = new ConfigurationVersionAddToListAction(aCvNam, this.myMoRef, this.myNode);
        aCvAdd.performAction();
    }

    public Map<Object, Object> makeEnumMap(String aEnumName, Map<Object, Object> aMap) {
        MomEnum theRestartRank = null;
        Iterator enumIterator = this.myMimModel.findEnums(aEnumName);
        if (!enumIterator.hasNext()) {
            return aMap;
        }
        theRestartRank = (MomEnum)enumIterator.next();
        Iterator enumMemberIter = theRestartRank.getMembers();
        MomEnumMember aMember = null;
        String aName = null;
        Integer aValue = null;
        while (enumMemberIter.hasNext()) {
            aMember = (MomEnumMember)enumMemberIter.next();
            aName = aMember.getName();
            aValue = aMember.getValue();
            aMap.put(aName, aValue);
            aMap.put(aValue, aName);
        }
        return aMap;
    }

    @Override
    public void setStartable(String aCvName) throws Exception {
        ConfigurationVersionSetStartableAction aCvAction = new ConfigurationVersionSetStartableAction(aCvName, this.myMoRef, this.myNode);
        aCvAction.performAction();
    }

    @Override
    public boolean canDelete(String aCvName) {
        boolean result = false;
        boolean isStartable = false;
        boolean isInRbList = false;
        boolean isCurrentLoadedCv = false;
        String csCv = this.currentStartableCV;
        isStartable = aCvName.equals(csCv);
        Integer rbPos = this.rollbackListMap.get(aCvName);
        isInRbList = rbPos != null;
        isCurrentLoadedCv = this.currentLoadedCV.equals(aCvName);
        result = !isStartable && !isInRbList && !isCurrentLoadedCv;
        return result;
    }

    @Override
    public void deleteCV(String aCvName) {
        ConfigurationVersionDeleteAction aCvAction = new ConfigurationVersionDeleteAction(aCvName, this.myMoRef, this.myNode);
        aCvAction.performAction();
    }

    @Override
    public int getRbHeaderPosition() {
        return 3;
    }

    @Override
    public boolean isRestorable(String selectedCvName) {
        boolean result = false;
        Map aRowMap = null;
        String aCvName = null;
        String aCvType = null;
        int n = this.myTableDataMapList.size();
        for (int i = 0; i < n; ++i) {
            aRowMap = this.myTableDataMapList.get(i);
            aCvName = (String)aRowMap.get(CV_NAME);
            if (!selectedCvName.equals(aCvName)) continue;
            aCvType = ((String)aRowMap.get(CV_TYPE)).trim();
            break;
        }
        if (aCvType != null && aCvType.equals("downloaded")) {
            result = true;
        }
        SweLog.logger().log(Level.INFO, "The selected CV name is: " + selectedCvName + " has a type: " + aCvType);
        return result;
    }

    private class AttrMapping {
        public MomAttribute myMomAttr = null;
        public NameValue myNameValue = null;
        public String ErrorMessage = null;

        private AttrMapping() {
        }
    }
}

