/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.model.momodel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.model.momodel.UpMoModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpMoModelImpl
implements UpMoModel {
    private String myLDN = null;
    private Mo mySwMoRef = null;
    private final String mySwLdn = "ManagedElement=1,SwManagement=1";
    private String currentUpMoLdn = null;
    private Mo[] myUpMoRefs = null;
    private MomClass myMomClass = null;
    private List<NameValue> myAttributeList = null;
    private List<MomAction> myActionModelList = null;
    private Node myNode = null;
    private MimModel myMimModel = null;
    private Transaction myNullTx = null;
    private List<HashMap<String, String>> myTableDataMapList = null;
    private final String[] requiredAttrNames = new String[]{"state", "administrativeData", "userLabel"};
    private NameValue[][] upAttrList = null;
    private final String[] columnNames = new String[]{"upgradePackageId", "state", "Active", "productNumber", "productRevision", "userLabel"};
    private final String PRODUCTNUMBER_NAME = "productNumber";
    private final String PRODUCTREVISION_NAME = "productRevision";
    private final String UP_STATE_ENUM_NAME = "UpgradePackageState";
    private Map myUpStateMap = null;

    public UpMoModelImpl(String aLDN, Node aNealNode, MimModel aMimParserMimModel) {
        this.myLDN = aLDN;
        this.myNode = aNealNode;
        this.myMimModel = aMimParserMimModel;
        this.mySwMoRef = this.myNode.getCmService().getMo("ManagedElement=1,SwManagement=1");
        this.myMomClass = this.myMimModel.getClass(this.mySwMoRef.getType());
        if (this.myMomClass == null) {
            throw new RuntimeException("UpMoModelImpl.constructor: The mo class of the ldn='ManagedElement=1,SwManagement=1' was not found in the mom.");
        }
        this.refreshModels();
    }

    private void initializeDataStructs() {
        this.myUpMoRefs = this.mySwMoRef.getChildren("UpgradePackage", "", Scope.ONE_LEVEL, null);
        if (this.myUpMoRefs == null) {
            return;
        }
        int nUps = this.myUpMoRefs.length;
        int nAttrs = this.requiredAttrNames.length;
        this.upAttrList = new NameValue[nUps][nAttrs];
        this.myUpStateMap = new HashMap();
        this.myUpStateMap = this.makeEnumMap("UpgradePackageState", this.myUpStateMap);
        Mo[] cv = this.mySwMoRef.getChildren("ConfigurationVersion", "", Scope.ONE_LEVEL, null);
        NameValue upMoV = null;
        try {
            upMoV = cv[0].getAttribute("currentUpgradePackage", this.myNullTx);
            Mo currentUpMo = upMoV.getMoValue();
            this.currentUpMoLdn = currentUpMo.getLdn();
        }
        catch (Exception e) {
            this.currentUpMoLdn = "";
        }
    }

    private void readAllUpgradePackages() {
        if (this.myUpMoRefs == null) {
            return;
        }
        Mo aMo = null;
        for (int i = 0; i < this.myUpMoRefs.length; ++i) {
            aMo = this.myUpMoRefs[i];
            this.upAttrList[i] = this.getRequiredAttributes(aMo);
        }
    }

    @Override
    public List<NameValue> getAttributes() {
        return null;
    }

    private NameValue[] getRequiredAttributes(Mo aUpMo) {
        SweLog.logger().log(Level.INFO, "Geting required attrs for aUpMo: " + aUpMo.getLdn());
        int n = this.requiredAttrNames.length;
        NameValue[] aNVList = new NameValue[n];
        String aName = null;
        for (int i = 0; i < n; ++i) {
            NameValue attrNameValue = null;
            try {
                aName = this.requiredAttrNames[i];
                SweLog.logger().log(Level.INFO, "before getAttribute for momAttr.getName:" + aName);
                aNVList[i] = attrNameValue = aUpMo.getAttribute(aName, this.myNullTx);
                SweLog.logger().log(Level.INFO, "after getAttribute for momAttr.getName:" + aName);
                continue;
            }
            catch (Exception e) {
                SweLog.logger().log(Level.INFO, "reading of NameValue for the following attr failed: momAttr.getName:" + aName);
            }
        }
        return aNVList;
    }

    @Override
    public String getLDN() {
        return this.myLDN;
    }

    @Override
    public Mo getMoRef() {
        return this.mySwMoRef;
    }

    @Override
    public MomClass getMomClass() {
        return this.myMomClass;
    }

    @Override
    public List<MomAction> getActions() {
        this.myActionModelList = new LinkedList<MomAction>();
        Iterator momActionIter = this.myMomClass.getActions();
        if (momActionIter == null) {
            return this.myActionModelList;
        }
        MomAction aMomAction = null;
        while (momActionIter.hasNext()) {
            aMomAction = (MomAction)momActionIter.next();
            this.myActionModelList.add(aMomAction);
        }
        return this.myActionModelList;
    }

    @Override
    public void applyAttributeModelValues() {
    }

    @Override
    public void refreshModels() {
        this.initializeDataStructs();
        this.readAllUpgradePackages();
        this.getTableData();
    }

    @Override
    public String getDescription() {
        String description = this.myMomClass.getDescription();
        if (description == null) {
            return "No information available.";
        }
        return description;
    }

    @Override
    public String[] getTableHeader() {
        return this.columnNames;
    }

    @Override
    public List<List<String>> getTableData() {
        LinkedList<List<String>> aTableDataList = new LinkedList<List<String>>();
        if (this.myUpMoRefs == null || this.myUpMoRefs.length == 0) {
            return aTableDataList;
        }
        List<String> aRow = null;
        int n = this.myUpMoRefs.length;
        for (int i = 0; i < n; ++i) {
            aRow = this.makeOneTableRow(i);
            aTableDataList.add(aRow);
        }
        SweLog.logger().log(Level.INFO, "getTableData()was successful.");
        return aTableDataList;
    }

    private List<String> makeOneTableRow(int i) {
        LinkedList<String> aRowList = new LinkedList<String>();
        String aLdn = this.myUpMoRefs[i].getLdn();
        String aName = this.getName(i);
        aRowList.add(aName);
        aName = this.getState(i);
        aRowList.add(aName);
        aName = this.getActive(i);
        aRowList.add(aName);
        aName = this.getProductNumber(i);
        aRowList.add(aName);
        aName = this.getProductRevision(i);
        aRowList.add(aName);
        aName = this.getUserLabel(i);
        aRowList.add(aName);
        return aRowList;
    }

    public Map makeEnumMap(String aEnumName, Map aMap) {
        MomEnum aMomEnum = null;
        Iterator enumIterator = this.myMimModel.findEnums(aEnumName);
        if (!enumIterator.hasNext()) {
            return aMap;
        }
        aMomEnum = (MomEnum)enumIterator.next();
        Iterator enumMemberIter = aMomEnum.getMembers();
        MomEnumMember aMember = null;
        String aName = null;
        Integer aValue = null;
        while (enumMemberIter.hasNext()) {
            aMember = (MomEnumMember)enumMemberIter.next();
            aName = aMember.getName();
            aValue = aMember.getValue();
            aMap.put(aName, aValue);
            aMap.put(aValue, aName);
        }
        return aMap;
    }

    private String getName(int i) {
        String aName = null;
        aName = this.myUpMoRefs[i].getName();
        return aName;
    }

    private String getState(int i) {
        Integer aState = this.upAttrList[i][0].getIntegerValue();
        String stateSymbol = (String)this.myUpStateMap.get(aState);
        return stateSymbol;
    }

    private String getProductNumber(int i) {
        String productNumber = "";
        Struct aSruct = this.upAttrList[i][1].getStructValue();
        NameValue pn = aSruct.getMember("productNumber");
        productNumber = pn.getStringValue();
        return productNumber;
    }

    private String getProductRevision(int i) {
        String productRevision = "";
        Struct aSruct = this.upAttrList[i][1].getStructValue();
        NameValue pr = aSruct.getMember("productRevision");
        productRevision = pr.getStringValue();
        return productRevision;
    }

    private String getUserLabel(int i) {
        String name = "";
        name = this.upAttrList[i][2].getStringValue();
        return name;
    }

    private String getActive(int i) {
        String active = "";
        String aLdn = this.myUpMoRefs[i].getLdn();
        if (this.currentUpMoLdn.equals(aLdn)) {
            active = " yes ";
        }
        return active;
    }
}

