/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.controller.UpSweController;
import se.ericsson.cello.swe.model.UpSweModel;
import se.ericsson.cello.swe.model.momodel.UpMoModel;
import se.ericsson.cello.swe.service.StartFailureException;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.view.UpSweView;
import se.ericsson.cello.swe.view.gui.UpHyperToolAction;
import se.ericsson.cello.swe.view.gui.UpTablePanel;

public class UpSweGui
implements UpSweView {
    private JButton upCreateB;
    private JButton upPropertiesB;
    private UpSweModel myModel = null;
    private UpMoModel myMoModel = null;
    private SweToolServices myToolServices = null;
    private UpTablePanel myUpPanel = null;
    private JPanel myComponentPanel = new JPanel(new BorderLayout(0, 0));
    private UpHyperToolAction myMenuItemAction = null;

    public UpSweGui(UpSweController upSweController, UpSweModel upSweModel) {
        this.myModel = upSweModel;
    }

    public void exit() {
        if (this.myMenuItemAction != null) {
            if (this.upCreateB != null) {
                this.upCreateB.removeActionListener(this.myMenuItemAction);
            }
            if (this.upPropertiesB != null) {
                this.upPropertiesB.removeActionListener(this.myMenuItemAction);
            }
        }
        this.upCreateB = null;
        this.upPropertiesB = null;
        this.myModel = null;
        this.myMoModel = null;
        this.myToolServices = null;
        this.myUpPanel = null;
        this.myComponentPanel = null;
        this.myMenuItemAction = null;
    }

    public JComponent getComponent() {
        return this.myComponentPanel;
    }

    public void initialize() {
        SweLog.logger().log(Level.INFO, "UpSweGui.initialize");
        try {
            this.myModel.getToolServices().getNodeServices();
        }
        catch (StartFailureException e) {
            String errorString = "Failed to launch NodeServices.";
            this.reportException(errorString, e);
            this.myModel.exit();
            return;
        }
        this.myToolServices = this.myModel.getToolServices();
        this.myMoModel = this.myModel.getMoModel();
        this.buildGui();
    }

    public void nodeConnectionLost() {
    }

    public void nodeConnectionRestored() {
    }

    public void setController(UpSweController controller) {
    }

    public void setModel(UpSweModel model) {
    }

    public void showUI(boolean visible) {
    }

    private void reportException(String reason, Exception e) {
        MessageDialogFactory.createMessageDialog((String)reason, (Exception)e, (boolean)false, null).setVisible(true);
    }

    private void buildGui() {
        String[] theTableHeader = this.myMoModel.getTableHeader();
        List<List<String>> theDataDataList = this.myMoModel.getTableData();
        this.myUpPanel = new UpTablePanel(theDataDataList, theTableHeader, this.myModel, this.myToolServices.getPreferenceService());
        this.myUpPanel.setName("myUpPanel");
        this.myUpPanel.setColumnSizes();
        this.myComponentPanel = this.makeTheCompleteComponent();
    }

    private void reBuildGui() {
        this.myMoModel.refreshModels();
        this.buildGui();
        this.myComponentPanel.validate();
        SweLog.logger().log(Level.INFO, "DONE reBuildGui");
    }

    private JPanel makeTheCompleteComponent() {
        this.myComponentPanel.removeAll();
        this.myComponentPanel.add((Component)this.myUpPanel, "Center");
        JPanel buttonPanel = this.makeButtonPanel();
        this.myComponentPanel.add((Component)buttonPanel, "South");
        return this.myComponentPanel;
    }

    private JPanel makeButtonPanel() {
        SelectionListener selectionListener = new SelectionListener(this.myUpPanel.getTable());
        this.myUpPanel.getTable().getSelectionModel().addListSelectionListener(selectionListener);
        JPanel attrButtonPanel = new JPanel(new FlowLayout(2));
        this.myMenuItemAction = new UpHyperToolAction(this.myUpPanel.getTable(), this.myToolServices);
        String upCreate = "UPCREATE";
        String upCreateToolName = this.myToolServices.getConfiguration().getToolName(upCreate);
        this.upCreateB = new JButton(upCreateToolName);
        this.upCreateB.setMnemonic('C');
        attrButtonPanel.add(this.upCreateB);
        this.upCreateB.setEnabled(true);
        this.upCreateB.addActionListener(this.myMenuItemAction);
        String upProperties = "UPPROPERTIES";
        String upPropertiesToolName = this.myToolServices.getConfiguration().getToolName(upProperties);
        this.upPropertiesB = new JButton(upPropertiesToolName);
        this.upPropertiesB.setMnemonic('U');
        attrButtonPanel.add(this.upPropertiesB);
        this.upPropertiesB.addActionListener(this.myMenuItemAction);
        if (-1 == this.myUpPanel.getTable().getSelectedRow()) {
            this.upPropertiesB.setEnabled(false);
        }
        JButton refreshB = new JButton("Refresh");
        refreshB.setMnemonic('e');
        attrButtonPanel.add(refreshB);
        refreshB.setEnabled(true);
        refreshB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpSweGui.this.reBuildGui();
            }
        });
        return attrButtonPanel;
    }

    public void reInitialize() {
        this.reBuildGui();
    }

    public UpTablePanel getMyUpPanel() {
        return this.myUpPanel;
    }

    public void selectRowWithItem(String item) {
        if (item != null) {
            JTable table = this.myUpPanel.getTable();
            int max = table.getRowCount();
            int rowToSelect = -1;
            for (int row = 0; row < max; ++row) {
                String s = (String)table.getValueAt(row, 0);
                if (s.compareTo(item) != 0) continue;
                rowToSelect = row;
                break;
            }
            if (rowToSelect > -1) {
                table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        private JTable table = null;

        SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (-1 == this.table.getSelectedRow()) {
                UpSweGui.this.upPropertiesB.setEnabled(false);
            } else {
                UpSweGui.this.upPropertiesB.setEnabled(true);
            }
        }
    }
}

