/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.factory;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.MalformedStringException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.ChildMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MetaDataFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.AttributeDataTypeFactory;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public final class MetaDataParser {
    private static final Class THIS_CLASS = MetaDataParser.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String IN_STRING = "in ";

    public static AttributeMetaData getAttributeMetaData(XMLElement attributeElement, String moType) throws IOException {
        String currentAttributeName = attributeElement.getAttributes().getValue("name");
        List moAttributeProperties = attributeElement.getChildren();
        Iterator moAttributePropsIter = moAttributeProperties.iterator();
        String currentAttributeDescription = "";
        boolean isMandatory = false;
        boolean isNoNotification = false;
        boolean isNonPersistent = false;
        boolean isReadOnly = false;
        boolean isRestricted = false;
        AttributeDataType data = null;
        Struct replacedBy = null;
        AttributeDataTypeFactory adtFactory = new AttributeDataTypeFactory();
        while (moAttributePropsIter.hasNext()) {
            String description;
            XMLElement currentAttributeProp = (XMLElement)moAttributePropsIter.next();
            if (currentAttributeProp.getType().equals("mandatory")) {
                isMandatory = true;
                continue;
            }
            if (currentAttributeProp.getType().equals("noNotification")) {
                isNoNotification = true;
                continue;
            }
            if (currentAttributeProp.getType().equals("nonPersistent")) {
                isNonPersistent = true;
                continue;
            }
            if (currentAttributeProp.getType().equals("restricted")) {
                isRestricted = true;
                continue;
            }
            if (currentAttributeProp.getType().equals("readOnly")) {
                isReadOnly = true;
                continue;
            }
            if (currentAttributeProp.getType().equals("dataType")) {
                data = adtFactory.getAttributeDataType(moType, currentAttributeName, currentAttributeProp);
                continue;
            }
            if (!currentAttributeProp.getType().equals("description") || (description = currentAttributeProp.getText()) == null) continue;
            replacedBy = MetaDataParser.findReplacedByAttribute(description, currentAttributeName, moType);
        }
        AttributeMetaData currentAttributeMetaData = MetaDataFactory.createAttributeMetaData(currentAttributeName, "", isMandatory, isNoNotification, isNonPersistent, isReadOnly, isRestricted, data, moType, replacedBy);
        return currentAttributeMetaData;
    }

    public static ChildMetaData getChildMetaData(XMLElement containment) throws IOException {
        List relationshipChildren = containment.getChildren();
        Iterator relChildIter = relationshipChildren.iterator();
        String parentName = "";
        String childName = "";
        ChildMetaData.MinMaxRange minmax = new ChildMetaData.MinMaxRange();
        while (relChildIter.hasNext()) {
            XMLElement currentRelChild = (XMLElement)relChildIter.next();
            if (currentRelChild.getType().equals("parent")) {
                parentName = MetaDataParser.getParentType(currentRelChild);
                continue;
            }
            if (!currentRelChild.getType().equals("child")) continue;
            List childMoTagChildren = currentRelChild.getChildren();
            Iterator childMoTagChildrenIter = childMoTagChildren.iterator();
            while (childMoTagChildrenIter.hasNext()) {
                XMLElement currentChildTagChild = (XMLElement)childMoTagChildrenIter.next();
                if (currentChildTagChild.getType().equals("hasClass")) {
                    childName = currentChildTagChild.getAttributes().getValue("name");
                }
                MetaDataParser.getMinMax(currentChildTagChild, minmax);
            }
        }
        return new ChildMetaData(childName, parentName, minmax.min, minmax.max);
    }

    private static void getMinMax(XMLElement currentChildTagChild, ChildMetaData.MinMaxRange minMax) {
        if (currentChildTagChild.getType().equals("cardinality")) {
            List cardinalityTagChildren = currentChildTagChild.getChildren();
            Iterator cardinalityTagChildIter = cardinalityTagChildren.iterator();
            while (cardinalityTagChildIter.hasNext()) {
                XMLElement currentRangeElement = (XMLElement)cardinalityTagChildIter.next();
                if (currentRangeElement.getType().equals("min")) {
                    String currentMinValue = currentRangeElement.getText();
                    minMax.min = Integer.parseInt(currentMinValue);
                    continue;
                }
                if (!currentRangeElement.getType().equals("max")) continue;
                String currentMaxValue = currentRangeElement.getText();
                minMax.max = Integer.parseInt(currentMaxValue);
            }
        }
    }

    private static String getParentType(XMLElement parentTag) {
        String parentMoType = null;
        List parentChildren = parentTag.getChildren();
        Iterator parentChildIter = parentChildren.iterator();
        while (parentChildIter.hasNext()) {
            XMLElement currentParentChild = (XMLElement)parentChildIter.next();
            if (!currentParentChild.getType().equals("hasClass")) continue;
            parentMoType = currentParentChild.getAttributes().getValue("name");
        }
        return parentMoType;
    }

    private MetaDataParser() {
    }

    private static Struct findReplacedByAttribute(String description, String attributeName, String moName) throws MalformedStringException {
        int pointIndex = -1;
        StructImpl replacedBy = null;
        int deprAttrIndex = description.indexOf("Deprecated: Replaced by attribute ");
        if (deprAttrIndex != -1) {
            String replacedByAttr = null;
            String replacedByMo = null;
            int startAttrNameIndex = deprAttrIndex + "Deprecated: Replaced by attribute ".length();
            int endAttrNameIndex = description.indexOf(" ", startAttrNameIndex);
            if (endAttrNameIndex == -1) {
                replacedByAttr = description.substring(startAttrNameIndex);
                if ("".equals(replacedByAttr)) {
                    logger.traceAbnormal(THIS_CLASS, "Failed to find the name of the replacing attribute in the description string for attribute " + attributeName + " in MO " + moName + ":");
                    throw new MalformedStringException("The deprecated part of the description string is malformed.");
                }
            } else {
                replacedByAttr = description.substring(startAttrNameIndex, endAttrNameIndex);
                int startInIndex = description.indexOf(IN_STRING, endAttrNameIndex);
                if (startInIndex != -1 && startInIndex == endAttrNameIndex + 1) {
                    int startMoNameIndex = startInIndex + IN_STRING.length();
                    int endMoNameIndex = description.indexOf(" ", startMoNameIndex);
                    if (endMoNameIndex == -1) {
                        replacedByMo = description.substring(startMoNameIndex);
                        if ("".equals(replacedByMo)) {
                            logger.traceAbnormal(THIS_CLASS, "Failed to find the name of the MO for the replacing attribute in the description string for attribute " + attributeName + " in MO " + moName + ":");
                            throw new MalformedStringException("The deprecated part of the description string is malformed.");
                        }
                    } else {
                        replacedByMo = description.substring(startMoNameIndex, endMoNameIndex);
                    }
                }
            }
            replacedBy = new StructImpl();
            pointIndex = replacedByAttr.indexOf(46);
            if (pointIndex != -1) {
                replacedByAttr = replacedByAttr.substring(0, pointIndex);
            }
            replacedBy.addElement("attributeName", replacedByAttr);
            if (replacedByMo != null) {
                pointIndex = replacedByMo.indexOf(46);
                if (pointIndex != -1) {
                    replacedByMo = replacedByMo.substring(0, pointIndex);
                }
                replacedBy.addElement("moName", replacedByMo);
            }
        }
        return replacedBy;
    }
}

