/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.transactions;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Resource2;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionManager;

public class TransactionManagerImpl
implements TransactionManager {
    private static final Class THIS_CLASS = TransactionManagerImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(TransactionManagerImpl.class.getName());
    private Coordinator registeredCoord = null;
    private Coordinator registeredCoord2 = null;
    private String registeredThread = null;
    private String registeredThread2 = null;
    private final Resource myResource;
    private final Resource2 myResource2;
    private final String myResourceName;

    TransactionManagerImpl(Resource aResource, String aResourceName) {
        this.myResource = aResource;
        this.myResource2 = null;
        this.myResourceName = aResourceName;
    }

    TransactionManagerImpl(Resource2 aResource2, String aResourceName) {
        this.myResource = null;
        this.myResource2 = aResource2;
        this.myResourceName = aResourceName;
    }

    public Coordinator getCoordinator() {
        Coordinator result = null;
        if (Thread.currentThread().getName().equalsIgnoreCase(this.registeredThread)) {
            logger.traceGeneral(THIS_CLASS, "Returning coordinator registeredCoord" + (this.registeredCoord == null ? "null" : this.registeredCoord + " for Transaction " + this.registeredCoord.getTransactionID()));
            result = this.registeredCoord;
        } else if (Thread.currentThread().getName().equalsIgnoreCase(this.registeredThread2)) {
            logger.traceGeneral(THIS_CLASS, "Returning coordinator registeredCoord2 : " + (this.registeredCoord2 == null ? "null" : this.registeredCoord2 + " for Transaction " + this.registeredCoord.getTransactionID()));
            result = this.registeredCoord2;
        }
        return result;
    }

    public void markRollBackOnly(Coordinator coordinator) throws ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "markRollBackOnly() " + this.myResourceName);
        try {
            coordinator.rollbackOnly();
            logger.traceGeneral(THIS_CLASS, "Resource " + this.myResourceName + " marked Transaction " + coordinator.getTransactionID() + " as rollbackOnly");
        }
        catch (InactiveTransactionException e) {
            throw new ProcessingFailureException(this.myResourceName + " " + e.reason);
        }
        logger.traceReturn(THIS_CLASS, "markRollBackOnly()");
    }

    public synchronized void registerAndCheckResource(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "registerAndCheckResource() " + this.myResourceName);
        try {
            if (this.registeredCoord != null && coordinator.isSameTransaction(this.registeredCoord)) {
                logger.traceDebug(THIS_CLASS, "Resource " + this.myResourceName + " is already registered in Transaction " + coordinator.getTransactionID() + " (registeredCoord)");
            } else if (this.registeredCoord2 != null && coordinator.isSameTransaction(this.registeredCoord2)) {
                logger.traceDebug(THIS_CLASS, "Resource " + this.myResourceName + " is already registered in Transaction " + coordinator.getTransactionID() + " (registeredCoord2)");
            } else {
                logger.traceDebug(THIS_CLASS, "registerAndCheckResource() status before attempt to register resource: #1 (" + (this.registeredCoord != null ? String.valueOf(this.registeredCoord.hashCode()) : "null") + "/" + (this.registeredThread != null ? this.registeredThread : "null") + ") #2 (" + (this.registeredCoord2 != null ? String.valueOf(this.registeredCoord2.hashCode()) : "null") + "/" + (this.registeredThread2 != null ? this.registeredThread2 : "null") + ")");
                if (this.myResource2 == null) {
                    coordinator.registerResource(this.myResource);
                } else {
                    coordinator.registerResource(this.myResource2);
                }
                this.registeredCoord2 = this.registeredCoord;
                this.registeredThread2 = this.registeredThread;
                this.registeredCoord = coordinator;
                this.registeredThread = Thread.currentThread().getName();
            }
        }
        catch (InactiveTransactionException e) {
            throw new ProcessingFailureException("Transaction is inactive, failed to register Resource " + this.myResourceName);
        }
        logger.traceReturn(THIS_CLASS, "registerAndCheckResource()");
    }
}

