/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.configcountdown;

import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoImpl;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ConfigurationCountdownActivatedDetailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.ConfigurationCountdownActivatedEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.handler.SignalHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ConfigCountdownActivatedController
extends CV_SubFunctionController {
    private static final String BACKUP_CV = "ConfigCountdown. Auto created backup CV";
    private static final String CONFIRM_CV = "ConfigCountdown. Auto created confirm CV";
    private static ConfigCountdownActivatedController instance = null;

    private ConfigCountdownActivatedController() {
    }

    public static synchronized ConfigCountdownActivatedController instance() {
        if (instance == null) {
            instance = new ConfigCountdownActivatedController();
        }
        return instance;
    }

    public void activate() throws ConfigurationVersionException {
        try {
            this.setActivityToActivated();
            this.createCv("CB", BACKUP_CV);
            this.disableAutoCreatedCvIsTurnedOn();
            this.setCountdownActivation(true);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "activate()", "Failed to active Configuration Countdown", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tFunction activate()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void deactivate() throws ConfigurationVersionException {
        try {
            this.restoreAutoCreatedCvIsTurnedOn();
            this.setCountdownActivation(false);
            this.createCv("CC", CONFIRM_CV);
            this.setActivityToIdle();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deActivate()", "Failed to deactive Configuration Countdown", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tFunction deactivate()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void resetConfigCountdown() throws Throwable {
        this.restoreAutoCreatedCvIsTurnedOn();
        this.setCountdownActivation(false);
        this.setActivityToIdle();
    }

    void rollback(Control control) {
        try {
            control.getTerminator().rollback();
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"rollback failed - inactive", (Throwable)inactiveTransactionException);
        }
    }

    private void disableAutoCreatedCvIsTurnedOn() throws Throwable {
        Control control = null;
        ConfigurationVersionMoExtension configurationVersionMoExtension = ConfigurationVersionMoImpl.instance();
        boolean bl = configurationVersionMoExtension.getAutoCreatedCVIsTurnedOn(null);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "disableAutoCreatedCvIsTurnedOn()", "autoCreatedCVIsTurnedOn originalValue: " + bl);
        }
        if (bl) {
            try {
                control = this.createTransaction();
                configurationVersionMoExtension.setAutoCreatedCVIsTurnedOnBackup(bl, control.getCoordinator());
                configurationVersionMoExtension.setAutoCreatedCVIsTurnedOn(false, control.getCoordinator());
                control.getTerminator().commit();
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "disableAutoCreatedCvIsTurnedOn()", "Failed disable autoCreatedCvIsTurnedOn", throwable);
                if (control != null) {
                    this.rollback(control);
                }
                throw throwable;
            }
        }
    }

    private void restoreAutoCreatedCvIsTurnedOn() throws Throwable {
        Control control = null;
        ConfigurationVersionMoExtension configurationVersionMoExtension = ConfigurationVersionMoImpl.instance();
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreAutoCreatedCvIsTurnedOn()", "autoCreatedCVIsTurnedOnBackup: " + configurationVersionMoExtension.getAutoCreatedCVIsTurnedOnBackup(null) + ", autoCreatedCVIsTurnedOn: " + configurationVersionMoExtension.getAutoCreatedCVIsTurnedOn(null));
        }
        if (configurationVersionMoExtension.getAutoCreatedCVIsTurnedOnBackup(null) != configurationVersionMoExtension.getAutoCreatedCVIsTurnedOn(null)) {
            try {
                control = this.createTransaction();
                configurationVersionMoExtension.setAutoCreatedCVIsTurnedOn(configurationVersionMoExtension.getAutoCreatedCVIsTurnedOnBackup(null), control.getCoordinator());
                control.getTerminator().commit();
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "restoreAutoCreatedCvIsTurnedOn()", "Failed restore autoCreatedCvIsTurnedOn", throwable);
                if (control != null) {
                    this.rollback(control);
                }
                throw throwable;
            }
        }
    }

    private void setCountdownActivation(boolean bl) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCountdownActivation(boolean configCountdownActivated)", "configCountdownActivated: " + bl);
        }
        OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
        int n = osaCvMgmntProxyAccess.sendOsaCvSetCountdownActivationReq(bl);
        this.checkResult(n);
    }

    public void setActivityToActivated() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActivityToActivated()", "Set main/detailed activity to activated");
        }
        super.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new ConfigurationCountdownActivatedEvent(this));
        super.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ConfigurationCountdownActivatedDetailedEvent(this));
    }

    public void setActivityToIdle() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActivityToIdle()", "Set main/detailed activity to idle");
        }
        super.setMainActivity(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
        super.setDetailedActivity(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
    }

    private void createCv(String string, String string2) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createCv()", "Reason: " + string + " comment: " + string2);
        }
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
        String string3 = configurationVersionMO_HandlerInterface.getStartableCV();
        configurationVersionMO_HandlerInterface.createConfigCountdownCVAndSetStartable(string, string2);
        configurationVersionMO_HandlerInterface.setRollbackDataForUpgradeRollbackCV(string3);
    }

    private Control createTransaction() throws TransactionRolledBackException {
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(120);
        MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + control.getCoordinator().getTransactionID() + ", timeout = 120 sec"));
        return control;
    }

    private void checkResult(int n) throws ConfigurationVersionException {
        SignalHandler signalHandler = new SignalHandler();
        signalHandler.checkResult(n);
    }
}

