/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.autoconfiguration.parser;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.AutoConfigAttributeName;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.AutoConfigRootElementName;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.AutoConfigSubElementName;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.SettingElement;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_AttributeException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_ElementInterface;
import se.ericsson.cello.su.xmlparser.base.XML_Exception;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class AutoConfigElement
extends XML_RootElement {
    private SettingElement mySettingElement = null;

    public AutoConfigElement(String string) {
        super("<!DOCTYPE AutoConfig>", "<!--DOCTYPE AutoConfig SYSTEM \"file:///..\\autoconfig.dtd\"-->", new LocatorImpl());
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "AutoConfigElement(String aVersion)", "aVersionValue: " + string);
        }
        if (BackupRestoreDataHandler.greaterThanVersion("1", string)) {
            Trace.error(this.getClass(), "AutoConfigElement(String aVersion)", "Version used when creating AutoConfigElement is larger than handled by the system.\n\taVersion: " + string + "\n\tHighest supported version " + "1" + " will be used.");
            string = "1";
        }
        BackupRestoreDataHandler.instance().setCurrentAutoConfigInfo(string);
    }

    public AutoConfigElement(AttributeList attributeList, Locator locator) throws UnknownXML_AttributeException {
        super("<!DOCTYPE AutoConfig>", "<!--DOCTYPE AutoConfig SYSTEM \"file:///..\\autoconfig.dtd\"-->", locator);
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "AutoConfigElement(AttributeList anAttributeList)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        String string = attributeList.getValue(AutoConfigAttributeName.Version.getValue());
        boolean bl = false;
        if (BackupRestoreDataHandler.greaterThanVersion("1", string)) {
            object = "XML file " + BackupRestoreDataHandler.instance().getCurrentFileName() + "." + "\n\tThe attribute '" + AutoConfigAttributeName.Version.getValue() + "'" + " in element '" + AutoConfigRootElementName.AutoConfig + "'" + " has a value that is not supported: '" + string + "'." + "\n\tHighest supported version '" + "1" + "' will be used." + "\n\tUnknown XML elements and attributes will be ignored.";
            Trace.warning(this.getClass(), "AutoConfigElement(AttributeList anAttributeList, Locator aLocator)", (String)object);
            string = "1";
            bl = true;
        }
        BackupRestoreDataHandler.instance().setCurrentVersion(string, bl);
        object = AutoConfigAttributeName.verifyNames(attributeList);
        if (object == null || ((String[])object).length > 0) {
            AutoConfigElement.reportUnknownAttribute(this.getClass(), "AutoConfigElement(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), AutoConfigRootElementName.AutoConfig.getValue(), object, locator);
        }
    }

    public XML_ElementInterface createChild(String string, AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", "anElementName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (string.equals(AutoConfigSubElementName.Setting.getValue())) {
            return this.createSetting(string, attributeList, locator);
        }
        return AutoConfigElement.reportUnknownElement(this.getClass(), "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), AutoConfigRootElementName.AutoConfig.getValue(), string, locator);
    }

    public SettingElement getSettingElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSettingElement()");
        }
        return this.mySettingElement;
    }

    public void print(PrintStream printStream) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.print(printStream, "");
    }

    public void print(PrintStream printStream, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream, String anIndentation)", "aPrintStream: " + printStream + "\n\tanIndentation: '" + string + "'");
        }
        super.print(printStream);
        printStream.println(string + "<" + AutoConfigRootElementName.AutoConfig.getValue());
        printStream.println("  " + string + AutoConfigAttributeName.Version.getValue() + " = \"" + BackupRestoreDataHandler.instance().getCurrentVersion() + "\"");
        printStream.println("  " + string + ">");
        if (this.mySettingElement != null) {
            printStream.println();
            this.mySettingElement.print(printStream, "  " + string);
        }
        printStream.println();
        printStream.println(string + "</" + AutoConfigRootElementName.AutoConfig.getValue() + ">");
    }

    public void setSettingElement(SettingElement settingElement) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setSettingElement(SettingElement aSettingElement)", "aSettingElement: " + settingElement);
        }
        this.mySettingElement = settingElement;
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate()");
        }
        AutoConfigAttributeName.Version.validate(BackupRestoreDataHandler.instance().getCurrentVersion(), this.getLocator());
        AutoConfigSubElementName.Setting.validate(this.mySettingElement, this.getLocator());
        if (this.mySettingElement != null) {
            this.mySettingElement.validate();
        }
    }

    private XML_ElementInterface createSetting(String string, AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSetting(String anElementName, AttributeList anAttributeList, Locator aLocator)", "anElementName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.mySettingElement == null) {
            this.mySettingElement = new SettingElement(attributeList, locator);
            return this.mySettingElement;
        }
        return AutoConfigElement.errorMoreElementsThanExpected(this.getClass(), "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), AutoConfigRootElementName.AutoConfig.getValue(), string, locator);
    }
}

