/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.softwareinformation.parser;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.OperationalProductData;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.PiuType;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SlotAttributeName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SlotSubElementName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SlotsSubElementName;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreXmlElement;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_AttributeException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_ElementInterface;
import se.ericsson.cello.su.xmlparser.base.XML_Exception;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SlotDataContainer;

public class Slot
extends BackupRestoreXmlElement {
    private String myType = null;
    private String myLdn = null;
    private String mySmn = null;
    private String myApn = null;
    private String myContainsTrustedPIU = null;
    private OperationalProductData myOperationalProductData = null;
    private PiuType myPiuType = null;

    public Slot(SlotDataContainer slotDataContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Slot(SlotDataContainer aSlotDataContainer)", "aSlotDataContainer: " + slotDataContainer);
        }
        this.myType = slotDataContainer.getType();
        this.myLdn = slotDataContainer.getLdn();
        if (slotDataContainer.getSmn() != null) {
            this.mySmn = slotDataContainer.getSmn().toString();
        }
        if (slotDataContainer.getApn() != null) {
            this.myApn = slotDataContainer.getApn().toString();
        }
        if (slotDataContainer.getOperProductNumberAndRevision() != null) {
            this.myOperationalProductData = new OperationalProductData(slotDataContainer.getOperProductNumberAndRevision().getProductNumber(), slotDataContainer.getOperProductNumberAndRevision().getRevision());
        }
        if (slotDataContainer.getPiuTypeProductNumberAndRevision() != null) {
            this.myPiuType = new PiuType(slotDataContainer.getPiuTypeProductNumberAndRevision().getProductNumber(), slotDataContainer.getPiuTypeProductNumberAndRevision().getRevision());
        }
        this.myContainsTrustedPIU = String.valueOf(slotDataContainer.containsTrustedPIU());
    }

    public Slot(AttributeList attributeList, Locator locator) throws UnknownXML_AttributeException {
        super(locator);
        String[] stringArray;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Slot(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if ((stringArray = SlotAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            Slot.reportUnknownAttribute(this.getClass(), "Slot(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SlotsSubElementName.Slot.getValue(), stringArray, locator);
        }
        this.myType = attributeList.getValue(SlotAttributeName.Type.getValue());
        this.myLdn = attributeList.getValue(SlotAttributeName.Ldn.getValue());
        this.mySmn = attributeList.getValue(SlotAttributeName.Smn.getValue());
        this.myApn = attributeList.getValue(SlotAttributeName.Apn.getValue());
        this.myContainsTrustedPIU = attributeList.getValue(SlotAttributeName.ContainsTrustedPIU.getValue());
    }

    public XML_ElementInterface createChild(String string, AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", "anElementName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (string.equals(SlotSubElementName.OperationalProductData.getValue())) {
            return this.createOperationalProductData(attributeList, locator);
        }
        if (string.equals(SlotSubElementName.PiuType.getValue())) {
            return this.createPiuType(attributeList, locator);
        }
        return Slot.reportUnknownElement(this.getClass(), "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SlotsSubElementName.Slot.getValue(), string, locator);
    }

    public OperationalProductData getOperationalProductData() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOperationalProductData()", "Returning - myOperationalProductData: " + this.myOperationalProductData);
        }
        return this.myOperationalProductData;
    }

    public PiuType getPiuType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuType()", "Returning - myPiuType: " + this.myPiuType);
        }
        return this.myPiuType;
    }

    public String getApn() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getApn()", "Returning - myApn: " + this.myApn);
        }
        return this.myApn;
    }

    public String getLdn() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLdn()", "Returning - myLdn: " + this.myLdn);
        }
        return this.myLdn;
    }

    public String getSmn() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSmn()", "Returning - mySmn: " + this.mySmn);
        }
        return this.mySmn;
    }

    public String getType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getType()", "Returning - myType: " + this.myType);
        }
        return this.myType;
    }

    public boolean containsTrustedPIU() {
        return this.myContainsTrustedPIU.equals(Boolean.TRUE.toString());
    }

    public void print(PrintStream printStream, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream, String anIndentation)", "aPrintStream: " + printStream + "\n\tanIndentation: " + string);
        }
        super.print(printStream, string);
        printStream.println(string + "<" + SlotsSubElementName.Slot.getValue());
        printStream.println("  " + string + SlotAttributeName.Ldn.getValue() + " = \"" + this.myLdn + "\"");
        printStream.println("  " + string + SlotAttributeName.Type.getValue() + " = \"" + this.myType + "\"");
        if (this.mySmn != null) {
            printStream.println("  " + string + SlotAttributeName.Smn.getValue() + " = \"" + this.mySmn + "\"");
        }
        if (this.myApn != null) {
            printStream.println("  " + string + SlotAttributeName.Apn.getValue() + " = \"" + this.myApn + "\"");
        }
        printStream.println("  " + string + SlotAttributeName.ContainsTrustedPIU.getValue() + " = \"" + this.myContainsTrustedPIU + "\"");
        printStream.println("  " + string + ">");
        if (this.myOperationalProductData != null) {
            printStream.println();
            this.myOperationalProductData.print(printStream, "  " + string);
        }
        if (this.myPiuType != null) {
            printStream.println();
            this.myPiuType.print(printStream, "  " + string);
        }
        printStream.println();
        printStream.println(string + "</" + SlotsSubElementName.Slot.getValue() + ">");
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate( )");
        }
        SlotAttributeName.Ldn.validate(this.myLdn, super.getLocator());
        SlotAttributeName.Type.validate(this.myType, super.getLocator());
        SlotAttributeName.Smn.validate(this.mySmn, super.getLocator());
        SlotAttributeName.Apn.validate(this.myApn, super.getLocator());
        SlotAttributeName.ContainsTrustedPIU.validate(this.myContainsTrustedPIU, super.getLocator());
        SlotSubElementName.OperationalProductData.validate(this.myOperationalProductData, super.getLocator());
        SlotSubElementName.PiuType.validate(this.myPiuType, super.getLocator());
        if (this.myOperationalProductData != null) {
            this.myOperationalProductData.validate();
        }
        if (this.myPiuType != null) {
            this.myPiuType.validate();
        }
    }

    private XML_ElementInterface createOperationalProductData(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createOperationalProductData(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myOperationalProductData == null) {
            this.myOperationalProductData = new OperationalProductData(attributeList, locator);
            return this.myOperationalProductData;
        }
        return Slot.errorMoreElementsThanExpected(this.getClass(), "createSwAllocations(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SlotsSubElementName.Slot.getValue(), SlotSubElementName.OperationalProductData.getValue(), locator);
    }

    private XML_ElementInterface createPiuType(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createPiuType(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myPiuType == null) {
            this.myPiuType = new PiuType(attributeList, locator);
            return this.myPiuType;
        }
        return Slot.errorMoreElementsThanExpected(this.getClass(), "createSwAllocations(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SlotsSubElementName.Slot.getValue(), SlotSubElementName.PiuType.getValue(), locator);
    }

    public String toString() {
        return "\n\tmyLdn: " + this.myLdn + "\n\tmyType: " + this.myType + "\n\tmySmn: " + this.mySmn + "\n\tmyApn: " + this.myApn + "\n\tmyOperationalProductData: " + this.myOperationalProductData + "\n\tmyPiuType: " + this.myPiuType + "\n\tmyContainsTrustedPIU: " + this.myContainsTrustedPIU;
    }
}

