/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main;

import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.thread.AWTEventMulticaster;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.thread.Alarm;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class BackupTimer
implements ActionListener {
    public static final String STOPPED = "stopped";
    private int hour;
    private int minute;
    private boolean continueDbDump;
    private Alarm initialDelayTimer;
    private ActionListener observers;
    public static final String TYPE_NAME = "BackupTimer";
    public static final String TIME_FOR_BACKUP = "timeValue";

    public BackupTimer(String string) throws ValueOutOfRangeException {
        int[] nArray = this.checkAndConvertStr2Int(string);
        this.hour = nArray[0];
        this.minute = nArray[1];
    }

    public BackupTimer() throws ValueOutOfRangeException {
        this("04:00");
    }

    public void start() {
        this.startInitialDelayTimer(this.hour, this.minute);
    }

    public void stop() {
        if (this.initialDelayTimer != null) {
            Trace.log1(this.getClass(), "stop()", "Send a signal to OSA to stop the Clock thread");
            this.initialDelayTimer.stop();
            this.initialDelayTimer = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("expired")) {
            this.observers.actionPerformed(new ActionEvent((Object)this, 0, "expired"));
            this.stop();
            this.initialDelayTimer = new Alarm(this.calculateInitialDelayInMillis(this.hour, this.minute), Alarm.ONE_SHOT);
            this.initialDelayTimer.addActionListener((ActionListener)this);
            this.initialDelayTimer.start();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.observers = AWTEventMulticaster.add((ActionListener)this.observers, (ActionListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.observers = AWTEventMulticaster.remove((ActionListener)this.observers, (ActionListener)actionListener);
    }

    private int calculateInitialDelayInMillis(int n, int n2) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        int n3 = n * 3600 + n2 * 60;
        int n4 = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        int n5 = calendar.get(2) + 1;
        String string = Integer.toString(n5);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "calculateInitialDelayInMillis(int hour, int minute)", " The current Date: " + calendar.get(1) + "-" + string + "-" + calendar.get(5) + ", " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13));
        }
        if (n3 < n4) {
            n3 += 86400;
        } else if (n3 - n4 <= 300) {
            this.continueDbDump = false;
        }
        return (n3 - n4) * 1000;
    }

    private void startInitialDelayTimer(int n, int n2) {
        this.stop();
        this.initialDelayTimer = new Alarm(this.calculateInitialDelayInMillis(n, n2), Alarm.ONE_SHOT);
        this.initialDelayTimer.addActionListener((ActionListener)this);
        this.initialDelayTimer.start();
    }

    private int[] checkAndConvertStr2Int(String string) throws ValueOutOfRangeException {
        int[] nArray = new int[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            throw new ValueOutOfRangeException(TIME_FOR_BACKUP, TYPE_NAME);
        }
        try {
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new ValueOutOfRangeException(TIME_FOR_BACKUP, TYPE_NAME);
        }
        if (nArray[0] < 0 || nArray[0] > 23 || nArray[1] < 0 || nArray[1] > 59) {
            throw new ValueOutOfRangeException(TIME_FOR_BACKUP, TYPE_NAME);
        }
        return nArray;
    }

    public boolean generateDbDump() {
        this.continueDbDump = true;
        this.calculateInitialDelayInMillis(this.hour, this.minute);
        return this.continueDbDump;
    }
}

