/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.restore;

import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.EmergencyRestoreExecutedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.EmergencyRestoreInitiatedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.EmergencyRestoreOfDownloadedBackupCV_Event;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.restore.IP_handling;
import se.ericsson.cello.configurationversion.restore.RestoreException;
import se.ericsson.cello.configurationversion.restore.RestoreParticipatorException;
import se.ericsson.cello.configurationversion.restore.RestoreParticipatorHandler;
import se.ericsson.cello.configurationversion.restore.RestoreProperties;
import se.ericsson.cello.configurationversion.util.handler.RestoreCV_Handler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class EmergencyRestorer
extends CV_SubFunctionController {
    public EmergencyRestorer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "EmergencyRestorer()");
        }
    }

    public void emergencyRestoreRequest(boolean bl, boolean bl2, UpgradePackageMo upgradePackageMo, String string) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "anAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string);
        }
        String string2 = null;
        if (EmergencyRestorer.isRunningOnSU_SIM()) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            try {
                Object object;
                ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface;
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new EmergencyRestoreOfDownloadedBackupCV_Event(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new EmergencyRestoreInitiatedEvent(this));
                RestoreProperties restoreProperties = new RestoreProperties();
                string2 = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
                if (bl) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists)", "Setting of auto-configuration data.");
                    }
                    managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
                    managedElementDataMO_HandlerInterface.setAutoconfigurationData(string2);
                }
                managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (managedElementDataMO_HandlerInterface.isPlugAndPlayRunning()) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists)", "Emergency restore is waiting while autoconfiguration is executing, isPlugAndPlayRunning: " + managedElementDataMO_HandlerInterface.isPlugAndPlayRunning());
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.error(this.getClass(), "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists)", "interrupted during Thread sleep", interruptedException);
                    }
                }
                if (bl2) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists)", "Setting of IP data.");
                    }
                    object = new IP_handling();
                    ((IP_handling)object).setIP_AddressData(string2, false);
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists)", "Invokes any restore participator.");
                }
                object = new RestoreParticipatorHandler();
                ((RestoreParticipatorHandler)object).nodeStartedIndication();
                this.createEmergencyFinalCV(upgradePackageMo, string);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new EmergencyRestoreExecutedEvent(this));
                Trace.log1(this.getClass(), "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Emergency restore finished.");
            }
            catch (RestoreParticipatorException restoreParticipatorException) {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Trace.error(this.getClass(), "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "anAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "A restore participator returned failure. Emergency restore failed.", restoreParticipatorException);
                this.deleteCreatedFiles(string2);
                throw new RestoreException("Class name: " + this.getClass().getName() + "\n\temergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)" + "\n\tThrowable caught when attempting to execute the emergency restore function." + "\n\tanAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tRestoreParticipatorException: " + restoreParticipatorException + "\n\tRestoreParticipatorException data: " + restoreParticipatorException.toString());
            }
            catch (ConfigurationVersionException configurationVersionException) {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Trace.error(this.getClass(), "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "anAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "ConfigurationVersionException caught. Emergency restore failed.", (Throwable)((Object)configurationVersionException));
                this.deleteCreatedFiles(string2);
                throw new RestoreException("Class name: " + this.getClass().getName() + "\n\temergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)" + "\n\tConfigurationVersionException caught when attempting to execute the emergency restore function." + "\n\tanAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tRestoreParticipatorException: " + (Object)((Object)configurationVersionException) + "\n\tRestoreParticipatorException data: " + configurationVersionException.toString());
            }
            catch (Throwable throwable) {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Trace.error(this.getClass(), "emergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "anAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "Throwable caught. Emergency restore failed.", throwable);
                this.deleteCreatedFiles(string2);
                throw new RestoreException("Class name: " + this.getClass().getName() + "\n\temergencyRestoreRequest(boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)" + "\n\tThrowable caught when attempting to execute the emergency restore function." + "\n\tanAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.deleteCreatedFiles(string2);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            throw throwable;
        }
        this.deleteCreatedFiles(string2);
        CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
        CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
    }

    public static boolean isRunningOnSU_SIM() {
        boolean bl = false;
        if (System.getProperty("SU_SIM") != null && System.getProperty("SU_SIM").equals("yes")) {
            bl = true;
        }
        return bl;
    }

    private void createEmergencyFinalCV(UpgradePackageMo upgradePackageMo, String string) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createEmergencyFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "aCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string);
        }
        try {
            RestoreCV_Handler restoreCV_Handler = new RestoreCV_Handler();
            if (upgradePackageMo == null) {
                Trace.warning(this.getClass(), "createEmergencyFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Can't create a Final Emergency Restore CV due to the Upgrade Package MO connected to the node configuration is missing.\n\tRe-create that Upgrade Package to be able to create CVs.\n\tThe missing UP MO instance: " + string);
                return;
            }
            restoreCV_Handler.configureCV_DataAtEmergency(upgradePackageMo);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            Trace.warning(this.getClass(), "createEmergencyFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Failed to create the Final CV at execution of Emergency restore (Pls. create one manually).\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tConfigurationVersionException caught." + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "createEmergencyFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Failed to create the Final CV at execution of Emergency restore (Pls. create one manually).\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

