/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionContinueRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionEmergencyRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStoredConfigurationVersionsHandler;
import se.ericsson.cello.configurationversion.restore.RestoreProperties;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceListenerInterface;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceStatusObserver;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceStatusObserverFactory;
import se.ericsson.cello.configurationversion.util.handler.SignalHandler;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.swmanagement.swmaccess.ServiceDeciderAccess;
import se.ericsson.cello.swmanagement.swmaccess.ServiceDeciderException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.exception.TracePropertyFileHandlerException;

public class ServiceDecider
implements ServiceDeciderAccess,
CelloConfigurationServiceListenerInterface,
Runnable {
    private ConfigurationVersionMoExtension myConfigurationVersionMoExtension = null;
    private boolean myIsCS_UpAndRunning = false;
    private String myTypeOfLoadedCV = null;
    private static final int FIFTEEN_SECONDS = 15000;
    private static final int ONE_HOUR_DIVIDED_FIFTEEN = 240;

    public ServiceDecider() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ServiceDecider()");
        }
    }

    public ServiceDecider(ConfigurationVersionMoExtension configurationVersionMoExtension) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ServiceDecider(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "aConfigurationVersionMoExtension: " + configurationVersionMoExtension);
        }
        this.myConfigurationVersionMoExtension = configurationVersionMoExtension;
    }

    public void initiateThread() {
        new Thread((Runnable)this, "ServiceDecider").start();
    }

    public void csUpAndRunning() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "csUpAndRunning()");
        }
        this.myIsCS_UpAndRunning = true;
        if (this.myTypeOfLoadedCV != null) {
            this.decideTypeOfServiceToBeStarted();
        }
    }

    public boolean isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension configurationVersionMoExtension) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "aConfigurationVersionMoExtension: " + configurationVersionMoExtension);
        }
        this.myConfigurationVersionMoExtension = configurationVersionMoExtension;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        try {
            bl2 = this.existsAutoConfigFile();
            bl3 = this.existsIP_NetworkConfigFile();
            string = this.getCurrentLoadedConfigurationVersion();
            if (string != null) {
                CV_AttributeStoredConfigurationVersionsHandler cV_AttributeStoredConfigurationVersionsHandler = new CV_AttributeStoredConfigurationVersionsHandler();
                this.myTypeOfLoadedCV = cV_AttributeStoredConfigurationVersionsHandler.getCV_Type(string);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "theIsAutoConfigFileExists: " + bl2 + "\n\ttheIsIP_NetworkConfigFileExists: " + bl3 + "\n\ttheCurrentLoadedCV_Name: " + string + "\n\tmyTypeOfLoadedCV: " + this.myTypeOfLoadedCV);
                }
                SignalHandler signalHandler = new SignalHandler();
                if (this.myTypeOfLoadedCV != null && this.myTypeOfLoadedCV.equals(signalHandler.getCV_TypeName(7))) {
                    if (bl3) {
                        bl = true;
                    } else {
                        Trace.info(this.getClass(), "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "Type of loaded CV is DOWNLOADED but the file ipNetworkConfig do not exist (assuming no restore function is in progress)");
                    }
                } else if (bl2 || bl3) {
                    if (!string.startsWith("RR")) {
                        bl = true;
                    } else {
                        Trace.info(this.getClass(), "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "Any of the auto config file or ip networkconfig file exists and loaded CV is a RR_... CV i.e. no restore function is in progress)\n\ttheIsAutoConfigFileExists: " + bl2 + "\n\ttheIsIP_NetworkConfigFileExists: " + bl3 + "\n\ttheCurrentLoadedCV_Name: " + string);
                    }
                }
            } else {
                Trace.info(this.getClass(), "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "Current loaded CV is null i.e. not possible to find out if any type of restore is in execution.");
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "RETURNS - theIsRestoreInProgress: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isAnyRestoreServiceInProgress(ConfigurationVersionMoExtension aConfigurationVersionMoExtension)", "Throwable caught when attempting to find out if any restore service is in progress (IGNORED i.e. assuming no restore function is in progress).", throwable);
            return false;
        }
    }

    public boolean isRestoreAndPnP_ConfigOngoing() throws ServiceDeciderException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRestoreAndPnP_ConfigOngoing()");
        }
        try {
            if (this.existsAutoConfigFile() && this.existsIP_NetworkConfigFile()) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "isRestoreAndPnP_ConfigOngoing()", "RETURNS - true");
                }
                return true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isRestoreAndPnP_ConfigOngoing()", "RETURNS - false");
            }
            return false;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new ServiceDeciderException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isRestoreAndPnP_ConfigOngoing()", "Throwable caught when attempting to retreive the find out if any restore service is in progress.", throwable);
            throw new ServiceDeciderException("Class name: " + this.getClass().getName() + "\n\tisRestoreAndPnP_ConfigOngoing()" + "\n\tThrowable caught when attempting to retreive the SubnetMask of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        try {
            CelloConfigurationServiceStatusObserver celloConfigurationServiceStatusObserver = CelloConfigurationServiceStatusObserverFactory.instance().createObserver();
            celloConfigurationServiceStatusObserver.addAsListener(this);
            String string = this.getCurrentLoadedConfigurationVersion();
            if (string != null) {
                CV_AttributeStoredConfigurationVersionsHandler cV_AttributeStoredConfigurationVersionsHandler = new CV_AttributeStoredConfigurationVersionsHandler();
                this.myTypeOfLoadedCV = cV_AttributeStoredConfigurationVersionsHandler.getCV_Type(string);
            }
            if (this.myIsCS_UpAndRunning) {
                this.decideTypeOfServiceToBeStarted();
            }
        }
        catch (ConfigurationVersionException configurationVersionException) {
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Throwable caught.\n\tCould not decide if any service should have been started at start up of the JVM.", throwable);
        }
    }

    private String getCurrentLoadedConfigurationVersion() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentLoadedConfigurationVersion()");
        }
        String string = null;
        try {
            for (int i = 0; i < 240; ++i) {
                try {
                    if (i > 0) {
                        Thread.sleep(15000L);
                    }
                    string = this.myConfigurationVersionMoExtension.getCurrentLoadedConfigurationVersion(null);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    Trace.error(this.getClass(), "getCurrentLoadedConfigurationVersion()", "Exception caught when waiting for 15 seconds.", interruptedException);
                    continue;
                }
                catch (FroNotAccessibleException froNotAccessibleException) {
                    if (i == 0) {
                        Trace.info(this.getClass(), "getCurrentLoadedConfigurationVersion()", "FroNotAccessible caught from CV FRO (OSA) - Will retry upto 240 times with 15 seconds intervall");
                    }
                    Trace.info(this.getClass(), "getCurrentLoadedConfigurationVersion()", "Waiting 15 seconds before re-trying (" + (i + 1) + ").");
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getCurrentLoadedConfigurationVersion()", "RETURNS - theCurrentLoadedCV_Name: " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCurrentLoadedConfigurationVersion()", "Throwable caugth.\n\tFailed to retreive the current loaded CV due to unexpected exception caught.Throwable data: " + throwable, throwable);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decideTypeOfServiceToBeStarted() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "decideTypeOfServiceToBeStarted()");
        }
        try {
            if (this.myIsCS_UpAndRunning) {
                if (this.myTypeOfLoadedCV != null) {
                    SignalHandler signalHandler = new SignalHandler();
                    if (this.myTypeOfLoadedCV.equals(signalHandler.getCV_TypeName(7))) {
                        this.storeRestorePropValue("type.of.restore", "restore");
                        if (this.existsAutoConfigFile() && this.existsIP_NetworkConfigFile()) {
                            CV_ActionContinueRestoreHandler cV_ActionContinueRestoreHandler = new CV_ActionContinueRestoreHandler(this.myConfigurationVersionMoExtension);
                            cV_ActionContinueRestoreHandler.continueRestore();
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "decideTypeOfServiceToBeStarted()", "The service continueRestore has been initiated.");
                            }
                        } else if (this.existsIP_NetworkConfigFile()) {
                            CV_ActionContinueRestoreHandler cV_ActionContinueRestoreHandler = new CV_ActionContinueRestoreHandler(this.myConfigurationVersionMoExtension);
                            cV_ActionContinueRestoreHandler.continueRestore();
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "decideTypeOfServiceToBeStarted()", "The service continueRestore has been initiated when file autoconfig.xml is missing.");
                            }
                        } else if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "decideTypeOfServiceToBeStarted()", "The type of CV is downloaded when neither autoconfig nor ipnetworkdata files exists (ignoring).");
                        }
                    } else {
                        boolean bl = this.existsAutoConfigFile();
                        boolean bl2 = this.existsIP_NetworkConfigFile();
                        if (bl || bl2) {
                            String string = this.myConfigurationVersionMoExtension.getCurrentLoadedConfigurationVersion(null);
                            if (string.startsWith("RR")) {
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "decideTypeOfServiceToBeStarted()", "The currentLoadedCV is " + string + "." + "\n\tAutoConfig and/or IpNetworkConfig files found, attempting to delete them.");
                                }
                                boolean bl3 = this.deleteAutoConfigFile();
                                boolean bl4 = this.deleteIP_NetworkConfigFiles();
                                if (bl3 && bl4) {
                                    if (Trace.valid(this.getClass(), 20)) {
                                        Trace.debug(this.getClass(), 20, "decideTypeOfServiceToBeStarted()", "The AutoConfigFile and/or IpNetworkConfigFile(s) have been deleted successfully.");
                                    }
                                } else if (Trace.valid(this.getClass(), 20)) {
                                    Trace.debug(this.getClass(), 20, "decideTypeOfServiceToBeStarted()", "Failed to delete either AutoConfigFile or IpNetworkConfigFile(s).\n\tautoConfigFileDeleted: " + bl3 + "\n\tipNetworkConfigsFileDeleted: " + bl4);
                                }
                            } else if (string.startsWith("CA")) {
                                if (bl) {
                                    this.storeRestorePropValue("type.of.restore", "emergency_restore");
                                    this.startEmergencyRestore(string, bl, bl2);
                                } else {
                                    String string2 = this.readRestoreType();
                                    if (string2.equals("restore")) {
                                        CV_ActionContinueRestoreHandler cV_ActionContinueRestoreHandler = new CV_ActionContinueRestoreHandler(this.myConfigurationVersionMoExtension);
                                        cV_ActionContinueRestoreHandler.continueRestore();
                                        if (Trace.valid(this.getClass(), 22)) {
                                            Trace.debug(this.getClass(), 22, "decideTypeOfServiceToBeStarted()", "The service continueRestore has been initiated when file autoconfig.xml is missing and a CA_ CV is loaded i.e.\n\tauto configuration has been executed prior restore was confirmed.");
                                        }
                                    } else {
                                        this.startEmergencyRestore(string, bl, bl2);
                                    }
                                }
                            } else {
                                this.storeRestorePropValue("type.of.restore", "emergency_restore");
                                this.startEmergencyRestore(string, bl, bl2);
                            }
                        } else if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "decideTypeOfServiceToBeStarted()", "No service shall be auto-started.");
                        }
                    }
                } else {
                    Trace.info(this.getClass(), "decideTypeOfServiceToBeStarted()", "Not possible to decide type of service to be started since have not successfully retreived the type of loaded CV yet.");
                }
            } else {
                Trace.info(this.getClass(), "decideTypeOfServiceToBeStarted()", "Not possible to decide type of service to be started since the CS in not up and running yet.");
            }
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "decideTypeOfServiceToBeStarted()", "ConfigurationVersionException caught.");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "decideTypeOfServiceToBeStarted()", "Throwable caugth.\n\tFailed to determine if there were any type of service that should have been auto-created.Throwable data: " + throwable.toString(), throwable);
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    private void startEmergencyRestore(String string, boolean bl, boolean bl2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startEmergencyRestore(String aCurrentLoadedCV_Name, boolean anIsAutoConfigFileExists, boolean anIsIP_NetworkConfigFileExists)", "aCurrentLoadedCV_Name: " + string + "\n\tanIsAutoConfigFileExists: " + bl + "\n\tanIsIP_NetworkConfigFileExists: " + bl2);
        }
        Trace.log1(this.getClass(), "startEmergencyRestore(String aCurrentLoadedCV_Name, boolean anIsAutoConfigFileExists, boolean anIsIP_NetworkConfigFileExists)", "The service Emergency Restore is started on loaded CV '" + string + "'.");
        try {
            UpgradePackageMo upgradePackageMo = null;
            String string2 = "";
            try {
                upgradePackageMo = (UpgradePackageMo)this.myConfigurationVersionMoExtension.getCurrentUpgradePackage(null);
            }
            catch (MoRemovedException moRemovedException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "startEmergencyRestore(String aCurrentLoadedCV_Name, boolean anIsAutoConfigFileExists, boolean anIsIP_NetworkConfigFileExists)", "MoRemovedException caught,\n\tthe referenced current Upgrade Package is not present, it must be re-created before it's possible to create a CV,\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\tsending 'null' as reference for current Upgrade Package");
                }
                string2 = moRemovedException.getVariablesAsString();
            }
            CV_ActionEmergencyRestoreHandler cV_ActionEmergencyRestoreHandler = new CV_ActionEmergencyRestoreHandler(this.myConfigurationVersionMoExtension);
            cV_ActionEmergencyRestoreHandler.emergencyRestore(bl, bl2, upgradePackageMo, string2);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "startEmergencyRestore(String aCurrentLoadedCV_Name, boolean anIsAutoConfigFileExists, boolean anIsIP_NetworkConfigFileExists)", "ConfigurationVersionException caught.");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "startEmergencyRestore(String aCurrentLoadedCV_Name, boolean anIsAutoConfigFileExists, boolean anIsIP_NetworkConfigFileExists)", "Throwable caugth.\n\tFailed to start the emergency restore function.Throwable data: " + throwable.toString(), throwable);
        }
    }

    private boolean existsAutoConfigFile() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "existsAutoConfigFile()");
        }
        try {
            RestoreProperties restoreProperties = new RestoreProperties();
            String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
            File file = new File(string + "/" + "autoconfig.xml");
            boolean bl = file.exists();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "existsAutoConfigFile()", "theRestoreCV_FilePath: " + string + "\n\ttheAutoConfigFileExist: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "existsAutoConfigFile()", "Throwable caught when checking if autoConfigFile exists.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\texistsAutoConfigFile()" + "\n\tThrowable caught when checking if autoConfigFile exists." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private boolean existsIP_NetworkConfigFile() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "existsIP_NetworkConfigFile()");
        }
        try {
            RestoreProperties restoreProperties = new RestoreProperties();
            String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
            File file = new File(string + "/" + "ipnetworkconfig.xml");
            if (file.exists()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "existsIP_NetworkConfigFile()", "ipnetworkconfig.xml exists.");
                }
                return true;
            }
            File file2 = new File(string + "/" + "ipnetworkconfig2.xml");
            boolean bl = file2.exists();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "existsIP_NetworkConfigFile()", "ipnetworkconfig2.xml exists: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "existsIP_NetworkConfigFile()", "Throwable caught when checking if IpNetworkConfigFile or IpNetworkConfig2_File exists.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\texistsIP_NetworkConfigFile()" + "\n\tThrowable caught when checking if IpNetworkConfigFile or IpNetworkConfig2_File exists." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private boolean deleteAutoConfigFile() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteAutoConfigFile()");
        }
        try {
            RestoreProperties restoreProperties = new RestoreProperties();
            String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
            File file = new File(string + "/" + "autoconfig.xml");
            return file.delete();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteAutoConfigFile()", "Throwable caught when attempting to delete AutoConfigFile.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tdeleteAutoConfigFile()" + "\n\tThrowable caught when attempting to delete AutoConfigFile." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private boolean deleteIP_NetworkConfigFiles() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteIP_NetworkConfigFiles( )");
        }
        try {
            RestoreProperties restoreProperties = new RestoreProperties();
            String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
            File file = new File(string + "/" + "ipnetworkconfig.xml");
            File file2 = new File(string + "/" + "ipnetworkconfig2.xml");
            boolean bl = true;
            if (!file.delete()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "deleteIP_NetworkConfigFiles( )", "Failed to delete IpNetworkConfigFile.");
                }
                bl = false;
            }
            if (!file2.delete()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "deleteIP_NetworkConfigFiles( )", "Failed to delete IpNetworkConfig2_File.");
                }
                bl = false;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteIP_NetworkConfigFiles()", "Throwable caught when attempting to delete IpNetworkConfigFile and IpNetworkConfig2_File.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tdeleteIP_NetworkConfigFile()" + "\n\tThrowable caught when attempting to delete IpNetworkConfigFile and IpNetworkConfig2_File." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private String readRestoreType() {
        FileInputStream fileInputStream = null;
        RestoreProperties restoreProperties = new RestoreProperties();
        String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
        String string2 = string + "/" + "restore.prp";
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "readRestoreType()", "Failed to open the " + string2 + " file due to throwable caught." + "\n\tAssuming that normal restore is ongoing", throwable);
            return "restore";
        }
        Properties properties = new Properties();
        try {
            properties.load(fileInputStream);
            return properties.getProperty("type.of.restore");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "readRestoreType()", "Failed to load the properties from the " + string2 + " file, throwable caught." + "\n\tAssuming that normal restore is ongoing", throwable);
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable2) {
                Trace.error(this.getClass(), "readRestoreType()", "Failed to close the stream to the " + string2 + " file, throwable caught." + "\n\tAssuming that normal restore is ongoing", throwable2);
            }
            return "restore";
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeRestorePropValue(String string, String string2) throws TracePropertyFileHandlerException {
        FileOutputStream fileOutputStream = null;
        RestoreProperties restoreProperties = new RestoreProperties();
        String string3 = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
        String string4 = string3 + "/" + "restore.prp";
        Properties properties = new Properties();
        properties.setProperty(string, string2);
        File file = new File(string3);
        if (!file.exists()) {
            Trace.log1(this.getClass(), "storeRestorePropValue(String aPropKey, String aPropValue)", "Creating directory 'restorefiles'..");
            file.mkdir();
        }
        fileOutputStream = new FileOutputStream(string4);
        properties.store(fileOutputStream, "Auto Store Of SU Trace Properties");
        fileOutputStream.close();
        Object var10_10 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateValueInPropertyFile(String aPropKey, String aPropValue)", "Failed to close the inputstream to restore.prp, throwable caught.", throwable);
        }
        return;
        {
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "updateValueInPropertyFile(String aPropKey, String aPropValue)", "Failed to updated the restore.prp with new value, throwable caught.", throwable);
                throw new TracePropertyFileHandlerException("Failed to updated the restore.prpwith new value, throwable caught. Throwable: " + throwable);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                Trace.error(this.getClass(), "updateValueInPropertyFile(String aPropKey, String aPropValue)", "Failed to close the inputstream to restore.prp, throwable caught.", throwable2);
            }
            throw throwable;
        }
    }
}

