/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.file;

import se.ericsson.cello.configurationversion.base.InsufficientDiskSpaceOnNodeException;
import se.ericsson.cello.configurationversion.export.control.ExporterException;
import se.ericsson.cello.configurationversion.main.exception.CVFileSystemErrorException;
import se.ericsson.cello.configurationversion.main.exception.CVLLPErrorException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.handler.CV_DoesNotExistException;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_FileHandler {
    public static void copyNeededCV_FilesToC(String string, String string2) throws ConfigurationVersionException {
        if (Trace.valid(CV_FileHandler.class, 20)) {
            Trace.debug(CV_FileHandler.class, 20, "copyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)", "aCV_Name: " + string + "\n\taTmpFilePath: " + string2);
        }
        OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
        try {
            int n = osaCvMgmntProxyAccess.sendOsaCvCopyFilesFromCvReq(string, string2);
            if (n == 0) {
                return;
            }
            if (n == 6) {
                throw new CV_DoesNotExistException("Could not copy the requested restore files to C disk due to the CV does not exist.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 12) {
                throw new InsufficientDiskSpaceOnNodeException("Could not copy the requested restore files to C disk due to insufficient disk space on the Node.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 2) {
                throw new CVFileSystemErrorException("ConfigurationVersion", "Could not copy the requested restore files to C disk due to File System Error.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 4) {
                throw new CVLLPErrorException("ConfigurationVersion", "Could not copy the requested restore files to C disk due LLP error.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            throw new ExporterException("Could not copy the requested restore files to C disk due to the reason cause " + n + " (" + osaCvMgmntProxyAccess.getResultMsg(n) + ")." + "\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)" + "\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(CV_FileHandler.class, "copyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)", "Throwable caught.\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2, throwable);
            throw new ExporterException("Class name: " + CV_FileHandler.class.getName() + "\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)" + "\n\taTmpFilePath: " + string2 + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

