/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.mohandler.upgradepackage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.ChecksumUCF_Information;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.DependencyChainContainer;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageID_IllegalFormatException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.basedon.BasedOnsProxyInterface;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.interfaces.ProductDataProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageDataContainer;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class UpgradePackageMO_Handler
implements UpgradePackageMO_HandlerInterface {
    public UpgradePackageMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradePackageMO_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DependencyChainContainer getDependencyChainForUP(UpgradePackageMoExtended upgradePackageMoExtended) throws UpgradePackageMO_HandlerException {
        DependencyChainContainer dependencyChainContainer;
        block11: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getDependencyChainForUP(UpgradePackageMo anUpgradePackageMo)", "anUpgradePackageMo: " + upgradePackageMoExtended);
            }
            DocumentObjectProxyInterface documentObjectProxyInterface = null;
            try {
                if (upgradePackageMoExtended == null) {
                    throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetDependencyChainForUP(UpgradePackageMo anUpgradePackageMo)" + "\n\tCan not get the dependency chain for UP probably due to that there is no active UP on the node." + "\n\tanUpgradePackageMo: null ");
                }
                documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(upgradePackageMoExtended.getDocumentNumber(null), upgradePackageMoExtended.getDocumentRevision(null), upgradePackageMoExtended.getUpgradeControlFilePath(null), "BasedOn");
                BasedOnsProxyInterface basedOnsProxyInterface = documentObjectProxyInterface.getBasedOnsProxyInterface();
                Vector vector = basedOnsProxyInterface.getProductData();
                Iterator iterator = vector.iterator();
                UpgradePackageDataContainer upgradePackageDataContainer = null;
                ProductDataContainer productDataContainer = null;
                DependencyChainContainer dependencyChainContainer2 = new DependencyChainContainer();
                ChecksumUCF_Information checksumUCF_Information = null;
                while (iterator.hasNext()) {
                    productDataContainer = (ProductDataContainer)iterator.next();
                    checksumUCF_Information = this.getChecksums(productDataContainer.getNumber(), productDataContainer.getRevision());
                    upgradePackageDataContainer = new UpgradePackageDataContainer(productDataContainer, this.lookupActivatedTypeOfUP(productDataContainer), false, checksumUCF_Information.getChecksum(), checksumUCF_Information.getChecksumOriginal());
                    dependencyChainContainer2.addDependencyUpgradePackageDataContainer(upgradePackageDataContainer);
                }
                ProductDataProxyInterface productDataProxyInterface = documentObjectProxyInterface.getProductDataProxyInterface();
                productDataContainer = productDataProxyInterface.getProductDataRaw();
                checksumUCF_Information = this.getChecksums(productDataContainer.getNumber(), productDataContainer.getRevision());
                upgradePackageDataContainer = new UpgradePackageDataContainer(productDataContainer, this.lookupActivatedTypeOfUP(productDataContainer), true, checksumUCF_Information.getChecksum(), checksumUCF_Information.getChecksumOriginal());
                dependencyChainContainer2.setUpgradePackageDataContainer(upgradePackageDataContainer);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getDependencyChainForUP(UpgradePackageMo anUpgradePackageMo)", "Returns theDependencyChainContainer: " + dependencyChainContainer2);
                }
                dependencyChainContainer = dependencyChainContainer2;
                if (documentObjectProxyInterface == null) break block11;
            }
            catch (UpgradeControlFileParserException upgradeControlFileParserException) {
                try {
                    throw new UpgradePackageMO_HandlerException(upgradeControlFileParserException.toString());
                    catch (UpgradePackageMO_HandlerException upgradePackageMO_HandlerException) {
                        throw new UpgradePackageMO_HandlerException(upgradePackageMO_HandlerException.toString());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "getDependencyChainForUP(UpgradePackageMo anUpgradePackageMo)", "Throwable caught when attempting to retreive the dependency chain for the UP.\n\tanUpgradePackageMo: " + upgradePackageMoExtended, throwable);
                        throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetDependencyChainForUP(UpgradePackageMo anUpgradePackageMo)" + "\n\tThrowable caught when attempting to retreive the dependency chain for the UP." + "\n\tanUpgradePackageMo: " + upgradePackageMoExtended + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
                    }
                }
                catch (Throwable throwable) {
                    if (documentObjectProxyInterface != null) {
                        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    }
                    throw throwable;
                }
            }
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
        }
        return dependencyChainContainer;
    }

    private ChecksumUCF_Information getChecksums(String string, String string2) throws UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getChecksums(String aProdNo, String aProdRev)", "aProdNo: " + string + "\n\taProdRev: " + string2);
        }
        try {
            String string3 = "";
            String string4 = "";
            UpgradePackageMoExtended upgradePackageMoExtended = this.getUpgradePackageMo(string, string2);
            if (upgradePackageMoExtended != null) {
                string3 = upgradePackageMoExtended.getUcfChecksum(null);
                string4 = upgradePackageMoExtended.getOrigUcfChecksum(null);
            }
            ChecksumUCF_Information checksumUCF_Information = new ChecksumUCF_Information(string3, string4);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getChecksums(String aProdNo, String aProdRev)", "RETURNS -- theChecksumUCF_Information: " + checksumUCF_Information);
            }
            return checksumUCF_Information;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getChecksums(String aProdNo, String aProdRev)", "aProdNo: " + string + "\n\taProdRev: " + string2, throwable);
            throw new UpgradePackageMO_HandlerException(throwable.toString());
        }
    }

    public UpgradePackageMoExtended getPreUpgradedUP() throws UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPreUpgradedUP()");
        }
        try {
            Iterator iterator = this.getUpgradePackageMOs().iterator();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            while (iterator.hasNext()) {
                upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "theUP_MO:" + upgradePackageMoExtended + "\n\tPreUpgradeState: " + upgradePackageMoExtended.getPreUpgradeState(null));
                }
                if (upgradePackageMoExtended.getPreUpgradeState(null) == 2) break;
                upgradePackageMoExtended = null;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getPreUpgradedUP()", "RETURNS - theUP_MO: " + upgradePackageMoExtended);
            }
            return upgradePackageMoExtended;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPreUpgradedUP()", "Throwable caught when trying to find a pre upgraded UP.\n\tThrowable: " + throwable);
            throw new UpgradePackageMO_HandlerException(throwable.toString());
        }
    }

    public UpgradePackageMoExtended getUpWithState(int n) throws UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpWithState(int aState)", "aState: " + n);
        }
        try {
            Iterator iterator = this.getUpgradePackageMOs().iterator();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            while (iterator.hasNext() && (upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next()).getStateValue() != n) {
                upgradePackageMoExtended = null;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getUpWithState(int aState)", "RETURNS - theUP_MO: " + upgradePackageMoExtended);
            }
            return upgradePackageMoExtended;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getUpWithState(int aState)", "aState: " + n + "\n\tThrowable caught when trying to find a pre upgraded UP." + "\n\tThrowable: " + throwable);
            throw new UpgradePackageMO_HandlerException(throwable.toString());
        }
    }

    public UpgradePackageMoExtended getExecutingUpgradePackageMO() throws UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingUpgradePackageMO ()");
        }
        try {
            Collection collection = this.getUpgradePackageMOs();
            Iterator iterator = collection.iterator();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            while (iterator.hasNext()) {
                upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next();
                int n = upgradePackageMoExtended.getState(null);
                if (n != 2) continue;
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getExecutingUpgradePackageMO()", "RETURNS - " + upgradePackageMoExtended);
                }
                return upgradePackageMoExtended;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getExecutingUpgradePackageMO()", "No executing Upgrade Package Mo was found (with state UPGRADE_EXCUTING).");
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExecutingUpgradePackageMO ()", "Throwable caught when trying to find out if upgrade is in execution.\n\tThrowable data: " + throwable.toString());
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "getExecutingUpgradePackageMO ()" + "Throwable caught when trying to find out if upgrade is in execution." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public UpgradePackageMoExtended getUpgradePackageMo(String string) throws UpgradePackageID_IllegalFormatException, UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageMo(String anUpgradePackageID)", "anUpgradePackageID: " + string);
        }
        ProductNumberAndRevision productNumberAndRevision = this.getProductNumberAndRevision(string);
        return this.lookupUpgradePackageMO(productNumberAndRevision.productNumber, productNumberAndRevision.revision);
    }

    public UpgradePackageMoExtended getUpgradePackageMo(String string, String string2) throws UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageMo(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        return this.lookupUpgradePackageMO(string, string2);
    }

    private ProductNumberAndRevision getProductNumberAndRevision(String string) throws UpgradePackageID_IllegalFormatException {
        int n;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProductNumberAndRevision(String anUpgradePackageID)", "anUpgradePackageID: " + string);
        }
        if ((n = string.lastIndexOf("_")) == -1) {
            throw new UpgradePackageID_IllegalFormatException("The CV is not connected to an Upgrade Package.\n\tThe upgrade package ID is in illegal format (default value is (Not Available) when not connected to an UP i.e. it shall has the format \n\tProductNumber_Revision.\n\tThe received ID is '" + string + "'.");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        return new ProductNumberAndRevision(string2, string3);
    }

    private ActivatedTypeOfUP lookupActivatedTypeOfUP(ProductDataContainer productDataContainer) throws MoAccessException {
        UpgradePackageMoExtended upgradePackageMoExtended;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lookupActivatedTypeOfUP(ProductDataContainer aProductDataContainer)", "aProductDataContainer: " + productDataContainer);
        }
        if ((upgradePackageMoExtended = this.lookupUpgradePackageMO(productDataContainer.getNumber(), productDataContainer.getRevision())) == null) {
            Trace.warning(this.getClass(), "lookupActivatedTypeOfUP(ProductDataContainer aProductDataContainer)", "No Upgrade Package MO found with product data: " + productDataContainer);
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tlookupActivatedTypeOfUP(ProductDataContainer aProductDataContainer)" + "\n\tNo Upgrade Package MO found with product data: " + productDataContainer);
        }
        return ActivatedTypeOfUP.getInstance(upgradePackageMoExtended.getActivatedTypeOfUP(null));
    }

    private UpgradePackageMoExtended lookupUpgradePackageMO(String string, String string2) throws UpgradePackageMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lookupUpgradePackageMO(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                String string3 = null;
                String string4 = null;
                while (moIterator.hasMoreElements()) {
                    UpgradePackageMoExtended upgradePackageMoExtended = (UpgradePackageMoExtended)moIterator.nextMo();
                    string3 = upgradePackageMoExtended.getDocumentNumber(null);
                    string4 = upgradePackageMoExtended.getDocumentRevision(null);
                    if (StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string3, string) && StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string4, string2)) {
                        return upgradePackageMoExtended;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "lookupUpgradePackageMO(String aProductNumber, String aProductRevision)", "Given ProductNumber: " + string + "\n\tand ProductRevision: " + string2 + "\n\tCurrent instance ProductNumber: " + string3 + "\n\tand ProductRevision: " + string4);
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "lookupUpgradePackageMO(String aProductNumber, String aProductRevision)", "No UP MO was found for given product number: " + string + "\n\tand revision: " + string2);
                }
                return null;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "lookupUpgradePackageMO(String aProductNumber, String aProductRevision)", "No UP MOs exists on the node.\n\tRequested ProductNumber: " + string + "\n\tand revision: " + string2);
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "lookupUpgradePackageMO(String aProductNumber, String aProductRevision) ", "Throwable caught when attempting to find UP MO with productNumber: " + string + " and revision: " + string2, throwable);
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tlookupUpgradePackageMO(String aProductNumber, String aProductRevision)" + "\n\taProductNumber: " + string + "\n\taaProductRevision: " + string2 + "\n\tThrowable caught when attempting to look up an UP MO." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public Collection getUpgradePackageMosOfType(ActualTypeOfUP actualTypeOfUP) throws UpgradePackageMO_HandlerException {
        String string = "getUpgradePackageMosOfType ( ActualTypeOfUP anActualTypeOfUP)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anActualTypeOfUP: " + actualTypeOfUP);
        }
        try {
            Collection collection = this.getUpgradePackageMOs();
            Iterator iterator = collection.iterator();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            ActualTypeOfUP actualTypeOfUP2 = null;
            HashSet<UpgradePackageMoExtended> hashSet = new HashSet<UpgradePackageMoExtended>();
            while (iterator.hasNext()) {
                upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next();
                actualTypeOfUP2 = ActualTypeOfUP.getInstance(upgradePackageMoExtended.getActualTypeOfUP(null));
                if (!actualTypeOfUP2.equals(actualTypeOfUP)) continue;
                hashSet.add(upgradePackageMoExtended);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theUP_MOsOfActualType: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\tanActualTypeOfUP: " + actualTypeOfUP, throwable);
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tanActualTypeOfUP: " + actualTypeOfUP + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getLoadModulesInDynClassPath() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesInDynClassPath");
        }
        HashSet<LoadModuleMoSU_Access> hashSet = new HashSet<LoadModuleMoSU_Access>();
        try {
            Collection collection = this.getUpgradePackageMOs();
            Iterator iterator = collection.iterator();
            ManagedObject[] managedObjectArray = null;
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            while (iterator.hasNext()) {
                upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next();
                managedObjectArray = upgradePackageMoExtended.getDynamicClassPath(null);
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    hashSet.add((LoadModuleMoSU_Access)managedObjectArray[i]);
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getLoadModulesInDynClassPath", "RETURNS - theLMs: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "getLoadModulesInDynClassPath", "Throwable caught (ignored).Throwable data: " + throwable);
            return hashSet;
        }
    }

    public Collection getUpgradePackageMOs() throws UpgradePackageMO_HandlerException {
        String string = "getUpgradePackageMOs (boolean anExcludeObsoleteLmUp)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            while (moIterator != null && moIterator.hasMoreElements()) {
                hashSet.add(moIterator.nextMo());
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theUP_MOs: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getLoadModulesThatNotExists(ProductNumbersAndRevisions productNumbersAndRevisions, Collection collection) throws UpgradePackageMO_HandlerException {
        String string = "getLoadModulesThatNotExists (ProductNumbersAndRevisions anAllLMs, Collection aLMs)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anAllLMs: " + productNumbersAndRevisions + "\n\taLMs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            HashSet<ProductNumberAndRevision> hashSet = new HashSet<ProductNumberAndRevision>();
            if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                while (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    productNumberAndRevision = new ProductNumberAndRevision(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null));
                    if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                    hashSet.add(productNumberAndRevision);
                }
            } else {
                while (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    productNumberAndRevision = new ProductNumberAndRevision(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)));
                    if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                    hashSet.add(productNumberAndRevision);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theNotExistingLMs: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\tanAllLMs: " + productNumbersAndRevisions + "\n\taLMs: " + collection, throwable);
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tanAllLMs: " + productNumbersAndRevisions + "\n\taLMs: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public ProductNumbersAndRevisions addNotExistingLMs(ProductNumbersAndRevisions productNumbersAndRevisions, ProductNumbersAndRevisions productNumbersAndRevisions2) throws UpgradePackageMO_HandlerException {
        String string = "addNotExistingLMs (ProductNumbersAndRevisions theAllLMsDefinedInUCF, ProductNumbersAndRevisions theLMsDefinedInUCF)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "theAllLMsDefinedInUCF: " + productNumbersAndRevisions + "\n\ttheLMsDefinedInUCF: " + productNumbersAndRevisions2);
        }
        try {
            Iterator iterator = productNumbersAndRevisions2.getElements().iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                productNumbersAndRevisions.addElement(productNumberAndRevision);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theAllLMs: " + productNumbersAndRevisions);
            }
            return productNumbersAndRevisions;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\ttheAllLMsDefinedInUCF: " + productNumbersAndRevisions + "\n\ttheLMsDefinedInUCF: " + productNumbersAndRevisions2, throwable);
            throw new UpgradePackageMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\ttheAllLMsDefinedInUCF: " + productNumbersAndRevisions + "\n\ttheLMsDefinedInUCF: " + productNumbersAndRevisions2 + "\n\tOriginal Throwable: " + throwable);
        }
    }
}

