/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.base;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.su.convert.base.ConverterState;
import se.ericsson.cello.su.convert.base.UpgradeConvertMoClassAndStepInfoConstants;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradeConvertInfoHandler {
    private static Class[] myParameterTypes = new Class[0];
    private static String myMethodName = "getMoDataRevision";

    public static HashMap getCurrentMoDataRevisions() throws SuConverterException {
        if (Trace.valid(UpgradeConvertInfoHandler.class, 20)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 20, "getCurrentMoDataRevisions()");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = null;
        Integer n = null;
        String[] stringArray = UpgradeConvertMoClassAndStepInfoConstants.getSuConvertMoClassNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                string = stringArray[i];
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getDeclaredMethod(myMethodName, myParameterTypes);
                n = (Integer)method.invoke(clazz, (Object[])myParameterTypes);
                hashMap.put(UpgradeConvertInfoHandler.getMoTypeName(string), n);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.error(UpgradeConvertInfoHandler.class, "getCurrentSU_MoDataRevisions(String[] aClassNames)", "The class included in ConvertClassAndStepContainer could not be found .\n\ttheSuConvertMoClassName: " + string);
                throw new SuConverterException("The class included in ConvertClassAndStepContainer could not be found.");
            }
            catch (Throwable throwable) {
                Trace.error(UpgradeConvertInfoHandler.class, "getCurrentSU_MoDataRevisions(String[] aClassNames)", "Failed to get the MoDataRevision for " + string + ", throwable caught.", throwable);
                throw new SuConverterException("Failed to get the MoDataRevision for " + string + ", throwable caught.");
            }
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "getCurrentMoDataRevisions()", "Returning - theSU_MoDataRevisions: " + hashMap);
        }
        return hashMap;
    }

    public static HashMap getPreviousMoDataRevisions(HashMap hashMap) {
        Trace.debug(UpgradeConvertInfoHandler.class, 20, "getPreviousMoDataRevisions(HashMap aConverterDbTableData)", "aConverterDbTableData: " + hashMap);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        String string = null;
        String string2 = null;
        String string3 = null;
        Map.Entry entry = null;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            string3 = UpgradeConvertInfoHandler.getMoTypeNameFromDbKey(string);
            if (string3 == null) continue;
            string2 = (String)entry.getValue();
            if (Trace.valid(class$se$ericsson$cello$su$convert$base$UpgradeConvertInfoHandler == null ? UpgradeConvertInfoHandler.class$("se.ericsson.cello.su.convert.base.UpgradeConvertInfoHandler") : class$se$ericsson$cello$su$convert$base$UpgradeConvertInfoHandler, 22)) {
                Trace.debug(class$se$ericsson$cello$su$convert$base$UpgradeConvertInfoHandler == null ? UpgradeConvertInfoHandler.class$("se.ericsson.cello.su.convert.base.UpgradeConvertInfoHandler") : class$se$ericsson$cello$su$convert$base$UpgradeConvertInfoHandler, 22, "getPreviousMoDataRevisions(HashMap aConverterDbTableData)", "Mo Type name and revision found in converter DB table.\n\ttheSU_ConvertTypeName: " + string3 + "\n\ttheSU_ConverterValue: " + string2);
            }
            hashMap2.put(string3, new Integer(string2));
        }
        Trace.debug(UpgradeConvertInfoHandler.class, 21, "getPreviousMoDataRevisions(HashMap aConverterDbTableData)", "Returning - thePreviousMoDataRevisions: " + hashMap2);
        return hashMap2;
    }

    private static String getMoTypeNameFromDbKey(String string) {
        Trace.debug(UpgradeConvertInfoHandler.class, 20, "getMoTypeNameFromDbKey(String aConverterDbTableDataKey)", "aConverterDbTableDataKey: " + string);
        String string2 = null;
        if (string.startsWith("moType ")) {
            string2 = string.substring("moType ".length());
        }
        Trace.debug(UpgradeConvertInfoHandler.class, 20, "getMoTypeNameFromDbKey(String aConverterDbTableDataKey)", "Returning - theMoTypeName: " + string2);
        return string2;
    }

    public static Collection getSystemUpgradeMoTypeNames() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = UpgradeConvertMoClassAndStepInfoConstants.getSuConvertMoClassNames();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(UpgradeConvertInfoHandler.getMoTypeName(stringArray[i]));
        }
        return vector;
    }

    public static String getClassName(String string) {
        String string2 = "Not found";
        String[] stringArray = UpgradeConvertMoClassAndStepInfoConstants.getSuConvertMoClassNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(string) == -1) continue;
            string2 = stringArray[i];
            break;
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "getClassName(String aMoTypeName)", "Returning - theClassName: " + string2);
        }
        return string2;
    }

    public static ConverterState getConverterState(HashMap hashMap) {
        ConverterState converterState = ConverterState.UPGRADE;
        String string = (String)hashMap.get("convertState");
        if (Trace.valid(UpgradeConvertInfoHandler.class, 23)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 23, "getConverterState(HashMap aDbTableInformation)", "theConverterStateString: " + string);
        }
        if (string == null) {
            if (Trace.valid(UpgradeConvertInfoHandler.class, 22)) {
                Trace.debug(UpgradeConvertInfoHandler.class, 22, "getRecordConvertToFile(HashMap aDbTableInformation)", "Attribute convertState not found in DbTableInformation, value 'upgrade' will be used.");
            }
        } else {
            Integer n = new Integer(string);
            if (n.intValue() == ConverterState.PREUPGRADE.getValue()) {
                converterState = ConverterState.PREUPGRADE;
            } else if (n.intValue() == ConverterState.RESTORE.getValue()) {
                converterState = ConverterState.RESTORE;
            }
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "getConverterState(HashMap aDbTableInformation)", "Returning - theConverterState: " + converterState);
        }
        return converterState;
    }

    public static String getUpDirPath(HashMap hashMap) {
        String string = (String)hashMap.get("upDirPath");
        if (string == null && Trace.valid(UpgradeConvertInfoHandler.class, 22)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 22, "getUpDirPath(HashMap aDbTableInformation)", "Attribute upDirPath not found in DbTableInformation, it will not be possible to handle Unconvert files.");
        }
        return string;
    }

    public static HashMap convertDbTableInformationToNewFormat(HashMap hashMap) throws SuConverterException {
        if (Trace.valid(UpgradeConvertInfoHandler.class, 20)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 20, "convertDbTableInformationToNewFormat(HashMap aDbTableInformation)", "anOldDbTableInformation: " + hashMap);
        }
        HashMap hashMap2 = new HashMap();
        Collection collection = UpgradeConvertInfoHandler.getSystemUpgradeMoTypeNames();
        Map.Entry entry = null;
        String string = null;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            if (collection.contains(string)) {
                hashMap2.put("moType " + string, entry.getValue());
                continue;
            }
            hashMap2.put(string, entry.getValue());
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "convertDbTableInformationToNewFormat(HashMap anOldDbTableInformation)", "Returning - theNewDbTableInformation: " + hashMap2);
        }
        return hashMap2;
    }

    public static HashMap createDbTableInformation(ConverterState converterState, String string) throws SuConverterException {
        if (Trace.valid(UpgradeConvertInfoHandler.class, 20)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 20, "createDbTableInformation(ConvertState aConvertState, String anUP_DirPath)", "aConvertState: " + converterState + "\n\tanUP_DirPath: " + string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("convertState", Integer.toString(converterState.getValue()));
        hashMap.put("upDirPath", string);
        HashMap hashMap2 = UpgradeConvertInfoHandler.getCurrentMoDataRevisions();
        Iterator iterator = hashMap2.entrySet().iterator();
        Map.Entry entry = null;
        String string2 = null;
        Integer n = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            string2 = (String)entry.getKey();
            n = (Integer)entry.getValue();
            hashMap.put("moType " + string2, n.toString());
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "createDbTableInformation(ConvertState aConvertState, String anUP_DirPath)", "Returning - theDbTableInformation: " + hashMap);
        }
        return hashMap;
    }

    public static Integer getMoDataVersion(HashMap hashMap, String string) {
        Integer n = (Integer)hashMap.get(string);
        if (n == null) {
            n = new Integer(0);
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "getMoDataVersion(HashMap aMoDataRevisions, String aMoTypeName)", "aMoTypeName: " + string + "\n\tReturning - theOldMoDataRevision: " + n);
        }
        return n;
    }

    private static String getMoTypeName(String string) {
        String string2 = "Not found";
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string2;
        }
        String string3 = string.substring(n + 1);
        if ((n = string3.indexOf("MoImpl")) != -1) {
            string2 = string3.substring(0, n);
        }
        if (Trace.valid(UpgradeConvertInfoHandler.class, 21)) {
            Trace.debug(UpgradeConvertInfoHandler.class, 21, "getMoTypeName(String aClassName) ", "aClassName: " + string + "\n\tReturning - theTypeName: " + string2);
        }
        return string2;
    }
}

