/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StructUtils;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstance;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstanceException;

public class ProgramInstances {
    private Collection myProgramInstances = new LinkedList();

    public ProgramInstances(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProgramInstances (Collection aProgramInstances)", (String)("aProgramInstances: " + collection));
        }
        LinkedList linkedList = new LinkedList(collection);
        this.myProgramInstances = (Collection)linkedList.clone();
    }

    public ProgramInstances() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProgramInstances ()");
        }
    }

    public ProgramInstances(Struct[] structArray) throws ProgramInstanceException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProgramInstances (Struct[] aProgramInstances)", (String)("aProgramInstances" + StructUtils.toString(structArray)));
        }
        for (int i = 0; i < structArray.length; ++i) {
            this.add(new ProgramInstance(structArray[i]));
        }
    }

    public ProgramInstances(String string) throws ProgramInstanceException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProgramInstances(String aProgramInstancesAsString)", (String)("aProgramInstancesAsString" + string));
        }
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.add(new ProgramInstance(stringTokenizer.nextToken()));
            }
        }
    }

    public void add(ProgramInstance programInstance) {
        HashSet hashSet;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"add (ProgramInstance aProgramInstance)", (String)("aProgramInstance: " + programInstance));
        }
        if (!(hashSet = this.toSimpleHashFormat()).contains(programInstance.toSimpleHashFormat())) {
            this.myProgramInstances.add(programInstance);
        } else if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"add (ProgramInstance aProgramInstance)", (String)("The program instance was not added due to it already exists.\n\taProgramInstance: " + programInstance + "\n\tmyProgramInstances: " + this.myProgramInstances));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ProgramInstances) {
            if (this.myProgramInstances.size() != ((ProgramInstances)object).size()) {
                return false;
            }
            HashSet hashSet = this.toSimpleHashFormat();
            HashSet hashSet2 = ((ProgramInstances)object).toSimpleHashFormat();
            Iterator iterator = hashSet.iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (hashSet2.contains(string)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public int size() {
        return this.myProgramInstances.size();
    }

    public HashSet toSimpleHashFormat() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"toSimpleHashFormat ()");
        }
        Iterator iterator = this.myProgramInstances.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            hashSet.add(((ProgramInstance)iterator.next()).toSimpleHashFormat());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getProgramInstancesAsStructArray ()", (String)("RETURNS - " + hashSet));
        }
        return hashSet;
    }

    public Collection getProgramInstances() {
        return this.myProgramInstances;
    }

    public Struct[] getProgramInstancesAsStructArray() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProgramInstancesAsStructArray ()");
        }
        Iterator iterator = this.myProgramInstances.iterator();
        ProgramInstance programInstance = null;
        Struct struct = null;
        Struct[] structArray = new Struct[this.myProgramInstances.size()];
        int n = 0;
        while (iterator.hasNext()) {
            programInstance = (ProgramInstance)iterator.next();
            structArray[n] = struct = programInstance.toStruct();
            ++n;
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getProgramInstancesAsStructArray ()", (String)("RETURNS - " + StructUtils.toString(structArray)));
        }
        return structArray;
    }

    public String toString() {
        return "\n\tprogramInstances: " + this.myProgramInstances;
    }

    public String toStringPure() {
        String string = "";
        Iterator iterator = this.myProgramInstances.iterator();
        ProgramInstance programInstance = null;
        while (iterator.hasNext()) {
            programInstance = (ProgramInstance)iterator.next();
            string = string + programInstance.toStringPure();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

