/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.signedsw;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.SswUninstallCertResultInformation;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.verify.ssw.CrlAndCertificateLM_InfoContainer;

public class CrlAndCertificateUnloader {
    public CrlAndCertificateUnloader() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CrlAndCertificateUnloader( )");
        }
    }

    public void unloadCrlsAndCertificatesForToState() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unloadCrlsAndCertificatesForToState( )");
        }
        try {
            Collection collection = UpgradeDB_StorageUtil.getAllLoadedCertInfo();
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer = null;
                OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
                while (iterator.hasNext()) {
                    crlAndCertificateLM_InfoContainer = (CrlAndCertificateLM_InfoContainer)iterator.next();
                    this.unloadCrlsAndCertificatesForToState(osaSwInstallProxyAccess, crlAndCertificateLM_InfoContainer);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "unloadCrlsAndCertificatesForToState( )", "Throwable caught, (execution continues anyway)", throwable);
        }
    }

    public void unloadCrlsAndCertificatesForToState(UpgradePackageMoExtended upgradePackageMoExtended) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unloadCrlsAndCertificatesForToState(UpgradePackageMoExtended anUpgradePackageMoExtended)", "anUpgradePackageMoExtended: " + upgradePackageMoExtended);
        }
        try {
            if (upgradePackageMoExtended.getPreUpgradeState(null) != 2) {
                this.unloadCrlsAndCertificatesForToState();
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "unloadCrlsAndCertificatesForToState(UpgradePackageMoExtended anUpgradePackageMoExtende)", "Throwable caught, (execution continues anyway)", throwable);
        }
    }

    private void unloadCrlsAndCertificatesForToState(OsaSwInstallProxyAccess osaSwInstallProxyAccess, CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unloadCrlsAndCertificatesForToState(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "anOsaSwInstallProxyAccess:" + osaSwInstallProxyAccess + "\n\taCrlAndCertificateLM_InfoContainer:" + crlAndCertificateLM_InfoContainer);
        }
        try {
            int n = crlAndCertificateLM_InfoContainer.getSMN() + crlAndCertificateLM_InfoContainer.getAPN();
            SswUninstallCertResultInformation sswUninstallCertResultInformation = osaSwInstallProxyAccess.sendOsaSswUninstallCertReq(n, crlAndCertificateLM_InfoContainer.getSMN(), crlAndCertificateLM_InfoContainer.getAPN(), crlAndCertificateLM_InfoContainer.getFilePaths());
            if (sswUninstallCertResultInformation.result == 0) {
                UpgradeDB_StorageUtil.removeLoadedCertInfo(crlAndCertificateLM_InfoContainer);
            } else {
                Trace.error(this.getClass(), "unloadCrlsAndCertificatesForToState(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Unloading of CRLs and certificates failed according to result returned in response signal, (execution continues anyway)\n\tSMN: " + crlAndCertificateLM_InfoContainer.getSMN() + "\n\tAPN: " + crlAndCertificateLM_InfoContainer.getAPN() + "\n\tCrlAndCertificateLM_Paths: " + crlAndCertificateLM_InfoContainer.getFilePaths());
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "unloadCrlsAndCertificatesForToState(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Unloading of CRLs and certificates failed due to FroNotAccessibleException, (execution continues anyway)\n\tSMN: " + crlAndCertificateLM_InfoContainer.getSMN() + "\n\tAPN: " + crlAndCertificateLM_InfoContainer.getAPN() + "\n\tCrlAndCertificateLM_Paths: " + crlAndCertificateLM_InfoContainer.getFilePaths(), froNotAccessibleException);
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            Trace.error(this.getClass(), "unloadCrlsAndCertificatesForToState(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Removal of information about loaded CRLs and certificates in database failed, (execution continues anyway)\n\tSMN: " + crlAndCertificateLM_InfoContainer.getSMN() + "\n\tAPN: " + crlAndCertificateLM_InfoContainer.getAPN() + "\n\tCrlAndCertificateLM_Paths: " + crlAndCertificateLM_InfoContainer.getFilePaths(), (Throwable)((Object)upgradeDB_StorageHandlerException));
        }
    }
}

