/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.xmlparser.backuprestore;

import java.util.Collection;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Enumer;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.MandatoryAttributeMissingException;
import se.ericsson.cello.su.xmlparser.base.MandatoryElementMissingException;
import se.ericsson.cello.su.xmlparser.base.UnsupportedAttributeException;
import se.ericsson.cello.su.xmlparser.base.UnsupportedElementException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XmlElement;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class BackupRestoreXmlProperty
extends Enumer {
    protected boolean isMandatory = false;
    protected String mySyntaxVersion = "1";

    protected BackupRestoreXmlProperty(String string, boolean bl) {
        super(string);
        this.isMandatory = bl;
    }

    protected BackupRestoreXmlProperty(String string, boolean bl, String string2) {
        super(string);
        this.isMandatory = bl;
        this.mySyntaxVersion = string2;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public static void errorAttributeMissing(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws ValidateException {
        String string5 = "XML file " + string2 + "," + "\n\tmandatory attribute missing: " + "attribute " + string4 + " not found in element of type " + string3 + ".";
        Trace.error(clazz, string, string5 + LocatorProxy.getLocatorInfo(locator));
        throw new MandatoryAttributeMissingException(string5, locator);
    }

    public static void errorUnexpectedAttribute(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws ValidateException {
        String string5 = "XML file " + string2 + "," + "\n\tunexpected attribute: " + "attribute " + string4 + " is not expected in element of type " + string3 + " when version = " + BackupRestoreDataHandler.instance().getCurrentVersion();
        Trace.error(clazz, string, string5 + LocatorProxy.getLocatorInfo(locator));
        throw new UnsupportedAttributeException(string5, locator);
    }

    public static void errorElementMissing(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws ValidateException {
        String string5 = "XML file " + string2 + "," + "\n\telement '" + string3 + "' " + " does not contain mandatory child element '" + string4 + "'.";
        Trace.error(clazz, string, string5 + LocatorProxy.getLocatorInfo(locator));
        throw new MandatoryElementMissingException(string5, locator);
    }

    public static void errorUnexpectedElement(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws UnsupportedElementException {
        String string5 = "XML file " + string2 + "," + "\n\tthe child element '" + string4 + "' " + "\n\twith parentElementName '" + string3 + "'" + "\n\tis not expected in version '" + BackupRestoreDataHandler.instance().getCurrentVersion() + "'.";
        Trace.error(clazz, string, string5 + LocatorProxy.getLocatorInfo(locator));
        throw new UnsupportedElementException(string5, locator);
    }

    public static String[] verifyNames(AttributeList attributeList, String[] stringArray) {
        if (Trace.valid(BackupRestoreXmlProperty.class, 20)) {
            Trace.debug(BackupRestoreXmlProperty.class, 20, "verifyNames ( AttributeList anAttributeList, String[] anAttributeNameList )", "anAttributeList: " + attributeList + "\n\tanAttributeNameList: " + SuLib.toString(stringArray));
        }
        if (stringArray == null || attributeList == null) {
            Trace.error(BackupRestoreXmlProperty.class, "verifyNames(AttributeList anAttributeList, String[] anAttributeNameList)", "Invalid input data, anAttributeNameList or/ and anAttributeList is set to null\n\tanAttributeList: " + attributeList + "\n\tanAttributeNameList: " + SuLib.toString(stringArray));
            return null;
        }
        Vector<String> vector = new Vector<String>(0);
        for (int i = 0; i < attributeList.getLength(); ++i) {
            if (BackupRestoreXmlProperty.isAttributeNameKnown(attributeList.getName(i), stringArray)) continue;
            vector.addElement(attributeList.getName(i));
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    public static String[] verifyNoNames(AttributeList attributeList) {
        if (Trace.valid(BackupRestoreXmlProperty.class, 20)) {
            Trace.debug(BackupRestoreXmlProperty.class, 20, "verifyNoNames ( AttributeList anAttributeList )", "anAttributeList: " + attributeList);
        }
        if (attributeList == null) {
            Trace.error(BackupRestoreXmlProperty.class, "verifyNoNames ( AttributeList anAttributeList )", "Invalid input data, anAttributeList is set to null\n\tanAttributeList: null");
            return null;
        }
        int n = attributeList.getLength();
        String[] stringArray = new String[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringArray[i] = attributeList.getName(i);
            }
        }
        return stringArray;
    }

    protected void validate(String string, String string2, String string3, Locator locator) throws ValidateException {
        if (string3 == null) {
            if (this.isMandatory && (this.currentVersionIsLargerThanSyntaxVersion() || this.currentVersionIsEqualToSyntaxVersion())) {
                BackupRestoreXmlProperty.errorAttributeMissing(this.getClass(), "validate(String anAbsoluteFilePath, String anElementName, String anAttributeValue, Locator aLocator)", string, string2, this.getValue(), locator);
            }
        } else if (this.currentVersionIsSmallerThanSyntaxVersion()) {
            BackupRestoreXmlProperty.errorUnexpectedAttribute(this.getClass(), "validate(String anAbsoluteFilePath, String anElementName, String anAttributeValue, Locator aLocator)", string, string2, this.getValue(), locator);
        }
    }

    protected void validate(String string, String string2, XmlElement xmlElement, Locator locator) throws ValidateException {
        if (xmlElement == null) {
            if (this.isMandatory && (this.currentVersionIsLargerThanSyntaxVersion() || this.currentVersionIsEqualToSyntaxVersion())) {
                BackupRestoreXmlProperty.errorElementMissing(this.getClass(), "validate(String anAbsoluteFilePath, String aParentElementName, XML_Element aChildElement, Locator aLocator)", string, string2, this.getValue(), locator);
            }
        } else if (this.currentVersionIsSmallerThanSyntaxVersion()) {
            BackupRestoreXmlProperty.errorUnexpectedElement(this.getClass(), "validate(String anAbsoluteFilePath, String aParentElementName, XML_Element aChildElement, Locator aLocator)", string, string2, this.getValue(), locator);
        }
    }

    protected void validate(String string, String string2, Collection collection, Locator locator) throws ValidateException {
        if (collection.isEmpty()) {
            if (this.isMandatory && (this.currentVersionIsLargerThanSyntaxVersion() || this.currentVersionIsEqualToSyntaxVersion())) {
                BackupRestoreXmlProperty.errorElementMissing(this.getClass(), "validate(String anAbsoluteFilePath, String aParentElementName, Collection aChildrenElements, Locator aLocator)", string, string2, this.getValue(), locator);
            }
        } else if (this.currentVersionIsSmallerThanSyntaxVersion()) {
            BackupRestoreXmlProperty.errorUnexpectedElement(this.getClass(), "validate(String anAbsoluteFilePath, String aParentElementName, Collection aChildrenElements, Locator aLocator)", string, string2, this.getValue(), locator);
        }
    }

    private static boolean isAttributeNameKnown(String string, String[] stringArray) {
        if (Trace.valid(BackupRestoreXmlProperty.class, 20)) {
            Trace.debug(BackupRestoreXmlProperty.class, 20, "isAttributeNameKnown ( String anAttributeName, String[] anAttributeNameList )", "anAttributeName: " + string + "\n\tanAttributeNameList: " + SuLib.toString(stringArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (Trace.valid(class$se$ericsson$cello$su$xmlparser$backuprestore$BackupRestoreXmlProperty == null ? BackupRestoreXmlProperty.class$("se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreXmlProperty") : class$se$ericsson$cello$su$xmlparser$backuprestore$BackupRestoreXmlProperty, 22)) {
                Trace.debug(class$se$ericsson$cello$su$xmlparser$backuprestore$BackupRestoreXmlProperty == null ? BackupRestoreXmlProperty.class$("se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreXmlProperty") : class$se$ericsson$cello$su$xmlparser$backuprestore$BackupRestoreXmlProperty, 22, "isAttributeNameKnown ( String anAttributeName, String[] anAttributeNameList )", "anAttributeNameList[" + i + "]: " + stringArray[i]);
            }
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean currentVersionIsSmallerThanSyntaxVersion() {
        return this.getCurrentVersionAsInt() < this.getSyntaxVersionAsInt();
    }

    private boolean currentVersionIsEqualToSyntaxVersion() {
        return this.getCurrentVersionAsInt() == this.getSyntaxVersionAsInt();
    }

    private boolean currentVersionIsLargerThanSyntaxVersion() {
        return this.getCurrentVersionAsInt() > this.getSyntaxVersionAsInt();
    }

    private int getSyntaxVersionAsInt() {
        Integer n = new Integer(this.mySyntaxVersion);
        return n;
    }

    private int getCurrentVersionAsInt() {
        Integer n = new Integer(BackupRestoreDataHandler.instance().getCurrentVersion());
        return n;
    }
}

