/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.xmlparser.base;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;
import se.ericsson.cello.su.xmlparser.base.IllegalXML_AttributeValueException;
import se.ericsson.cello.su.xmlparser.base.UnexpectedXML_ElementException;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_AttributeException;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_ElementException;
import se.ericsson.cello.su.xmlparser.base.XML_ElementInterface;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public abstract class XmlElement
implements XML_ElementInterface {
    private Collection myGeneralComments = new LinkedList();
    private Locator myLocator = new LocatorImpl();

    public XmlElement() {
    }

    public XmlElement(Locator locator) {
        this.myLocator = locator;
    }

    public void addGeneralComment(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addGeneralComment(String aComment)", "aComment: " + string);
        }
        this.myGeneralComments.add(string);
    }

    public static XML_ElementInterface errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator) throws IllegalXML_AttributeValueException {
        String string6 = "XML file " + string2 + "," + "illegal attribute value " + string5 + " found in element of type " + string4 + " in parent element of type  " + string3 + ".";
        Trace.error(clazz, string, string6 + "aLocator: " + LocatorProxy.getLocatorInfo(locator));
        throw new IllegalXML_AttributeValueException(string6, locator);
    }

    public static XML_ElementInterface errorMoreElementsThanExpected(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws UnexpectedXML_ElementException {
        String string5 = "XML file " + string2 + "," + "\n\tthe element '" + string3 + "'" + "\n\tcontains more child elements of type " + string4 + " than allowed.";
        Trace.error(clazz, string, string5 + "aLocator: " + LocatorProxy.getLocatorInfo(locator));
        throw new UnexpectedXML_ElementException(string5, locator);
    }

    public static XML_ElementInterface reportUnknownElement(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws UnknownXML_ElementException {
        String string5 = "XML file " + string2 + "," + "\n\tthe element '" + string3 + "'" + "\n\t contains a child element of not allowed type '" + string4 + "'.";
        Trace.error(clazz, string, string5 + "aLocator: " + LocatorProxy.getLocatorInfo(locator));
        throw new UnknownXML_ElementException(string5, locator);
    }

    public static void reportUnknownAttribute(Class clazz, String string, String string2, String string3, String[] stringArray, Locator locator) throws UnknownXML_AttributeException {
        String string4 = "XML file " + string2 + "," + "\n\telement of type " + string3 + " contains unexpected attribute(s)." + "\n\tUnexpected attribute(s): " + SuLib.toString(stringArray);
        Trace.error(clazz, string, string4 + "aLocator: " + LocatorProxy.getLocatorInfo(locator));
        throw new UnknownXML_AttributeException(string4, locator);
    }

    public Collection getGeneralComments() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getGeneralComments( )");
        }
        return this.myGeneralComments;
    }

    public Locator getLocator() {
        return this.myLocator;
    }

    public void print(PrintStream printStream, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        Iterator iterator = this.myGeneralComments.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            printStream.println(string + "<!-- " + string2 + " -->");
        }
    }

    public String toString() {
        if (this.myLocator != null) {
            return "\n\tLine number: " + this.myLocator.getLineNumber() + "\n\tColumn number: " + this.myLocator.getColumnNumber() + "\n\tmyGeneralComments: " + this.myGeneralComments;
        }
        return "No locator information available.\n\tmyGeneralComments: " + this.myGeneralComments;
    }
}

