/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.PiuTypeDataInterface;
import se.ericsson.cello.sudom.parser.control.transform.ProductDataTransformerBase;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuType;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeData;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.dom.transform.Value;

public class PiuTypeTransformer
extends ProductDataTransformerBase {
    public static final String ProductDataPath = "UpgradePackage/PiuType/ProductData";
    public static final String PiuTypeDataPath = "UpgradePackage/PiuType/PiuTypeData";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        if (value.getElementPath().equals(ProductDataPath)) {
            this.transformProductDataAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(PiuTypeDataPath)) {
            this.transformPiuTypeDataAttribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformPiuTypeDataAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformPiuTypeDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getPiuTypeDatas(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        PiuTypeData piuTypeData = null;
        while (iterator.hasNext()) {
            piuTypeData = (PiuTypeData)iterator.next();
            if (value.getAttributeName().equals(PiuTypeDataAttributeName.DefaultPiuRole.getValue())) {
                if (piuTypeData.getDefaultPiuRole() == null || !piuTypeData.getDefaultPiuRole().equals(value.getFrom())) continue;
                piuTypeData.setDefaultPiuRole(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(PiuTypeDataAttributeName.DefAllowedSeqRestarts.getValue())) {
                if (piuTypeData.getDefAllowedSeqRestarts() == null || !piuTypeData.getDefAllowedSeqRestarts().equals(value.getFrom())) continue;
                piuTypeData.setDefAllowedSeqRestarts(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformPiuTypeDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getPiuTypeDatas(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypeDatas(DocumentObjectUpgradePackage aDOUP)", (String)("aDOUP: " + documentObjectUpgradePackage));
        }
        LinkedList<PiuTypeDataInterface> linkedList = new LinkedList<PiuTypeDataInterface>();
        Vector vector = documentObjectUpgradePackage.getPiuTypes();
        Iterator iterator = vector.iterator();
        PiuType piuType = null;
        while (iterator.hasNext()) {
            piuType = (PiuType)iterator.next();
            linkedList.add(piuType.getPiuTypeDataInterface());
        }
        return linkedList;
    }

    private void transformProductDataAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformProductDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getProductDatas(documentObjectUpgradePackage);
        this.transformProductDataAttribute(value, collection);
    }

    private Collection getProductDatas(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getProductDatas(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        HashSet<ProductData> hashSet = new HashSet<ProductData>();
        Vector vector = documentObjectUpgradePackage.getPiuTypes();
        Iterator iterator = vector.iterator();
        PiuType piuType = null;
        while (iterator.hasNext()) {
            piuType = (PiuType)iterator.next();
            hashSet.add(piuType.getProductData());
        }
        return hashSet;
    }
}

