/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.RootElementName;
import se.ericsson.cello.sudom.parser.dom.AttributeValue;
import se.ericsson.cello.sudom.parser.dom.AttributeValueValidator;
import se.ericsson.cello.sudom.parser.dom.MandatoryInformationHandler;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageAttributeName;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionConstraints;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class UpgradePackageSyntaxVersionValue
extends AttributeValue {
    public static final String Default = "L";
    public static final String PM1 = "PM1";
    public static final String PN1 = "PN1";
    public static final String PS1 = "PS1";
    public static final String PT1 = "PT1";
    public static final String PU1 = "PU1";
    public static final String PV1 = "PV1";
    public static final String PX1 = "PX1";
    public static final String PY1 = "PY1";
    public static final String PZ1 = "PZ1";
    public static final String PAA1 = "PAA1";
    public static final String PAB1 = "PAB1";
    public static final String PAC1 = "PAC1";
    public static final String PAD1 = "PAD1";
    public static final String PAE1 = "PAE1";
    public static final String PAF1 = "PAF1";
    public static final String PAG1 = "PAG1";
    public static final String PAH1 = "PAH1";
    public static final String PAJ1 = "PAJ1";
    public static final String PAK1 = "PAK1";
    public static final String Supported = "PAK1";

    public static boolean isAllowed(String string, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints) {
        String string2 = upgradePackageSyntaxVersionConstraints.getMinimumSyntaxVersion();
        if (string2 != null && !string2.equals(string)) {
            return UpgradePackageSyntaxVersionValue.isFirstValueHigher(string, string2);
        }
        return true;
    }

    public static boolean isMandatory(String string, MandatoryInformationHandler mandatoryInformationHandler) {
        if (UpgradeTrace.valid((Class)UpgradePackageSyntaxVersionValue.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradePackageSyntaxVersionValue.class, (int)25, (String)"isMandatory(String aCurrentSyntaxVersion, MandatoryInformationHandler anUpgradePackageMandatoryInformation)", (String)("aCurrentSyntaxVersion: " + string + "\n\tanUpgradePackageMandatoryInformation: " + mandatoryInformationHandler));
        }
        String string2 = null;
        int n = mandatoryInformationHandler.getNumberOfIndex() - 1;
        for (int i = 0; i < mandatoryInformationHandler.getNumberOfIndex(); ++i) {
            string2 = mandatoryInformationHandler.getSyntaxVersionAt(i);
            if (!UpgradePackageSyntaxVersionValue.isFirstValueHigher(string2, string)) continue;
            if (i == 0) {
                n = 0;
                break;
            }
            n = i - 1;
            break;
        }
        boolean bl = mandatoryInformationHandler.getMandatoryAt(n);
        if (UpgradeTrace.valid((Class)UpgradePackageSyntaxVersionValue.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradePackageSyntaxVersionValue.class, (int)25, (String)"isMandatory(String aCurrentSyntaxVersion, MandatoryInformationHandler anUpgradePackageMandatoryInformation)", (String)("Returning - theMandatory: " + bl));
        }
        return bl;
    }

    public static void validate(String string, Locator locator) throws ValidateException {
        int n = 1;
        int n2 = 4;
        boolean bl = false;
        if (UpgradePackageSyntaxVersionValue.isPreliminary(string)) {
            n = 3;
            n2 = 5;
            bl = true;
        }
        AttributeValueValidator.validateLength(UpgradePackageSyntaxVersionValue.class, "validate(String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, locator, n, n2);
        AttributeValueValidator.validateNoWhiteSpaceCharacter(UpgradePackageSyntaxVersionValue.class, "validate(String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, locator);
        if (!string.equals(string.toUpperCase())) {
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validate(String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "Only upper case characters are allowed.", locator);
        }
        int n3 = 0;
        if (bl) {
            n3 = 1;
        }
        char c = ' ';
        for (int i = n3; i < string.length(); ++i) {
            c = string.charAt(i);
            if (UpgradePackageSyntaxVersionValue.isOrdinaryRevisionLetter(c)) {
                UpgradePackageSyntaxVersionValue.validateOrdinaryRevisionLetterAtIndex(c, i, bl, string, locator);
                continue;
            }
            if (Character.isDigit(c)) {
                UpgradePackageSyntaxVersionValue.validateRevisionDigitAtIndex(c, i, bl, string, locator);
                continue;
            }
            if (UpgradePackageSyntaxVersionValue.isPrelimaryRevisionLetter(c)) {
                UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$UpgradePackageSyntaxVersionValue == null ? UpgradePackageSyntaxVersionValue.class$("se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionValue") : class$se$ericsson$cello$sudom$parser$dom$UpgradePackageSyntaxVersionValue, "validate(String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "Character: '" + c + "' is not allowed at this position (" + (i + 1) + ").", locator);
                continue;
            }
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$UpgradePackageSyntaxVersionValue == null ? UpgradePackageSyntaxVersionValue.class$("se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionValue") : class$se$ericsson$cello$sudom$parser$dom$UpgradePackageSyntaxVersionValue, "validate(String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "Character: '" + c + "' is not allowed.", locator);
        }
        if (!string.equals(PM1) && UpgradePackageSyntaxVersionValue.isFirstValueHigher(PM1, string)) {
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validate(String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "Value must be higher than 'L'.", locator);
        }
    }

    private static String getOrdinaryRevisionLetters(String string) {
        char c;
        int n = 0;
        int n2 = 0;
        if (UpgradePackageSyntaxVersionValue.isPreliminary(string)) {
            n = 1;
            n2 = 1;
        }
        if (string.length() > 1 && UpgradePackageSyntaxVersionValue.isOrdinaryRevisionLetter(c = string.charAt(n + 1))) {
            ++n2;
        }
        return string.substring(n, n2 + 1);
    }

    private static int getRevisionDigits(String string) {
        int n = -1;
        int n2 = string.length() - 1;
        char c = string.charAt(n2);
        if (Character.isDigit(c)) {
            c = string.charAt(n2 - 1);
            if (Character.isDigit(c)) {
                --n2;
            }
            n = Integer.parseInt(string.substring(n2));
        }
        return n;
    }

    public static boolean isFirstValueHigher(String string, String string2) {
        int n;
        String string3 = UpgradePackageSyntaxVersionValue.getOrdinaryRevisionLetters(string);
        String string4 = UpgradePackageSyntaxVersionValue.getOrdinaryRevisionLetters(string2);
        if (string3.length() > string4.length()) {
            return true;
        }
        if (string3.length() < string4.length()) {
            return false;
        }
        if (string3.charAt(0) > string4.charAt(0)) {
            return true;
        }
        if (string3.charAt(0) < string4.charAt(0)) {
            return false;
        }
        if (string3.length() > 1) {
            if (string3.charAt(1) > string4.charAt(1)) {
                return true;
            }
            if (string3.charAt(1) < string4.charAt(1)) {
                return false;
            }
        }
        if (!UpgradePackageSyntaxVersionValue.isPreliminary(string) && UpgradePackageSyntaxVersionValue.isPreliminary(string2)) {
            return true;
        }
        if (UpgradePackageSyntaxVersionValue.isPreliminary(string) && !UpgradePackageSyntaxVersionValue.isPreliminary(string2)) {
            return false;
        }
        int n2 = UpgradePackageSyntaxVersionValue.getRevisionDigits(string);
        if (n2 > (n = UpgradePackageSyntaxVersionValue.getRevisionDigits(string2))) {
            return true;
        }
        if (n2 < n) {
            return false;
        }
        return false;
    }

    private static boolean isOrdinaryRevisionLetter(char c) {
        return c >= 'A' && c != 'I' && (c < 'O' || c > 'R') && c != 'W' && c <= 'Z';
    }

    private static boolean isPreliminary(String string) {
        if (string.length() > 0) {
            return UpgradePackageSyntaxVersionValue.isPrelimaryRevisionLetter(string.charAt(0));
        }
        return false;
    }

    private static boolean isPrelimaryRevisionLetter(char c) {
        return c == 'P';
    }

    private static void validateOrdinaryRevisionLetterAtIndex(char c, int n, boolean bl, String string, Locator locator) throws ValidateException {
        int n2 = 1;
        if (bl) {
            n2 = 2;
        }
        if (n > n2) {
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validateOrdinaryRevisionLetterAtIndex(char anOrdinaryRevisionLetter, int anIndex, boolean anIsPreliminary, String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "Character: '" + c + "' is not allowed at this position (" + (n + 1) + ").", locator);
        } else if (bl && n == string.length() - 1) {
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validateOrdinaryRevisionLetterAtIndex(char anOrdinaryRevisionLetter, int anIndex, boolean anIsPreliminary, String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "A value starting with '" + string.charAt(0) + "' must end with one or two digits.", locator);
        }
    }

    private static void validateRevisionDigitAtIndex(char c, int n, boolean bl, String string, Locator locator) throws ValidateException {
        if (n == 0) {
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validateRevisionDigitAtIndex(char aRevisionDigit, int anIndex, boolean anIsPreliminary, String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "A value is not allowed to start with a digit.", locator);
        } else if (n == 1 && bl) {
            UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validateRevisionDigitAtIndex(char aRevisionDigit, int anIndex, boolean anIsPreliminary, String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "A value is not allowed to start with a preliminary revision letter and a digit.", locator);
        } else {
            char c2;
            char c3 = string.charAt(n - 1);
            if (!Character.isDigit(c3)) {
                if (c == '0') {
                    UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validateRevisionDigitAtIndex(char aRevisionDigit, int anIndex, boolean anIsPreliminary, String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "Digit: '" + c + "' is only allowed if it's preceded by another digit.", locator);
                }
            } else if (n < string.length() - 1 && Character.isDigit(c2 = string.charAt(n + 1))) {
                UpgradePackageSyntaxVersionValue.errorIllegalAttributeValue(UpgradePackageSyntaxVersionValue.class, "validateRevisionDigitAtIndex(char aRevisionDigit, int anIndex, boolean anIsPreliminary, String aValue, Locator aLocator)", RootElementName.UpgradePackage.getValue(), UpgradePackageAttributeName.SyntaxVersion.getValue(), string, "A value is not allowed to contain more than two digits.", locator);
            }
        }
    }
}

