/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.verifyupdatesequence;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.installsequence.SoftJvmUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Trigger;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerSubSpecValue;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateSequence;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateSequenceSubElementName;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateStep;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateStepAttributeName;
import se.ericsson.cello.sudom.parser.dom.verifyupdatesequence.VerifyUpdateStepSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class VerifyUpdateSequenceValidator
extends Validator {
    public static void validate(VerifyUpdateSequence verifyUpdateSequence, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpdateSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpdateSequenceValidator.class, (int)25, (String)"validate(VerifyUpdateSequence aVerifyUpdateSequence, Locator aLocator)", (String)("aVerifyUpdateSequence: " + verifyUpdateSequence + "\n\taLocator: " + locator));
        }
        Vector vector = verifyUpdateSequence.getVerifyUpdateSteps();
        Iterator iterator = vector.iterator();
        VerifyUpdateStep verifyUpdateStep = null;
        int n = 0;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            verifyUpdateStep = (VerifyUpdateStep)iterator.next();
            VerifyUpdateSequenceValidator.validateThatVerifyUpdateStepContainsA_KnownSubElement(verifyUpdateStep);
            VerifyUpdateSequenceValidator.validateThatSoftJvmUpgradeInVerifyUpdateStepContainsA_KnownSubElement(verifyUpdateStep);
            n = VerifyUpdateSequenceValidator.validateThatOneAndOnlyOneVerifyUpdateStepContainsA_VerifyUP(verifyUpdateStep, locator, n, iterator.hasNext());
            VerifyUpdateSequenceValidator.validateThatLabelIsUniqueForAllVerifyUpdateSteps(verifyUpdateStep, hashSet);
            VerifyUpdateSequenceValidator.valdateThatTriggerInVerifyUpdateStepContainsAllowedSubSpecValue(verifyUpdateStep);
        }
    }

    private static void validateThatVerifyUpdateStepContainsA_KnownSubElement(VerifyUpdateStep verifyUpdateStep) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpdateSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpdateSequenceValidator.class, (int)25, (String)"validateThatVerifyUpdateStepContainsA_KnownSubElement(VerifyUpdateStep aVerifyUpdateStep)", (String)("aVerifyUpdateStep: " + verifyUpdateStep));
        }
        if (verifyUpdateStep.getVerifyUP() == null && verifyUpdateStep.getSoftJvmUpgrade() == null && verifyUpdateStep.getTrigger() == null) {
            String string = "\n\tA " + VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue() + " element must contain at least one sub element of known type.";
            VerifyUpdateSequenceValidator.errorElementIsMissingNoSubElementWithLocatorString(VerifyUpdateSequenceValidator.class, "validateThatVerifyUpdateStepContainsA_KnownSubElement(VerifyUpdateStep aVerifyUpdateStep)", "VerifyUpdateSequence", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), string, verifyUpdateStep.getLocatorString());
        }
    }

    private static void validateThatLabelIsUniqueForAllVerifyUpdateSteps(VerifyUpdateStep verifyUpdateStep, HashSet hashSet) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpdateSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpdateSequenceValidator.class, (int)25, (String)"validateThatLabelIsUniqueForAllVerifyUpdateSteps(VerifyUpdateStep aVerifyUpdateStep, HashSet aLabels)", (String)("aVerifyUpdateStep: " + verifyUpdateStep + "\n\taLabels: " + hashSet));
        }
        if (!hashSet.add(verifyUpdateStep.getLabel().toUpperCase())) {
            String string = "\n\tThe value of this attribute must be unique among all " + VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue() + " elements in this " + "VerifyUpdateSequence" + ".";
            VerifyUpdateSequenceValidator.errorIllegalAttributeValueWithLocatorString(VerifyUpdateSequenceValidator.class, "validateThatLabelIsUniqueForAllVerifyUpdateSteps(VerifyUpdateStep aVerifyUpdateStep, Locator aLocator)", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), VerifyUpdateStepAttributeName.Label.getValue(), verifyUpdateStep.getLabel(), string, verifyUpdateStep.getLocatorString());
        }
    }

    private static int validateThatOneAndOnlyOneVerifyUpdateStepContainsA_VerifyUP(VerifyUpdateStep verifyUpdateStep, Locator locator, int n, boolean bl) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpdateSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpdateSequenceValidator.class, (int)25, (String)"validateThatOneAndOnlyOneVerifyUpdateStepContainsA_VerifyUP(VerifyUpdateStep aVerifyUpdateStep, Locator aLocator, int aNumberOfVerifyUpdateStepsContainingA_VerifyUP, boolean anIsVerifyUpdateSequenceContainingMoreVerifyUpdateSteps)", (String)("aVerifyUpdateStep: " + verifyUpdateStep + "\n\taLocator: " + locator + "\n\taNumberOfVerifyUpdateStepsContainingA_VerifyUP: " + n + "\n\tanIsVerifyUpdateSequenceContainingMoreVerifyUpdateSteps: " + bl));
        }
        String string = null;
        if (verifyUpdateStep.getVerifyUP() != null) {
            if (++n > 1) {
                string = "\n\tA VerifyUpdateSequence element is only allowed to contain one " + VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue() + " element that contains a " + VerifyUpdateStepSubElementName.VerifyUP.getValue() + " element.";
                VerifyUpdateSequenceValidator.errorUnexpectedElementWithLocatorString(VerifyUpdateSequenceValidator.class, "validateThatOneAndOnlyOneVerifyUpdateStepContainsA_VerifyUP(VerifyUpdateStep aVerifyUpdateStep, Locator aLocator, int aNumberOfVerifyUpdateStepsContainingA_VerifyUP, boolean anIsVerifyUpdateSequenceContainingMoreVerifyUpdateSteps)", "VerifyUpdateSequence", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), VerifyUpdateStepSubElementName.VerifyUP.getValue(), string, verifyUpdateStep.getVerifyUP().getLocatorString());
            }
        } else if (!bl && n == 0) {
            string = "\n\tA VerifyUpdateSequence element must contain one " + VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue() + " element that contains a " + VerifyUpdateStepSubElementName.VerifyUP.getValue() + " element.";
            VerifyUpdateSequenceValidator.errorElementIsMissingOneElement(VerifyUpdateSequenceValidator.class, "validateThatOneAndOnlyOneVerifyUpdateStepContainsA_VerifyUP(VerifyUpdateStep aVerifyUpdateStep, Locator aLocator, int aNumberOfVerifyUpdateStepsContainingA_VerifyUP, boolean anIsVerifyUpdateSequenceContainingMoreVerifyUpdateSteps)", "VerifyUpdateSequence", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), VerifyUpdateStepSubElementName.VerifyUP.getValue(), string, locator);
        }
        return n;
    }

    private static void validateThatSoftJvmUpgradeInVerifyUpdateStepContainsA_KnownSubElement(VerifyUpdateStep verifyUpdateStep) throws ValidateException {
        SoftJvmUpgrade softJvmUpgrade;
        if (UpgradeTrace.valid((Class)VerifyUpdateSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpdateSequenceValidator.class, (int)25, (String)"validateThatSoftJvmUpgradeInVerifyUpdateStepContainsA_KnownSubElement(VerifyUpdateStep aVerifyUpdateStep, Locator aLocator)", (String)("aVerifyUpdateStep: " + verifyUpdateStep));
        }
        if ((softJvmUpgrade = verifyUpdateStep.getSoftJvmUpgrade()) != null && softJvmUpgrade.getLoadJavaLMs().isEmpty() && softJvmUpgrade.getUnloadJavaLMs().isEmpty()) {
            String string = "\n\tA " + VerifyUpdateStepSubElementName.SoftJvmUpgrade.getValue() + " element must contain at least one sub element of known type.";
            VerifyUpdateSequenceValidator.errorElementIsMissingNoSubElementWithLocatorString(VerifyUpdateSequenceValidator.class, "validateThatSoftJvmUpgradeInVerifyUpdateStepContainsA_KnownSubElement(VerifyUpdateStep aVerifyUpdateStep)", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), VerifyUpdateStepSubElementName.SoftJvmUpgrade.getValue(), string, softJvmUpgrade.getLocatorString());
        }
    }

    private static void valdateThatTriggerInVerifyUpdateStepContainsAllowedSubSpecValue(VerifyUpdateStep verifyUpdateStep) throws ValidateException {
        String string;
        Trigger trigger;
        if (UpgradeTrace.valid((Class)VerifyUpdateSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpdateSequenceValidator.class, (int)25, (String)"valdateThatTriggerInVerifyUpdateStepContainsAllowedSubSpecValue(VerifyUpdateStep aVerifyUpdateStep)", (String)("aVerifyUpdateStep: " + verifyUpdateStep));
        }
        if ((trigger = verifyUpdateStep.getTrigger()) != null && !TriggerSubSpecValue.isValuePreDefinedForVerifyUpdateSequence(string = trigger.getSubSpec())) {
            if (TriggerSubSpecValue.isValuePreDefinedForPreCheckSequence(string)) {
                String string2 = "\n\tThe requested value is one of the values that is predefined for a VerifyUpgradeSequence,";
                if (TriggerSubSpecValue.isValuePreDefinedForInstallSequence(string)) {
                    string2 = "\n\tThe requested value is the value that is predefined for an InstallSequence,";
                } else if (TriggerSubSpecValue.isValuePreDefinedForVerifySequence(string)) {
                    string2 = "\n\tThe requested value is the value that is predefined for a VerifySequence,";
                }
                String string3 = "\n\tthis value is not allowed in a VerifyUpdateSequence.";
                VerifyUpdateSequenceValidator.errorIllegalAttributeValueWithLocatorString(VerifyUpdateSequenceValidator.class, "valdateThatTriggerInVerifyUpdateStepContainsAllowedSubSpecValue(VerifyUpdateStep aVerifyUpdateStep)", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), VerifyUpdateStepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string2 + string3, trigger.getLocatorString());
            } else if (TriggerSubSpecValue.isValuePreDefinedForUpgradeSequence(string)) {
                String string4 = "\n\tThe requested value is one of the values that is predefined for an UpgradeSequence,\n\tthis value is not allowed in a VerifyUpdateSequence.";
                VerifyUpdateSequenceValidator.errorIllegalAttributeValueWithLocatorString(VerifyUpdateSequenceValidator.class, "valdateThatTriggerInVerifyUpdateStepContainsAllowedSubSpecValue(VerifyUpdateStep aVerifyUpdateStep)", VerifyUpdateSequenceSubElementName.VerifyUpdateStep.getValue(), VerifyUpdateStepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string4, trigger.getLocatorString());
            }
        }
    }
}

