/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.piutype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuType;
import se.ericsson.cello.sudom.proxy.exceptions.DocumentObjectProxyException;
import se.ericsson.cello.sudom.proxy.exceptions.FindAndReplaceException;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileDataException;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxy;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.PiuTypeReplacementContainer;

public class PiuTypesProxy
implements PiuTypesProxyInterface {
    private Vector myPiuTypes = null;
    protected HashMap myPiuTypesMap = new HashMap();
    protected HashMap myDuplicatPiuTypesMap = new HashMap();
    protected static final String UNDERSCORE = "_";

    public PiuTypesProxy(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"PiuTypesProxy(Vector aPiuTypes) ", (String)("aPiuTypes: " + vector));
        }
        this.myPiuTypes = vector;
        this.buildSetOfprodNoAndRevs();
    }

    public void addOrReplacePiuTypes(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addOrReplacePiuTypes(Vector aPiuTypes)", (String)("aPiuTypes: " + vector));
        }
        Iterator iterator = vector.iterator();
        PiuTypeProxyInterface piuTypeProxyInterface = null;
        while (iterator.hasNext()) {
            piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
            this.myPiuTypesMap.put(piuTypeProxyInterface.getProductNumber() + UNDERSCORE + piuTypeProxyInterface.getProductRevision(), piuTypeProxyInterface);
        }
        this.getPiuTypes();
    }

    public Vector getNotReferencedPiuTypes(ProductNumbersAndRevisions productNumbersAndRevisions) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNotReferencedPiuTypes(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedPiuTypes)", (String)("aProductNumberAndRevisionOfReferencedPiuTypes: " + productNumbersAndRevisions));
        }
        Iterator iterator = this.myPiuTypesMap.values().iterator();
        PiuTypeProxyInterface piuTypeProxyInterface = null;
        Vector<PiuTypeProxyInterface> vector = new Vector<PiuTypeProxyInterface>(1);
        while (iterator.hasNext()) {
            piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
            if (productNumbersAndRevisions.contains(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision())) continue;
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"getNotReferencedPiuTypes(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedPiuTypes)", (String)("Adding the PiuType (" + piuTypeProxyInterface.getProductNumber() + " " + piuTypeProxyInterface.getProductRevision() + ") to the not referenced PiuType list."));
            }
            vector.addElement(piuTypeProxyInterface);
        }
        return vector;
    }

    public PiuTypeProxyInterface getPiuTypeProxyInterface(String string, String string2) {
        return (PiuTypeProxyInterface)this.myPiuTypesMap.get(string + UNDERSCORE + string2);
    }

    public PiuTypeProxyInterface getPiuTypeProxyInterface(ProductNumberAndRevision productNumberAndRevision) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypeProxyInterface(ProductNumberAndRevision aProductNumberAndRevision)", (String)("aProductNumberAndRevision: " + productNumberAndRevision));
        }
        return this.getPiuTypeProxyInterface(productNumberAndRevision, false);
    }

    public PiuTypeProxyInterface getPiuTypeProxyInterface(ProductNumberAndRevision productNumberAndRevision, boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypeProxyInterface(ProductNumberAndRevision aProductNumberAndRevision, boolean aAcceptBothShortOrFullRevision)", (String)("aProductNumberAndRevision: " + productNumberAndRevision + "\n\taAcceptBothShortOrFullRevision: " + bl));
        }
        try {
            if (bl) {
                Iterator iterator = this.myPiuTypesMap.values().iterator();
                PiuTypeProxyInterface piuTypeProxyInterface = null;
                while (iterator.hasNext()) {
                    piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
                    if (productNumberAndRevision.equals(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision())) {
                        return piuTypeProxyInterface;
                    }
                    if (productNumberAndRevision.equalsShortRevision(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision())) {
                        return piuTypeProxyInterface;
                    }
                    if (!productNumberAndRevision.equalsWildcardRevision(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision())) continue;
                    return piuTypeProxyInterface;
                }
                return null;
            }
            Iterator iterator = this.myPiuTypesMap.values().iterator();
            PiuTypeProxyInterface piuTypeProxyInterface = null;
            while (iterator.hasNext()) {
                piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
                if (!productNumberAndRevision.equals(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision())) continue;
                return piuTypeProxyInterface;
            }
            return null;
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"getPiuTypeProxyInterface(ProductNumberAndRevision aProductNumberAndRevision, boolean aAcceptBothShortOrFullRevision)", (String)("Failed to lookup a PiuTypeProxyInterface due to an exception was caught.aProductNumberAndRevision: " + productNumberAndRevision + "\n\taAcceptBothShortOrFullRevision: " + bl), (Throwable)exception);
            return null;
        }
    }

    public Collection getPiuTypes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypes( )");
        }
        Iterator iterator = this.myPiuTypesMap.values().iterator();
        this.myPiuTypes.clear();
        while (iterator.hasNext()) {
            this.myPiuTypes.add(((PiuTypeProxy)iterator.next()).getPiuType());
        }
        return this.myPiuTypes;
    }

    public Collection getPiuTypeProxyInterfaces() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypeProxyInterfaces()");
        }
        return this.myPiuTypesMap.values();
    }

    public Set getProductNumberAndRevisionsAsString() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionsAsString()");
        }
        return this.myPiuTypesMap.keySet();
    }

    public ProductNumbersAndRevisions getProductNumberAndRevisionOfAllPiuTypes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionOfDuplicatePiuTypes( )");
        }
        Iterator iterator = this.myPiuTypesMap.values().iterator();
        PiuTypeProxyInterface piuTypeProxyInterface = null;
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        while (iterator.hasNext()) {
            piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
            productNumbersAndRevisions.addElement(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision(), piuTypeProxyInterface.getProductLocatorString());
        }
        Iterator iterator2 = this.myDuplicatPiuTypesMap.values().iterator();
        piuTypeProxyInterface = null;
        while (iterator2.hasNext()) {
            piuTypeProxyInterface = (PiuTypeProxyInterface)iterator2.next();
            productNumbersAndRevisions.addElement(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision(), piuTypeProxyInterface.getProductLocatorString());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionOfPiuTypes( )", (String)("RETURNS - thePiuTypesProductNumbersAndRevisions: " + productNumbersAndRevisions));
        }
        return productNumbersAndRevisions;
    }

    public ProductNumbersAndRevisions getProductNumberAndRevisionOfPiuTypes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionOfPiuTypes( )\n\t myPiuTypesMap.values() ");
        }
        Iterator iterator = this.myPiuTypesMap.values().iterator();
        PiuTypeProxyInterface piuTypeProxyInterface = null;
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        while (iterator.hasNext()) {
            piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
            productNumbersAndRevisions.addElement(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision(), piuTypeProxyInterface.getProductLocatorString());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionOfPiuTypes( )", (String)("RETURNS - thePiuTypesProductNumbersAndRevisions: " + productNumbersAndRevisions));
        }
        return productNumbersAndRevisions;
    }

    public void buildSetOfprodNoAndRevs() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"buildSetOfprodNoAndRevs( )");
        }
        if (!this.myPiuTypesMap.isEmpty()) {
            this.myPiuTypesMap.clear();
        }
        Iterator iterator = this.myPiuTypes.iterator();
        PiuType piuType = null;
        while (iterator.hasNext()) {
            piuType = (PiuType)iterator.next();
            if (piuType.getProductData() == null) continue;
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("buildSetOfprodNoAndRevs( )\n\t key: " + piuType.getProductData().getNumber() + UNDERSCORE + piuType.getProductData().getRevision()));
            if (this.myPiuTypesMap.containsKey(piuType.getProductData().getNumber() + UNDERSCORE + piuType.getProductData().getRevision())) {
                this.myDuplicatPiuTypesMap.put(piuType.getProductData().getNumber() + UNDERSCORE + piuType.getProductData().getRevision(), new PiuTypeProxy(piuType));
                continue;
            }
            this.myPiuTypesMap.put(piuType.getProductData().getNumber() + UNDERSCORE + piuType.getProductData().getRevision(), new PiuTypeProxy(piuType));
        }
        UpgradeTrace.debug(this.getClass(), (int)25, (String)("buildSetOfprodNoAndRevs( )\n\tmyPiuTypesMap " + this.getPiuTypeProxyInterfaces()));
    }

    public HashMap getDuplicatPiuTypesMap() {
        return this.myDuplicatPiuTypesMap;
    }

    public void removeNotReferencedPiuTypes(ProductNumbersAndRevisions productNumbersAndRevisions, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeNotReferencedPiuTypes(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedPiuTypes)", (String)("aProductNumberAndRevisionOfReferencedPiuTypes: " + productNumbersAndRevisions + "\n\taDocumentObjectUpgradePackage: " + documentObjectUpgradePackage));
        }
        Iterator iterator = this.myPiuTypesMap.values().iterator();
        PiuTypeProxyInterface piuTypeProxyInterface = null;
        while (iterator.hasNext()) {
            piuTypeProxyInterface = (PiuTypeProxyInterface)iterator.next();
            if (productNumbersAndRevisions.contains(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision())) continue;
            iterator.remove();
        }
        documentObjectUpgradePackage.adaptPiuTypes(this.getPiuTypeProxyInterfaces());
    }

    public void replacePiuTypes(Vector vector, Vector vector2) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"replacePiuTypes(Vector aPiuTypeReplacementsContainer, Vector aNewPiuTypes)", (String)("aPiuTypeReplacementsContainer: " + vector + "\n\taNewPiuTypes: " + vector2));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object object;
            PiuTypeReplacementContainer piuTypeReplacementContainer = (PiuTypeReplacementContainer)iterator.next();
            this.verifyThatNewPiuTypesExists(piuTypeReplacementContainer, vector2);
            Iterator iterator2 = piuTypeReplacementContainer.getOldPiuTypes().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                object = (ProductNumberAndRevision)iterator2.next();
                if (this.myPiuTypesMap.remove(((ProductNumberAndRevision)object).productNumber + UNDERSCORE + ((ProductNumberAndRevision)object).revision) == null) continue;
                bl = true;
            }
            object = piuTypeReplacementContainer.getNewPiuTypes().iterator();
            while (object.hasNext()) {
                ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)object.next();
                if (this.myPiuTypesMap.remove(productNumberAndRevision.productNumber + UNDERSCORE + productNumberAndRevision.revision) == null) continue;
                bl = true;
            }
            if (!bl) {
                UpgradeTrace.log1(this.getClass(), (String)"replacePiuTypes(Vector aPiuTypeReplacementsContainer, Vector aNewPiuTypes)", (String)("aPiuTypeReplacementsContainer: " + vector + "\n\taNewPiuTypes: " + vector2 + "\n\tThe control file where PiuType elements shall be replaced does not contain a PiuType" + "\n\telement matching the PiuTypeReplacement element containing any of the OldPiuType's element where " + "\n\tOldPiuType's have the product data = " + piuTypeReplacementContainer.getOldPiuTypes() + "."));
                throw new FindAndReplaceException("replacePiuTypes(Vector aPiuTypeReplacementsContainer, Vector aNewPiuTypes)\n\taPiuTypeReplacementsContainer: " + vector + "\n\taNewPiuTypes: " + vector2 + "\n\tThe control file where PiuType elements shall be replaced does not contain a PiuType" + "\n\telement matching the PiuTypeReplacement element containing any of the OldPiuType's element where " + "\n\tOldPiuType's have the product data = " + piuTypeReplacementContainer.getOldPiuTypes() + ".");
            }
            this.addNewPiuTypes(piuTypeReplacementContainer.getNewPiuTypes(), vector2);
        }
    }

    private void addNewPiuTypes(Vector vector, Vector vector2) throws UpgradeControlFileDataException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addNewPiuTypes(Vector aNewPiuTypesToBeAdded, Vector aNewPiuTypesList)", (String)("aNewPiuTypesToBeAdded: " + vector + "\n\taNewPiuTypesList: " + vector2));
        }
        Iterator iterator = vector.iterator();
        ProductNumberAndRevision productNumberAndRevision = null;
        PiuType piuType = null;
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            piuType = this.getPiuType(productNumberAndRevision.productNumber, productNumberAndRevision.revision, vector2);
            this.myPiuTypesMap.put(piuType.getProductData().getNumber() + UNDERSCORE + piuType.getProductData().getRevision(), new PiuTypeProxy(piuType));
        }
    }

    private PiuType getPiuType(String string, String string2, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuType(String aProductNumber, String aProductRevision, Vector aPiuTypes)", (String)("aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taPiuTypes: " + vector));
        }
        Iterator iterator = vector.iterator();
        PiuType piuType = null;
        while (iterator.hasNext()) {
            piuType = (PiuType)iterator.next();
            if (!piuType.getProductData().getNumber().equals(string) || !piuType.getProductData().getRevision().equals(string2)) continue;
            return piuType;
        }
        return null;
    }

    public Set getPiuTypeKeys() {
        return this.myPiuTypesMap.keySet();
    }

    private void verifyThatNewPiuTypesExists(PiuTypeReplacementContainer piuTypeReplacementContainer, Vector vector) throws UpgradeControlFileDataException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"verifyThatNewPiuTypesExists(PiuTypeReplacementContainer aPiuTypeReplacementContainer, Vector aNewPiuTypes)", (String)("aPiuTypeReplacementContainer: " + piuTypeReplacementContainer + "\n\taNewPiuTypes: " + vector));
        }
        Vector vector2 = piuTypeReplacementContainer.getNewPiuTypes();
        Iterator iterator = vector2.iterator();
        ProductNumberAndRevision productNumberAndRevision = null;
        PiuType piuType = null;
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            if (productNumberAndRevision == null || (piuType = this.getPiuType(productNumberAndRevision.productNumber, productNumberAndRevision.revision, vector)) != null) continue;
            UpgradeTrace.error(this.getClass(), (String)"verifyThatNewPiuTypesExists(PiuTypeReplacementContainer aPiuTypeReplacementContainer, Vector aNewPiuTypes)", (String)("aPiuTypeReplacementContainer: " + piuTypeReplacementContainer + "\n\taNewPiuTypes: " + vector + "\n\tUpgrade control file error," + "\n\ta New Piu Type element in a delta control file must contain the same product number " + "and revision as one of the Piu Type elements," + "\n\tat least one doesn't."));
            throw new UpgradeControlFileDataException("verifyThatNewPiuTypesExists(PiuTypeReplacementContainer aPiuTypeReplacementContainer, Vector aNewPiuTypes)\n\taPiuTypeReplacementContainer: " + piuTypeReplacementContainer + "\n\taNewPiuTypes: " + vector + "\n\tUpgrade control file error," + "\n\ta New Piu Type element in a delta control file must contain the same product number " + "and revision as one of the Piu Type elements," + "\n\tat least one doesn't.");
        }
    }
}

