/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.information;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.configurationversion.file.base.FilePath;
import se.ericsson.cello.configurationversion.file.dependency.proxy.UP_ListProxy;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.file.CV_FileHandler;
import se.ericsson.cello.configurationversion.util.file.CV_FileHandlerProperties;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.upgradepackage.information.ReferringCVsInformationHandlerInterface;
import se.ericsson.cello.upgradepackage.information.ReferringConfigurationVersionInfo;
import se.ericsson.cello.upgradepackage.information.UpgradePackageInformationException;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageRelatedCVsDataContainer;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ReferringCVsInformationHandler
implements ReferringCVsInformationHandlerInterface {
    private FilePath myFilePath = new FilePath();
    private String myUP_DocumentID = "";
    private String myPathToTempCV_Dir = "";

    public ReferringCVsInformationHandler(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ReferringCVsInformationHandler(String anUpgradePackageProductNumber, String anUpgradePackageProductRevision)", "anUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2);
        }
        this.myUP_DocumentID = SuLib.createUpgradePackageDocumentId(string, string2);
        CV_FileHandlerProperties cV_FileHandlerProperties = new CV_FileHandlerProperties();
        this.myPathToTempCV_Dir = cV_FileHandlerProperties.getCV_CreateFileDisk() + cV_FileHandlerProperties.getCV_FileHandlerTmpPath();
    }

    public Collection getReferringConfigurationVersionInfos() throws UpgradePackageInformationException {
        UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getReferringConfigurationVersionInfos()");
        }
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
        try {
            upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(this.myUP_DocumentID);
        }
        catch (MO_HandlerException mO_HandlerException) {
            Trace.error(this.getClass(), "getReferringConfigurationVersionInfos()", "Exception caught when trying to get UpgradePackage related data for CV.\n\tUP_DocumentID: " + this.myUP_DocumentID, mO_HandlerException);
            throw new UpgradePackageInformationException("Class name: " + this.getClass().getName() + "\n\tMethod: getReferringConfigurationVersionInfos()" + "\n\tException caught when trying to get UpgradePackage related data for CV." + "\n\tUP_DocumentID: " + this.myUP_DocumentID + "\n\tException: " + (Object)((Object)mO_HandlerException));
        }
        Vector vector = SuLib.translateToVector(upgradePackageRelatedCVsDataContainer.getNotDeleteableCVs());
        vector.addAll(SuLib.translateToVector(upgradePackageRelatedCVsDataContainer.getDeleteableCVs()));
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionReadUP_TypeInCVs(Coordinator context)", "theRelatedCVs: " + ((Object)vector).toString());
        }
        return this.createReferringConfigurationVersionInfos(vector);
    }

    private Collection createReferringConfigurationVersionInfos(Collection collection) throws UpgradePackageInformationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createReferringConfigurationVersionInfos(Collection aCV_Names)", "aCV_Names: " + collection);
        }
        this.createTempCV_Dir();
        Vector<ReferringConfigurationVersionInfo> vector = new Vector<ReferringConfigurationVersionInfo>(1);
        String string = null;
        ActivatedTypeOfUP activatedTypeOfUP = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createReferringConfigurationVersionInfos(Collection aCV_Names)", "Copying CV files from d to c, theCV_Name: " + string);
            }
            this.copyCVFilesToTmpDir(string);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createReferringConfigurationVersionInfos(Collection aCV_Names)", "Files copied.");
            }
            activatedTypeOfUP = this.getActivatedTypeOfUP();
            vector.add(new ReferringConfigurationVersionInfo(string, activatedTypeOfUP));
            this.clearTempCV_Dir();
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createReferringConfigurationVersionInfos(Collection aCV_Names)", "RETURNING - theReferringConfigurationVersionInfos: " + vector);
        }
        return vector;
    }

    private void createTempCV_Dir() throws UpgradePackageInformationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createTempCV_Dir()");
        }
        try {
            this.myFilePath.createDirPath(this.myPathToTempCV_Dir);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createTempCV_Dir()", "Exception caught when trying to get UpgradePackage related data for CV.", throwable);
            throw new UpgradePackageInformationException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "createTempCV_Dir()" + "\n\tException caught when trying to create tmp directory for CV information." + "\n\tThrowable: " + throwable);
        }
        this.clearTempCV_Dir();
    }

    private void copyCVFilesToTmpDir(String string) throws UpgradePackageInformationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyCVFilesToTmpDir(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            CV_FileHandler.copyNeededCV_FilesToC(string, this.myPathToTempCV_Dir);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            Trace.error(this.getClass(), "copyCVFilesToTmpDir(String aCV_Name)", "ConfigurationVersionException caught when trying to copy CV information from into tmp directory." + (Object)((Object)configurationVersionException));
            throw new UpgradePackageInformationException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "copyCVFilesToTmpDir(String aCV_Name)" + "\n\tConfigurationVersionException caught when trying to copy CV information from into tmp directory." + "\n\tException: " + (Object)((Object)configurationVersionException));
        }
    }

    private ActivatedTypeOfUP getActivatedTypeOfUP() throws UpgradePackageInformationException {
        ActivatedTypeOfUP activatedTypeOfUP;
        block4: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getActivatedTypeOfUP()");
            }
            activatedTypeOfUP = ActivatedTypeOfUP.Undefined;
            try {
                UP_ListProxy uP_ListProxy = new UP_ListProxy(this.myPathToTempCV_Dir);
                activatedTypeOfUP = uP_ListProxy.getExecutingUP().getActivatedTypeOfUP();
            }
            catch (ConfigurationVersionException configurationVersionException) {
                if (!Trace.valid(this.getClass(), 20)) break block4;
                Trace.debug(this.getClass(), 20, "getActivatedTypeOfUP()", "ConfigurationVersionException caught when trying to create UP_ListProxy.\n\tProbably due to that uplist2.xml or uplist.xml was not found in directory.\n\tmyPathToTempCV_Dir" + this.myPathToTempCV_Dir);
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getActivatedTypeOfUP()", "RETURNING - theActivatedTypeOfUP: " + activatedTypeOfUP);
        }
        return activatedTypeOfUP;
    }

    private void clearTempCV_Dir() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearTempCV_Dir()");
        }
        this.myFilePath.removeFilesInDirectory(this.myPathToTempCV_Dir);
    }
}

