/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidUpgradeCasesInformation;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxy;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.install.ControlFileElementSelectorException;
import se.ericsson.cello.upgradepackage.install.MergeControlFileException;
import se.ericsson.cello.upgradepackage.install.RepertoireCollector;
import se.ericsson.cello.upgradepackage.install.SelectiveInstallFailureException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelper;
import se.ericsson.cello.upgradepackage.util.enumer.RequestedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.mohandler.activeotherlms.ActiveOtherLMsMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ControlFileElementSelector {
    public ControlFileElementSelector() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ControlFileElementSelector()");
        }
    }

    public DocumentObjectUpgradePackage adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage documentObjectUpgradePackage, RequestedTypeOfUP requestedTypeOfUP, Coordinator coordinator) throws SelectiveInstallFailureException, MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, RequestedTypeOfUP aRequestedTypeOfUP, Coordinator aCoordinator)", "aDocumentObjectUpgradePackage: " + documentObjectUpgradePackage + "\n\taRequestedTypeOfUP: " + requestedTypeOfUP + "\t\naCoordinator: " + coordinator);
        }
        try {
            Object object;
            Object object2;
            DocumentObjectProxy documentObjectProxy = new DocumentObjectProxy(documentObjectUpgradePackage);
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            String string = null;
            String string2 = null;
            String string3 = "";
            if (upgradePackageMoExtended != null) {
                if (requestedTypeOfUP.isDelta()) {
                    string = upgradePackageMoExtended.getDocumentNumber(null);
                    string2 = upgradePackageMoExtended.getDocumentRevision(null);
                    string3 = upgradePackageMoExtended.getUP_CompatibilityIndex(null);
                } else {
                    string = upgradePackageMoExtended.getBaseUP_ProductNumber(null);
                    string2 = upgradePackageMoExtended.getBaseUP_ProductRevision(null);
                    object2 = ServiceFinder.getUpgradePackageMO_HandlerInterface();
                    object = object2.getUpgradePackageMo(string, string2);
                    if (object != null) {
                        string3 = object.getUP_CompatibilityIndex(null);
                    } else {
                        Trace.warning(this.getClass(), "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, RequestedTypeOfUP aRequestedTypeOfUP, Coordinator aCoordinator)", "Couldn't look up the master (root) UP for the current active delta UP i.e. no Up Compatbility index can be used.\n\taRequestedTypeOfUP: " + requestedTypeOfUP + "\n\ttheCurrentBaseUpgradePackageProductNumber: " + string + "\n\ttheCurrentBaseUpgradePackageProductRevision: " + string2);
                    }
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "Active UP exist on the node. From state information:\n\ttheCurrentUpgradePackageProductNumber: " + string + "\n\ttheCurrentUpgradePackageProductRevision: " + string2 + "\n\ttheUP_CompatibilityIndex: " + string3);
                }
            } else {
                string = documentObjectProxy.getProductDataProxyInterface().getProductDataRaw().getNumber();
                string2 = documentObjectProxy.getProductDataProxyInterface().getProductDataRaw().getRevision();
                string3 = documentObjectProxy.getUP_CompatibilityIndexProxyInterface().getIndex();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "Active UP does not exist on the node. Assuming that this installed UP will be used at upgrade. From state information:\n\ttheCurrentUpgradePackageProductNumber: " + string + "\n\ttheCurrentUpgradePackageProductRevision: " + string2 + "\n\ttheUP_CompatibilityIndex: " + string3);
                }
            }
            object2 = documentObjectProxy.getValidUpgradeCases(string, string2, string3);
            object = this.checkAndGetFirstValidUpgradeCase((ValidUpgradeCasesInformation)object2);
            ValidSequencesInformation validSequencesInformation = documentObjectProxy.getValidSequences(string, string2, string3);
            Collection collection = this.checkAndGetValidUpgradeSequences(validSequencesInformation);
            RepertoireCollector repertoireCollector = new RepertoireCollector();
            Vector vector = repertoireCollector.getConnectedRepertoires(coordinator);
            if (vector.size() == 0) {
                Trace.error(this.getClass(), "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "No repertoires are connected in Mo SwAllocation. Not allowed to do a selective upgrade without any connected repertoires.");
                throw new SelectiveInstallFailureException("No repertoires are connected in Mo SwAllocation. Not allowed to do a selective upgrade without any connected repertoires.");
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "theConnectedRepertoireNames: " + vector);
            }
            Collection collection2 = documentObjectProxy.getRepertoireNamesToBeUsed(vector, (String)object);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "theRepertoireNamesToBeUsed: " + collection2);
            }
            Collection collection3 = documentObjectProxy.getRunRemoveProgramRepertoirNames(collection);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "theRunRemoveProgramRepertoirNames: " + collection3);
            }
            collection2.addAll(collection3);
            Collection collection4 = documentObjectProxy.getNotUsedRepertoireNames(collection2);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "theNotUsedRepertoireNames: " + collection4);
            }
            SwAllocationHelper swAllocationHelper = new SwAllocationHelper();
            ActiveOtherLMsMO_HandlerInterface activeOtherLMsMO_HandlerInterface = ServiceFinder.getActiveOtherLMsMO_HandlerInterface();
            ManagedObject managedObject = activeOtherLMsMO_HandlerInterface.getActiveOtherLMsMO().getReservedSwAllocationMo(coordinator);
            Vector vector2 = swAllocationHelper.getConnectedRepertoirNames((SwAllocationMoSU_Access)managedObject);
            Collection collection5 = documentObjectProxy.getRepertoireNamesToBeUsed(vector2, (String)object);
            boolean bl = documentObjectProxy.isRepertoiresInToState(collection5);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "theIsActiveOtherLMsConnectedInToState: " + bl);
            }
            RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxy.getRepertoiresProxyInterface();
            repertoiresProxyInterface.removeRepertoires(collection4);
            documentObjectProxy.removeLoadModulesNotReferenced(collection2, validSequencesInformation.getAllFirstSupportedSequenceInformationLabels(), bl);
            documentObjectProxy.removePiuTypesNotReferencedInRepertoires(collection2, documentObjectUpgradePackage);
            RepertoireReplacementsProxyInterface repertoireReplacementsProxyInterface = documentObjectProxy.getExplicitReplacementsProxyInterface().getRepertoireReplacementsProxyInterface();
            repertoireReplacementsProxyInterface.removeNotValidRepertoireReplacements(collection2);
            documentObjectProxy.setUpgradePackageType("Standard");
            return documentObjectUpgradePackage;
        }
        catch (SelectiveInstallFailureException selectiveInstallFailureException) {
            throw selectiveInstallFailureException;
        }
        catch (ControlFileElementSelectorException controlFileElementSelectorException) {
            throw controlFileElementSelectorException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "Selection of required elements (LMs, PiuTypes and repertoires) in UCF failed.\n\tMoAccessException reason: " + moAccessException.getMessage(), moAccessException);
            throw moAccessException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, Coordinator aCoordinator)", "Selection of required elements (LMs, PiuTypes and repertoires) in UCF failed.\n\tThrowable reason: " + throwable, throwable);
            throw new SelectiveInstallFailureException("Selection of required elements (LMs, PiuTypes and repertoires) in UCF failed.\n\tThrowable reason: " + throwable);
        }
    }

    public boolean printMergedFile(PrintStream printStream, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws MergeControlFileException, UpgradeControlFileParserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printMergedFile(PrintStream aPrintstreamForMergedUCF,  DocumentObjectUpgradePackage anAdaptedDocumentObjectUpgradePackage)", "aPrintstreamForMergedUCF: " + printStream + "\n\tanAdaptedDocumentObjectUpgradePackage: " + documentObjectUpgradePackage);
        }
        documentObjectUpgradePackage.print(printStream, "");
        return true;
    }

    private String checkAndGetFirstValidUpgradeCase(ValidUpgradeCasesInformation validUpgradeCasesInformation) throws ControlFileElementSelectorException {
        String string;
        String string2 = "checkAndGetFirstValidUpgradeCase(ValidUpgradeCasesInformation aValidUpgradeCasesInformation)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "aValidUpgradeCasesInformation: " + validUpgradeCasesInformation);
        }
        if ((string = validUpgradeCasesInformation.getFirstFoundSupportedUpgradeCase()) == null) {
            throw new ControlFileElementSelectorException("Class name: " + this.getClass().getName() + "\n\t" + string2 + "\n\tNo valid upgrade or update case found with current from state.");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkAndGetFirstValidUpgradeCase(ValidUpgradeCasesInformation aValidUpgradeCasesInformation)", "Returning - theFirstValidUpgradeCase: " + string);
        }
        return string;
    }

    private Collection checkAndGetValidUpgradeSequences(ValidSequencesInformation validSequencesInformation) throws ControlFileElementSelectorException {
        Vector vector;
        String string = "checkAndGetValidUpgradeSequences(ValidSequencesInformation aValidSequencesInformation)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aValidSequencesInformation: " + validSequencesInformation);
        }
        if ((vector = validSequencesInformation.getAllFirstSupportedSequenceInformationLabels()).isEmpty()) {
            throw new ControlFileElementSelectorException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tNo valid upgrade or update sequence found with current from state.");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "Returning - theSupportedSequenceLabels: " + vector);
        }
        return vector;
    }
}

