/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.trigger;

import org.xml.sax.SAXException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.trigger.TriggerCentralHandlerInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerApplicationUniqueInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerConfirmedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerConvertInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerExecuteInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerFinishInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerInitiateInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerPreloadInformation;

public final class TriggerOp
implements ExecutableOp {
    private String subSpec;
    private int supervisionTime = 3600;
    private UpgradePackageMoExtended myUP_Mo = null;
    private String myStepLabel = null;

    public TriggerOp(String string, UpgradePackageMoExtended upgradePackageMoExtended) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "TriggerOp ( String subSpec )", "subSpec: " + string);
        }
        this.subSpec = string;
        this.myUP_Mo = upgradePackageMoExtended;
    }

    public TriggerOp(String string, int n, UpgradePackageMoExtended upgradePackageMoExtended, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "TriggerOp ( String subSpec, int aSupervisionTime )", "subSpec: " + string + "\n\taSupervisionTime: " + n);
        }
        this.subSpec = string;
        this.supervisionTime = n;
        this.myUP_Mo = upgradePackageMoExtended;
        this.myStepLabel = string2;
    }

    public TriggerOp(String string, int n, UpgradePackageMoExtended upgradePackageMoExtended) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "TriggerOp ( String subSpec, int aSupervisionTime )", "subSpec: " + string + "\n\taSupervisionTime: " + n);
        }
        this.subSpec = string;
        this.supervisionTime = n;
        this.myUP_Mo = upgradePackageMoExtended;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute trigger '" + this.subSpec + "' operation.");
        if (this.myStepLabel != null) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
        }
        this.doSendProgressInformation();
        boolean bl = this.doSendToTriggerCentral();
        if (!bl) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Operation 'issueTrigger ( subSpec )' in class TriggerCentral returned unexpected result ( i.e. 'false' ), Trigger name: " + this.subSpec);
            throw new SAXException("Exception from trigger " + this.subSpec);
        }
    }

    public boolean doTriggerCentral() {
        Trace.log1(this.getClass(), "doTriggerCentral()", "Execute trigger '" + this.subSpec + "' operation.");
        this.doSendProgressInformation();
        return this.doSendToTriggerCentral();
    }

    private void doSendProgressInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doSetProgressHeaderAndSendToTriggerCentral()", "subSpec: " + this.subSpec + "\n\taSupervisionTime: " + this.supervisionTime);
        }
        try {
            if (this.subSpec.equalsIgnoreCase("INITIATE")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerInitiateInformation(this));
            } else if (this.subSpec.equalsIgnoreCase("PRELOAD")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerPreloadInformation(this));
            } else if (this.subSpec.equalsIgnoreCase("CONVERT")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerConvertInformation(this));
            } else if (this.subSpec.equalsIgnoreCase("FINISH")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerFinishInformation(this));
            } else if (this.subSpec.equalsIgnoreCase("EXECUTE")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerExecuteInformation(this));
            } else if (this.subSpec.equalsIgnoreCase("CONFIRMED")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerConfirmedInformation(this));
            } else {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new TriggerApplicationUniqueInformation((Object)this, this.subSpec));
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "", "Failed to send progress information about which trigger that is in execution.\n\tTrigger name: " + this.subSpec);
        }
    }

    private boolean doSendToTriggerCentral() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doSendToTriggerCentral ( )");
        }
        try {
            if (this.subSpec.equalsIgnoreCase("SUSPEND_PM")) {
                UpgradeDB_StorageUtil.saveSuspendPM(true);
            }
            if (this.subSpec.equalsIgnoreCase("RESUME_PM")) {
                UpgradeDB_StorageUtil.removeSuspendPM();
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "doSendToTriggerCentral()", "Unable to understand if PM shall be suspended/ resumed (ignored)\n\tFailure reason: " + throwable);
        }
        TriggerCentralHandlerInterface triggerCentralHandlerInterface = (TriggerCentralHandlerInterface)ServiceLocatorFacade.getRepository().getService(TriggerCentralHandlerInterface.class);
        return triggerCentralHandlerInterface.issueTrigger(this.subSpec, this.supervisionTime, this.myUP_Mo.getStateValue());
    }
}

