/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.handler;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.InvalidProductRevisionFormatException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.handler.PiuTypeToStateHandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class PiuTypeToStateHandler {
    public ProductNumbersAndRevisions getToStateProductNumbersAndRevisions(PiuTypesProxyInterface piuTypesProxyInterface, Collection collection) throws PiuTypeToStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getToStateProductNumbersAndRevisions(PiuTypesProxyInterface aPiuTypesProxy, Collection aPiuMos)", "aPiuTypesProxy: " + piuTypesProxyInterface + "\n\taPiuMos: " + collection);
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        ProductNumbersAndRevisions productNumbersAndRevisions2 = piuTypesProxyInterface.getProductNumberAndRevisionOfPiuTypes();
        ProductNumberAndRevision productNumberAndRevision = null;
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
            productNumberAndRevision = this.getToStateProductNumbersAndRevision(genericUpgradeablePlugInUnit, productNumbersAndRevisions2);
            if (productNumberAndRevision == null || productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
            productNumbersAndRevisions.addElement(productNumberAndRevision);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getToStateProductNumbersAndRevisions(PiuTypesProxyInterface aPiuTypesProxy, Collection aPiuMos)", "Returns - theToStateProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        return productNumbersAndRevisions;
    }

    public ProductNumberAndRevision getToStateProductNumbersAndRevision(PiuTypesProxyInterface piuTypesProxyInterface, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws PiuTypeToStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getToStateProductNumbersAndRevision(PiuTypesProxyInterface aPiuTypesProxy, GenericUpgradeablePlugInUnit aPiuMo)", "aPiuTypesProxy: " + piuTypesProxyInterface + "\n\taPiuMo: " + genericUpgradeablePlugInUnit);
        }
        return this.getToStateProductNumbersAndRevision(genericUpgradeablePlugInUnit, piuTypesProxyInterface.getProductNumberAndRevisionOfPiuTypes());
    }

    private ProductNumberAndRevision getToStateProductNumbersAndRevision(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeToStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getToStateProductNumbersAndRevision(GenericUpgradeablePlugInUnit aPiuMo, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "aPiuMo: " + genericUpgradeablePlugInUnit + "\n\tanUcfProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        try {
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
            ProductNumberAndRevision productNumberAndRevision2 = null;
            productNumberAndRevision2 = ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3") ? new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null)) : new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "addToStateProductNumbersAndRevision(GenericUpgradeablePlugInUnit aPiuMo, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "The PIUs productAndRevision: " + productNumberAndRevision2);
            }
            if (productNumbersAndRevisions.contains(productNumberAndRevision2)) {
                productNumberAndRevision = productNumberAndRevision2;
            } else {
                productNumberAndRevision = this.getToStateProductNumbersAndRevision(productNumberAndRevision2, productNumbersAndRevisions);
                if (productNumberAndRevision == null) {
                    productNumberAndRevision = this.getToStateProductNumbersAndRevision(genericUpgradeablePlugInUnit, productNumberAndRevision2.getProductNumber(), productNumbersAndRevisions);
                }
            }
        }
        catch (MoAccessException moAccessException) {
            throw new PiuTypeToStateHandlerException("MoAccessException caught when collecting information of the to state PiuTypes: " + moAccessException.toString());
        }
        catch (Throwable throwable) {
            throw new PiuTypeToStateHandlerException("Throwable caught when collecting information of the to state PiuTypes: " + throwable.toString());
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getToStateProductNumbersAndRevision(GenericUpgradeablePlugInUnit aPiuMo, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "Returning - theToStateProductNumberAndRevision: " + productNumberAndRevision);
        }
        return productNumberAndRevision;
    }

    private ProductNumberAndRevision getToStateProductNumbersAndRevision(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string, ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeToStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getToStateProductNumbersAndRevision(GenericUpgradeablePlugInUnit aPiuMo, String aPIU_ProductNumber, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "aPiuMo: " + genericUpgradeablePlugInUnit + "\n\taPIU_ProductNumber: " + string + "\n\tanUcfProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
            try {
                PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                String string2 = pIU_MO_HandlerInterface.getOriginRevision((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit);
                ProductNumberAndRevision productNumberAndRevision2 = new ProductNumberAndRevision(string, string2);
                productNumberAndRevision = this.getToStateProductNumbersAndRevision(productNumberAndRevision2, productNumbersAndRevisions);
            }
            catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
                throw new PiuTypeToStateHandlerException("PIU_MO_HandlerException caught when reading the original revision for PIU MO: " + (Object)((Object)pIU_MO_HandlerException));
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getToStateProductNumbersAndRevision(UpgradeablePlugInUnit aPiuMo, String aPIU_ProductNumber, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "Returns - theProductNumberAndRevision: " + productNumberAndRevision);
        }
        return productNumberAndRevision;
    }

    private ProductNumberAndRevision getToStateProductNumbersAndRevision(ProductNumberAndRevision productNumberAndRevision, ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeToStateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getToStateProductNumbersAndRevision(ProductNumberAndRevision aPiuProductNumberAndRevision, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "aPiuProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUcfProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        ProductNumberAndRevision productNumberAndRevision2 = null;
        String string = productNumberAndRevision.getRevision();
        try {
            String string2 = ProductNumberAndRevision.getShortProductRevision(string);
            if (!productNumbersAndRevisions.contains(productNumberAndRevision.getProductNumber(), string2)) {
                string2 = "*";
                if (!productNumbersAndRevisions.contains(productNumberAndRevision.getProductNumber(), string2)) {
                    string2 = null;
                }
            }
            if (string2 != null) {
                productNumberAndRevision2 = new ProductNumberAndRevision(productNumberAndRevision.getProductNumber(), string2);
            }
        }
        catch (InvalidProductRevisionFormatException invalidProductRevisionFormatException) {
            throw new PiuTypeToStateHandlerException("InvalidProductRevisionFormatException caught when checking shortproduct revision information of the to state PiuTypes: " + invalidProductRevisionFormatException.toString());
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getToStateProductNumbersAndRevision(ProductNumberAndRevision aPiuProductNumberAndRevision, ProductNumbersAndRevisions anUcfProductNumbersAndRevisions)", "Returns - theNewProductNumberAndRevision: " + productNumberAndRevision2);
        }
        return productNumberAndRevision2;
    }
}

