/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.jvm;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.FilepathHandler;
import se.ericsson.cello.support.debug.JavaHeap;
import se.ericsson.cello.support.debug.OseHeap;
import se.ericsson.cello.support.debug.OsePool;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.NotAbleToReadJVM_RPU_DataException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;
import se.ericsson.cello.upgradepackage.verify.ChecksumFileWriterException;

public class JvmMO_Handler
implements JvmMO_HandlerInterface {
    private static final String COLON = ":";
    private static final String KILO_BYTE_SMALL = "k";
    private static final String KILO_BYTE_CAPS = "K";
    private static final String MEGA_BYTE_SMALL = "m";
    private static final String MEGA_BYTE_CAPS = "M";
    private static final String GIGA_BYTE_SMALL = "g";
    private static final String GIGA_BYTE_CAPS = "G";
    public static final int WRONG_FORMAT = -1;
    public static final int OPTION_UNDEFINED = -2;

    public JvmMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "JvmMO_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public PlugInUnitMoSU_Access[] getJVM_PIUs() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJVM_PIUs()");
        }
        try {
            LinkedList linkedList = this.getJVM_PIUsList();
            return linkedList.toArray(new PlugInUnitMoSU_Access[0]);
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            throw notAbleToReadJVM_RPU_DataException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJVM_PIUs()", "Throwable caught at ...", throwable);
            throw new JvmMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetJVM_PIUs()" + "\n\tThrowable caught at ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public LinkedList getJVM_PIUsList() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJVM_PIUsList()");
        }
        try {
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = this.getReliableProgramUniter(null);
            SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
            SlotMoSU_Access slotMoSU_Access2 = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            LinkedList<PlugInUnitMoSU_Access> linkedList = new LinkedList<PlugInUnitMoSU_Access>();
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access);
            if (plugInUnitMoSU_Access != null) {
                linkedList.add(plugInUnitMoSU_Access);
            }
            if ((plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access2)) != null) {
                linkedList.add(plugInUnitMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getJVM_PIUsList()", "RETURNS - theJVM_PiuMos: " + linkedList);
            }
            return linkedList;
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            throw notAbleToReadJVM_RPU_DataException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJVM_PIUs()", "Throwable caught at ...", throwable);
            throw new JvmMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetJVM_PIUs()" + "\n\tThrowable caught at ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public LinkedList getJVM_SlotsList() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJVM_SlotsList()");
        }
        try {
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = this.getReliableProgramUniter(null);
            SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
            SlotMoSU_Access slotMoSU_Access2 = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
            LinkedList<SlotMoSU_Access> linkedList = new LinkedList<SlotMoSU_Access>();
            if (slotMoSU_Access != null) {
                linkedList.add(slotMoSU_Access);
            }
            if (slotMoSU_Access2 != null) {
                linkedList.add(slotMoSU_Access2);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getJVM_SlotsList()", "RETURNS - theJVM_SlotMos: " + linkedList);
            }
            return linkedList;
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            throw notAbleToReadJVM_RPU_DataException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJVM_PIUs()", "Throwable caught at ...", throwable);
            throw new JvmMO_HandlerException(throwable.toString());
        }
    }

    public SwAllocationMoSU_Access getReferencedSwAllocationMo() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getReferencedSwAllocationMo()");
        }
        try {
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            JvmMoSU_Access jvmMoSU_Access = this.getJvmMO();
            swAllocationMoSU_Access = (SwAllocationMoSU_Access)jvmMoSU_Access.getReservedSwAllocationMo(null);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getReferencedSwAllocationMo()", "RETURNS - " + swAllocationMoSU_Access);
            }
            return swAllocationMoSU_Access;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getReferencedSwAllocationMo()", "Throwable caught.", throwable);
            throw new JvmMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getReferencedSwAllocationMo()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public JvmMoSU_Access getJvmMO() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJvmMO()");
        }
        ManagedObject managedObject = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("Jvm")).getMo();
        JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)managedObject;
        return jvmMoSU_Access;
    }

    public ReliableProgramUniterMoSU_Access getReliableProgramUniter(Coordinator coordinator) throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getReliableProgramUniter(Coordinator aCoordinator)", "aCoordinator: " + Transaction.toString(coordinator));
        }
        return this.getReliableProgramUniter(coordinator, 2);
    }

    public boolean isJVM_Slot(SlotMoSU_Access slotMoSU_Access) throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isJVM_Slot(SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        try {
            if (slotMoSU_Access != null) {
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = this.getReliableProgramUniter(null);
                if (slotMoSU_Access.equals((SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmActiveSlot(null))) {
                    return true;
                }
                if (slotMoSU_Access.equals((SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null))) {
                    return true;
                }
            }
            return false;
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isJVM_Slot(SlotMoSU_Access aSlotMo)", "Throwable caught at ...", throwable);
            throw new JvmMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tisJVM_Slot(SlotMoSU_Access aSlotMo)" + "\n\tThrowable caught at ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public boolean isNewClassPathEqualToCurrent(ManagedObject[] managedObjectArray) throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isNewClassPathEqualToCurrent(ManagedObject[] aNewLoadModuleMOs)", "aNewLoadModuleMOs: " + SuLib.toString(managedObjectArray));
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            String string = jvmMoSU_Access.getClasspath(null);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isNewClassPathEqualToCurrent(ManagedObject[] aNewLoadModuleMOs)", "Current classpath: " + string);
            }
            String string2 = "";
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof LoadModuleMoSU_Access)) continue;
                string2 = i < managedObjectArray.length - 1 ? string2 + ((LoadModuleMoSU_Access)managedObjectArray[i]).getLoadModuleFilePath(null) + COLON : string2 + ((LoadModuleMoSU_Access)managedObjectArray[i]).getLoadModuleFilePath(null);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isNewClassPathEqualToCurrent(ManagedObject[] aNewLoadModuleMOs)", "New class: " + string2);
            }
            return string != null && string.equals(string2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isNewClassPathEqualToCurrent(ManagedObject[] aNewLoadModuleMOs)", "Exception caught when trying to set the class path in the JVM.\n\taNewLoadModuleMOs: " + SuLib.toString(managedObjectArray) + "\n\tLength of aNewLoadModuleMOs:" + managedObjectArray.length + "\n\tException data: " + throwable.toString(), throwable);
            throw new JvmMO_HandlerException("Throwable caught when trying to compare new with current class path in the JVM.\n\taNewLoadModuleMOs: " + SuLib.toString(managedObjectArray) + "\n\tLength of aNewLoadModuleMOs:" + managedObjectArray.length + "\n\tException data: " + throwable.toString());
        }
    }

    public void logMemoryInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "logMemoryInformation()");
        }
        try {
            JavaHeap javaHeap = new JavaHeap();
            OseHeap oseHeap = new OseHeap();
            OsePool osePool = new OsePool();
            Trace.log1(this.getClass(), "logMemoryInformation()", "Java Heap information:\n\tMeasured maximum usage since last reset or system start: " + javaHeap.getMaxUsed() + "\n\tTotal size: " + javaHeap.getSize() + "\n\tMeasured usage: " + javaHeap.getUsed() + "\n\n\tOse Heap information:" + "\n\tMeasured maximum usage since last reset or system start: " + oseHeap.getMaxUsed() + "\n\tTotal size: " + oseHeap.getSize() + "\n\tMeasured usage: " + oseHeap.getUsed() + "\n\n\tOse Pool information:" + "\n\tMeasured maximum usage since last reset or system start: " + osePool.getMaxUsed() + "\n\tTotal size: " + osePool.getSize() + "\n\tMeasured usage: " + osePool.getUsed());
        }
        catch (Throwable throwable) {
            Trace.log2(this.getClass(), "logMemoryInformation ()", "Failed to log memory information (ignoring).\n\tThrowable data: " + throwable);
        }
    }

    public void setClassPath(ManagedObject[] managedObjectArray) throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setClassPath(ManagedObject[] aLoadModuleMOs)", "aLoadModuleMOs: " + SuLib.toString(managedObjectArray));
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            Control control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            String string = jvmMoSU_Access.getClasspath(coordinator);
            String string2 = "";
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof LoadModuleMoSU_Access)) continue;
                LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                if (loadModuleMO_HandlerInterface.isSU_VersionSupported("SU_4", (LoadModuleMoSU_Access)managedObjectArray[i])) {
                    if (i < managedObjectArray.length - 1) {
                        string2 = string2 + ((LoadModuleMoSU_Access)managedObjectArray[i]).getLoadModuleFilePathSU(null) + COLON;
                        continue;
                    }
                    string2 = string2 + ((LoadModuleMoSU_Access)managedObjectArray[i]).getLoadModuleFilePathSU(null);
                    continue;
                }
                string2 = i < managedObjectArray.length - 1 ? string2 + ((LoadModuleMoSU_Access)managedObjectArray[i]).getLoadModuleFilePath(null) + COLON : string2 + ((LoadModuleMoSU_Access)managedObjectArray[i]).getLoadModuleFilePath(null);
            }
            Trace.log1(this.getClass(), "setClassPath(ManagedObject[] aLoadModuleMOs)", "Current classpath: " + string + "\n\tNew classpath: " + string2);
            jvmMoSU_Access.setAdmClasspath(managedObjectArray, coordinator);
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setClassPath(ManagedObject[] aLoadModuleMOs)", "Exception caught when trying to set the class path in the JVM.\n\taLoadModuleMOs: " + SuLib.toString(managedObjectArray) + "\n\tLength of aLoadModuleMOs:" + managedObjectArray.length + "\n\tThrowable data: " + throwable.toString(), throwable);
            throw new JvmMO_HandlerException("Throwable caught when trying to set the class path in the JVM.\n\taLoadModuleMOs: " + SuLib.toString(managedObjectArray) + "\n\tLength of aLoadModuleMOs:" + managedObjectArray.length + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public LoadModuleMoSU_Access[] getAdmClassPath() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAdmClassPath()");
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            ManagedObject[] managedObjectArray = jvmMoSU_Access.getAdmClasspath(null);
            Object[] objectArray = new LoadModuleMoSU_Access[managedObjectArray.length];
            for (int i = 0; i < managedObjectArray.length; ++i) {
                objectArray[i] = (LoadModuleMoSU_Access)managedObjectArray[i];
            }
            if (objectArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAdmClassPath()", "AdmClasspath = 0 i.e. probably the Jvm is initial configured where the class path has been set by using the LMs in the java directory.");
                }
                String string = jvmMoSU_Access.getClasspath(null);
                Vector vector = this.createAdmClasspathFromClasspath(string);
                objectArray = new LoadModuleMoSU_Access[vector.size()];
                vector.copyInto(objectArray);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getAdmClassPath()", "RETURNS - theLoadModules: " + SuLib.toString((ManagedObject[])objectArray));
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAdmClassPath()", "Throwable caught.", throwable);
            throw new JvmMO_HandlerException(throwable.toString());
        }
    }

    public Collection getAdmClassPathAsCollection() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAdmClassPathAsCollection( )");
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            ManagedObject[] managedObjectArray = jvmMoSU_Access.getAdmClasspath(null);
            Vector vector = new Vector(managedObjectArray.length);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                vector.add((LoadModuleMoSU_Access)managedObjectArray[i]);
            }
            if (vector.size() == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAdmClassPathAsCollection( )", "AdmClasspath = 0 i.e. probably the Jvm is initial configured where the class path has been set by using the LMs in the java directory.");
                }
                String string = jvmMoSU_Access.getClasspath(null);
                vector = this.createAdmClasspathFromClasspath(string);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getAdmClassPathAsCollection( )", "RETURNS - theLMs: " + vector);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAdmClassPathAsCollection( )", "Throwable caught.", throwable);
            throw new JvmMO_HandlerException(throwable.toString());
        }
    }

    private Vector createAdmClasspathFromClasspath(String string) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAdmClasspathFromClasspath(String aClassPath)", "aClassPath: " + string);
        }
        if (string == null || string.length() == 0) {
            return new Vector(0);
        }
        Vector<String> vector = new Vector<String>(8);
        int n = string.indexOf(COLON);
        if (n != -1) {
            vector.addElement(string.substring(0, n));
            int n2 = 0;
            int n3 = string.length();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createAdmClasspathFromClasspath(String aClassPath)", "length " + n3 + string.substring(0, n));
            }
            while ((n2 = string.indexOf(COLON, n + 1)) != -1 && n2 < n3) {
                vector.addElement(string.substring(n + 1, n2));
                n = n2;
            }
        }
        vector.addElement(string.substring(n + 1));
        MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        HashMap<String, LoadModuleMoSU_Access> hashMap = new HashMap<String, LoadModuleMoSU_Access>();
        String string2 = null;
        Vector<LoadModuleMoSU_Access> vector2 = new Vector<LoadModuleMoSU_Access>(vector.size());
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                hashMap.put(loadModuleMoSU_Access.getLoadModuleFilePath(null), loadModuleMoSU_Access);
            }
            for (int i = 0; i < vector.size(); ++i) {
                string2 = (String)vector.elementAt(i);
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)hashMap.get(string2);
                if (loadModuleMoSU_Access == null) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "createAdmClasspathFromClasspath(String aClassPath)", "Found a matching load module: " + loadModuleMoSU_Access + "\n\tfilepath: " + string2);
                }
                vector2.addElement(loadModuleMoSU_Access);
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createAdmClasspathFromClasspath(String aClassPath)", "RETURNS - theLMs: " + vector2);
        }
        return vector2;
    }

    public long getJavaHeapSizeInBytes() throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJavaHeapSizeInBytes ()");
        }
        String string = null;
        String string2 = null;
        String string3 = "-Xms";
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            String string4 = jvmMoSU_Access.getOptions(null);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.startsWith(string3)) continue;
                if (string2.endsWith(KILO_BYTE_SMALL) || string2.endsWith(KILO_BYTE_CAPS)) {
                    string = string2.substring(string3.length(), string2.length() - 1);
                    long l = new Long(string);
                    return l * 1024L;
                }
                if (string2.endsWith(MEGA_BYTE_SMALL) || string2.endsWith(MEGA_BYTE_CAPS)) {
                    string = string2.substring(string3.length(), string2.length() - 1);
                    long l = new Long(string);
                    return l * 1024L * 1024L;
                }
                if (string2.endsWith(GIGA_BYTE_SMALL) || string2.endsWith(GIGA_BYTE_CAPS)) {
                    string = string2.substring(string3.length(), string2.length() - 1);
                    long l = new Long(string);
                    return l * 1024L * 1024L * 1024L;
                }
                string = string2.substring(string3.length(), string2.length());
                return new Long(string);
            }
            return -2L;
        }
        catch (NumberFormatException numberFormatException) {
            Trace.log1(this.getClass(), "getJavaHeapSizeInBytes()", "\n\tNumberFormatException caught when trying to get Java Heapsize in attribute 'options' in the Jvm MO (returns -1)\n\ttheJavaHeapSizeString: " + string);
            return -1L;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJavaHeapSizeInBytes()", "Throwable caught when trying to get Java Heapsize in attribute 'options' in the Jvm MO.", throwable);
            throw new JvmMO_HandlerException("getJavaHeapSizeInBytes()\n\tException caught when trying to get Java Heapsize in attribute 'admOptions' in the Jvm MO.\n\tCaught aThrowable: " + throwable.toString());
        }
    }

    public void setJavaHeapSize(Integer n) throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setJavaHeapSize(Integer aJavaHeapSize)", "aJavaHeapSize: " + n);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            String string = jvmMoSU_Access.getOptions(coordinator);
            Vector<String> vector = new Vector<String>(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = null;
            boolean bl = false;
            if (n != -1 && n != -2) {
                vector.addElement("-Xms" + n + KILO_BYTE_SMALL);
                bl = true;
            } else if (n == -1) {
                Trace.warning(this.getClass(), "setJavaHeapSize(Integer aJavaHeapSize)", "Problem while getting Java Heap Size\n\taJavaHeapSize: " + n);
            }
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.startsWith("-Xms")) {
                    vector.addElement(string2);
                    continue;
                }
                if (bl || n == -2) continue;
                vector.addElement(string2);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            jvmMoSU_Access.setAdmOptions((String[])objectArray, coordinator);
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setJavaHeapSize(Integer aJavaHeapSize)", "Exception caught when trying to set Java Heapsize in attribute 'admOptions' in the Jvm MO.\n\tRequested Java Heapsize: " + n, exception);
            this.rollbackTransactionIfNeeded(control);
            throw new JvmMO_HandlerException("setJavaHeapSize(Integer aJavaHeapSize)\n\tException caught when trying to set Java Heapsize in attribute 'admOptions' in the Jvm MO.\n\tRequested Java Heapsize: " + n + "\n\tCaught Exception: " + exception.toString());
        }
    }

    public String selectDestinationAbsolutePathForJVMLoadModule(String string) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectDestinationAbsolutePathForJVMLoadModule(String aLoadModuleDestinationAbsolutePath)", "aLoadModuleDestinationAbsolutePath: " + string);
        }
        try {
            String string2 = FilepathHandler.addInstallDirectoryToLoadModulePath(string);
            File file = new File(string2);
            if (file.exists()) {
                return string2;
            }
            File file2 = new File(string);
            if (!file2.exists() && Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "selectDestinationAbsolutePathForJVMLoadModule(String aLoadModuleDestinationAbsolutePath)", "The Load Module of type JVM is not found on specified destination path (this should not happen). \n\taLoadModuleDestinationAbsolutePath: " + string);
            }
            return string;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "selectDestinationAbsolutePathForJVMLoadModule(String aLoadModuleDestinationAbsolutePath)", "Exception caught when selecting the destination path for a JVM Load Module file.\n\taLoadModuleDestinationAbsolutePath: " + string, exception);
            throw new ChecksumFileWriterException("Exception caught when selecting the destination path for a JVM Load Module file.\n\taLoadModuleDestinationAbsolutePath: " + string + "\n\tException: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "selectDestinationAbsolutePathForJVMLoadModule(String aLoadModuleDestinationAbsolutePath)", "Exception caught when selecting the destination path for a JVM Load Module file.Error caught at retreival of the current class path.\n\taLoadModuleDestinationAbsolutePath: " + string, error);
            throw new ChecksumFileWriterException("Exception caught when selecting the destination path for a JVM Load Module file.\n\taLoadModuleDestinationAbsolutePath: " + string + "\n\tError: " + error.toString());
        }
    }

    private ReliableProgramUniterMoSU_Access getReliableProgramUniter(Coordinator coordinator, int n) throws JvmMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getReliableProgramUniter(Coordinator aCoordinator)", "aCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n);
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            --n;
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)jvmMoSU_Access.getReliableProgramUniter(coordinator);
            if (reliableProgramUniterMoSU_Access != null) {
                return reliableProgramUniterMoSU_Access;
            }
            throw new NotAbleToReadJVM_RPU_DataException("Class name: " + this.getClass().getName() + "\n\tgetReliableProgramUniter(Coordinator aCoordinator)" + "\n\tNo RPU found for the JVM." + "\n\tThrows exception NotAbleToReadJVM_RPU_DataException to indicate that no RPU is connected to the JVM.");
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            throw notAbleToReadJVM_RPU_DataException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getReliableProgramUniter(Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to retreive the reliable program uniter for the JVM.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.getReliableProgramUniter(coordinator, n);
            }
            Trace.error(this.getClass(), "getReliableProgramUniter(Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to retreive the reliable program uniter for the JVM.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new JvmMO_HandlerException("Exception caught when trying to retreive the reliable program uniter for the JVM.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getReliableProgramUniter(Coordinator aCoordinator)", "Throwable caught when trying to retreive the reliable program uniter for the JVM.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + throwable.toString(), throwable);
            throw new JvmMO_HandlerException("Exception caught when trying to retreive the reliable program uniter for the JVM.\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + throwable.toString());
        }
    }

    private void rollbackTransactionIfNeeded(Control control) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rollbackTransactionIfNeeded(Control aControl)", "aControl: " + control);
        }
        try {
            if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                control.getTerminator().rollback();
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "rollbackTransactionIfNeeded(Control aControl)", "Rollback failed even though the transaction was active.", exception);
        }
    }
}

