/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.repertoire;

import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.UnexpectedLoaderTypeValueException;

public class LoadModuleInformationsContainer {
    private LinkedList myLoadModulesInformations = new LinkedList();
    private static final String EMPTY_STRING = "";

    public LoadModuleInformationsContainer(LoadModuleInformation loadModuleInformation) {
        this.myLoadModulesInformations.add(loadModuleInformation);
    }

    public void addLoadModuleInformation(LoadModuleInformation loadModuleInformation) {
        this.myLoadModulesInformations.add(loadModuleInformation);
    }

    public Iterator getAllLoadModuleInformationIter() {
        return this.myLoadModulesInformations.iterator();
    }

    public void setLoadModuleInformation(int n, LoadModuleInformation loadModuleInformation) {
        this.myLoadModulesInformations.set(n, loadModuleInformation);
    }

    public boolean containsOnlyOneLoadModuleInformation() {
        return this.myLoadModulesInformations.size() == 1;
    }

    public LoadModuleInformation getLoadModuleInformation(int n) {
        return (LoadModuleInformation)this.myLoadModulesInformations.get(n);
    }

    public int getLoadModuleInformationIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.myLoadModulesInformations.size(); ++i) {
            if (!((LoadModuleInformation)this.myLoadModulesInformations.get(i)).getLoaderType().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public LoadModuleInformation getFirstLoadModuleInformation() {
        return (LoadModuleInformation)this.myLoadModulesInformations.getFirst();
    }

    public void filterEqualLoadModuleInformation(LoadModuleMoSU_Access loadModuleMoSU_Access) throws MoAccessException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "filterEqualLoadModuleInformation(LoadModuleMoSU_Access theLoadModule)", "theLoadModule: " + loadModuleMoSU_Access + "myLoadModulesInformations: " + this.toNiceString());
        }
        if (!this.containsOnlyOneLoadModuleInformationForLdn(loadModuleMoSU_Access.getLocalDistinguishedName())) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "filterEqualLoadModuleInformation(LoadModuleMoSU_Access theLoadModule)", "The list contains more than one LoadModuleInformation, filtering.");
            }
            LinkedList<LoadModuleInformation> linkedList = new LinkedList<LoadModuleInformation>();
            LinkedList linkedList2 = (LinkedList)this.myLoadModulesInformations.clone();
            Iterator iterator = linkedList2.iterator();
            LoadModuleInformation loadModuleInformation = null;
            while (iterator.hasNext()) {
                loadModuleInformation = (LoadModuleInformation)iterator.next();
                if (loadModuleInformation.getLoaderType().equals(EMPTY_STRING)) {
                    if (!this.containsLoaderInformationWithLoaderType(loadModuleMoSU_Access.getLoaderType(null))) {
                        linkedList.add(loadModuleInformation);
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "filterEqualLoadModuleInformation(LoadModuleMoSU_Access theLoadModule)", "Removing LoadModuleInformation from the list since it's duplicated infomation\n\ttheLoadModuleInformation: " + loadModuleInformation);
                    continue;
                }
                linkedList.add(loadModuleInformation);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "filterEqualLoadModuleInformation(LoadModuleMoSU_Access theLoadModule)", "Replacing old list of LoadModuleInformations: " + this.myLoadModulesInformations + "\n\twith new: " + linkedList);
            }
            this.myLoadModulesInformations = linkedList;
        }
    }

    private boolean containsOnlyOneLoadModuleInformationForLdn(String string) {
        return this.myLoadModulesInformations.size() == 1;
    }

    private boolean containsLoaderInformationWithLoaderType(int n) throws UnexpectedLoaderTypeValueException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "containsLoaderInformationWithLoaderType(int aLoaderType)", "aLoaderType: " + n);
        }
        boolean bl = false;
        LoadModuleInformation loadModuleInformation = null;
        Iterator iterator = this.myLoadModulesInformations.iterator();
        while (iterator.hasNext()) {
            loadModuleInformation = (LoadModuleInformation)iterator.next();
            if (loadModuleInformation.getLoaderType().equals(EMPTY_STRING) || loadModuleInformation.getLoaderTypeAsInt() != n) continue;
            bl = true;
            break;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "containsLoaderInformationWithLoaderType(int aLoaderType)", "Returning - theLoaderTypeExists: " + bl);
        }
        return bl;
    }

    public String toString() {
        return "\n\tmyLoadModulesInformations: " + this.myLoadModulesInformations;
    }

    public String toNiceString() {
        String string = EMPTY_STRING;
        LoadModuleInformation loadModuleInformation = null;
        Iterator iterator = this.myLoadModulesInformations.iterator();
        while (iterator.hasNext()) {
            loadModuleInformation = (LoadModuleInformation)iterator.next();
            string = string + "\n\t\t\tLoadModuleInformation: " + loadModuleInformation.toNiceString();
        }
        return string;
    }
}

