/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.programhandler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInformationForConfiguredUpgradeablePIU;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.programhandler.ExistingProgram;

public class ExistingPrograms {
    private HashMap myTagAndExistingPrograms = new HashMap();
    private ProgramInformationForConfiguredUpgradeablePIU myProgramInformationForConfiguredUpgradeablePIU = null;

    public void setTagAndExistingPrograms(int n, ExistingProgram existingProgram) {
        this.myTagAndExistingPrograms.put(new Integer(n), existingProgram);
    }

    public ProgramInformationForConfiguredUpgradeablePIU getProgramInformationForConfiguredUpgradeablePIU() {
        return this.myProgramInformationForConfiguredUpgradeablePIU;
    }

    public void setProgramInformationForConfiguredUpgradeablePIU(ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU) {
        this.myProgramInformationForConfiguredUpgradeablePIU = programInformationForConfiguredUpgradeablePIU;
    }

    public Collection getExistingProgramInformations(int n) {
        ExistingProgram existingProgram = (ExistingProgram)this.myTagAndExistingPrograms.get(new Integer(n));
        if (existingProgram != null) {
            return existingProgram.getProgramInformations();
        }
        return new HashSet();
    }

    public ExistingProgram getExistingProgram(Integer n) {
        return (ExistingProgram)this.myTagAndExistingPrograms.get(n);
    }

    public Collection getAllExistingPrograms() {
        Set set = this.myTagAndExistingPrograms.keySet();
        Iterator iterator = set.iterator();
        LinkedList linkedList = new LinkedList();
        Integer n = null;
        Collection collection = null;
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            collection = this.getExistingProgramInformations(n);
            linkedList.addAll(collection);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getAllExistingPrograms()", "RETURNS - theAllExistingPrograms: " + linkedList);
        }
        return linkedList;
    }

    public Iterator getAllExistingProgramsIterator() {
        return this.getAllExistingPrograms().iterator();
    }

    public void removePresensOfPrograms(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removePresensOfPrograms(Collection aPrograms)", "aPrograms: " + collection);
        }
        Iterator iterator = collection.iterator();
        GenericProgramBase genericProgramBase = null;
        while (iterator.hasNext()) {
            genericProgramBase = (GenericProgramBase)iterator.next();
            this.removeProgramIfExists(genericProgramBase);
        }
    }

    public void removeProgramIfExists(GenericProgramBase genericProgramBase) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeProgramIfExists(GenericProgramBase aProgram)", "aProgram: " + genericProgramBase);
        }
        Set set = this.myTagAndExistingPrograms.keySet();
        Iterator iterator = set.iterator();
        Integer n = null;
        ExistingProgram existingProgram = null;
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            existingProgram = (ExistingProgram)this.myTagAndExistingPrograms.get(n);
            existingProgram.removeProgram(genericProgramBase);
        }
    }

    public String toString() {
        return "\n\tmyTagAndExistingPrograms: " + this.myTagAndExistingPrograms + "\n\tmyProgramInformationForConfiguredUpgradeablePIU: " + this.myProgramInformationForConfiguredUpgradeablePIU;
    }
}

