/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_FTP_TransferModeValue;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_LoaderNameValue;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.InstallSMInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.ChecksumFileWriterException;

public class ChecksumFileWriter {
    private HashMap myLoadModulesTable = new HashMap();
    private static final String SECURITY_MANAGEMENT_PRP = "SecurityManagement.prp";
    private static final String TRACE_01_PROP = "Trace_01.prop";
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);

    public ChecksumFileWriter() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ChecksumFileWriter ()");
        }
    }

    public HashMap getLoadModuleMappTable() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMappTable()");
        }
        return this.myLoadModulesTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeToChecksumFile(DocumentObjectProxyInterface documentObjectProxyInterface, Vector vector, ProductDataContainer productDataContainer, String string, boolean bl) throws ChecksumFileWriterException {
        String string2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath, boolean anIsHealthCheckRequested)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\tanIsHealthCheckRequested: " + bl);
        }
        File file = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                file = new File(this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath());
                if (!file.exists()) {
                    file.mkdirs();
                }
                outputStreamWriter = new FileWriter(string);
                this.writeChecksumInitialInformation((FileWriter)outputStreamWriter, productDataContainer);
                this.writeChecksumLoadModulesInformation((FileWriter)outputStreamWriter, documentObjectProxyInterface, vector, bl);
                this.writeChecksumEndInformation((FileWriter)outputStreamWriter);
                string2 = string;
                Object var10_13 = null;
                if (outputStreamWriter == null) return string2;
            }
            catch (ChecksumFileWriterException checksumFileWriterException) {
                if (!Trace.valid(this.getClass(), 22)) throw checksumFileWriterException;
                Trace.debug(this.getClass(), 22, "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath)", "ChecksumFileWriterException Exception caught when trying to write load modules to be installed into the load list file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taChecksumFilePath: " + string + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tChecksumFileWriterException: " + checksumFileWriterException.toString());
                throw checksumFileWriterException;
            }
            catch (IOException iOException) {
                if (!Trace.valid(this.getClass(), 22)) throw new ChecksumFileWriterException("IOException Exception caught when trying to write load modules to be checked for checksum into the checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tIO Exception: " + iOException.toString());
                Trace.debug(this.getClass(), 22, "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath)", "IOException Exception caught when trying to write load modules to be installed into the load list file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tIOException: " + iOException.toString());
                throw new ChecksumFileWriterException("IOException Exception caught when trying to write load modules to be checked for checksum into the checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tIO Exception: " + iOException.toString());
            }
            catch (Exception exception) {
                if (!Trace.valid(this.getClass(), 22)) throw new ChecksumFileWriterException("Exception caught when trying to write load modules to be checked for checksum into the checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tException Exception: " + exception.toString());
                Trace.debug(this.getClass(), 22, "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath)", "Exception Exception caught when trying to write load modules to be installed into the load list file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tException: " + exception.toString());
                throw new ChecksumFileWriterException("Exception caught when trying to write load modules to be checked for checksum into the checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tException Exception: " + exception.toString());
            }
            catch (Error error) {
                if (!Trace.valid(this.getClass(), 22)) throw new ChecksumFileWriterException("Error Exception caught when trying to write load modules to be checked for checksum into the checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tError: " + error.toString());
                Trace.debug(this.getClass(), 22, "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath)", "Error caught when trying to write load modules to be installed into the load list file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tError: " + error.toString());
                throw new ChecksumFileWriterException("Error Exception caught when trying to write load modules to be checked for checksum into the checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tError: " + error.toString());
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath)", "Exception caught when trying to close the handle to checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tException: " + exception.toString());
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            Trace.error(this.getClass(), "writeToChecksumFile(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeWritten, ProductDataContainer aProductDataOfUP, String aChecksumFilePath)", "Exception caught when trying to close the handle to checksum file.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\ttheTemporaryDirectoryOnTarget: " + file + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePath:" + string + "\n\ttheChecksumFileWriter: " + outputStreamWriter + "\n\tException: " + exception.toString());
            return string2;
        }
        outputStreamWriter.close();
        return string2;
    }

    private void writeChecksumEndInformation(FileWriter fileWriter) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeChecksumEndInformation(FileWriter aFileWriter)", "aFileWriter: " + fileWriter);
        }
        try {
            fileWriter.write("  </Contents>\n\n");
            fileWriter.write("</UpgradePackage>\n");
            fileWriter.close();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeChecksumEndInformation(FileWriter aFileWriter)", "Throwable caught when writing to the checksum file.", throwable);
            throw new ChecksumFileWriterException("Throwable caught when writing to the load list file.\n\tThrowable: " + throwable.getMessage());
        }
    }

    private void writeChecksumInitialInformation(FileWriter fileWriter, ProductDataContainer productDataContainer) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInitialInformation(FileWriter aFileWriter, ProductDataContainer aProductDataOfUP)", "aProductDataOfUP: " + productDataContainer);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)osaSwInstallProxyAccess)) {
                this.writeChecksumInitialInformationV2(fileWriter, productDataContainer);
            } else {
                this.writeChecksumInitialInformationV1(fileWriter, productDataContainer);
            }
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "writeChecksumInitialInformation(FileWriter aFileWriter, ProductDataContainer aProductDataOfUP)", "Failed to look up the version of Osa Sw Install function (aborting)");
            throw new ChecksumFileWriterException("Failed to look up the version of Osa Sw Install function (aborting).\n\taProductDataOfUP: " + productDataContainer + "\n\tSU_ConditionalException: " + (Object)((Object)sU_ConditionalException));
        }
    }

    private void writeChecksumInitialInformationV1(FileWriter fileWriter, ProductDataContainer productDataContainer) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInitialInformationV1(FileWriter aFileWriter, ProductDataContainer aProductDataOfUP)", "aProductDataOfUP: " + productDataContainer);
        }
        try {
            fileWriter.write("<xml version=\"1.0\">\n");
            fileWriter.write("<UpgradePackage>\n");
            fileWriter.write("  <Title title=" + productDataContainer.getName() + "/>\n");
            fileWriter.write("  <DocNo docno=" + productDataContainer.getNumber() + "/>\n");
            fileWriter.write("  <Revision revision=" + productDataContainer.getRevision() + "/>\n");
            fileWriter.write("  <Date date=" + productDataContainer.getDate() + "/>\n");
            fileWriter.write("  <Contents>\n");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeChecksumInitialInformationV1(FileWriter aFileWriter, ProductDataContainer aProductDataOfUP)", "Throwable caught when writing to the checksum file.\n\taProductDataOfUP: " + productDataContainer, throwable);
            throw new ChecksumFileWriterException("Throwable caught when writing to the checksum file.\n\taProductDataOfUP: " + productDataContainer + "\n\tException: " + throwable);
        }
    }

    private void writeChecksumInitialInformationV2(FileWriter fileWriter, ProductDataContainer productDataContainer) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeChecksumInitialInformationV2(FileWriter aFileWriter, ProductDataContainer aProductDataOfUP)", "aProductDataOfUP: " + productDataContainer);
        }
        try {
            fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fileWriter.write("<!DOCTYPE UpgradePackage>\n\n");
            fileWriter.write("<UpgradePackage>\n\n");
            fileWriter.write("  <Title title = \"" + productDataContainer.getName() + "\"/>\n");
            fileWriter.write("  <DocNo docno = \"" + productDataContainer.getNumber() + "\"/>\n");
            fileWriter.write("  <Revision revision = \"" + productDataContainer.getRevision() + "\"/>\n");
            fileWriter.write("  <Date date = \"" + productDataContainer.getDate() + "\"/>\n");
            fileWriter.write("  <Contents>\n");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeChecksumInitialInformationV2(FileWriter aFileWriter, ProductDataContainer aProductDataOfUP)", "Throwable caught when writing to the checksum file.\n\taProductDataOfUP: " + productDataContainer, throwable);
            throw new ChecksumFileWriterException("Throwable caught when writing to the checksum file.\n\taProductDataOfUP: " + productDataContainer + "\n\tException: " + throwable);
        }
    }

    private void writeChecksumLoadModuleInformation(FileWriter fileWriter, LoadModuleProxyInterface loadModuleProxyInterface, Vector vector, Collection collection, DocumentObjectProxyInterface documentObjectProxyInterface, ProductNumberAndRevision productNumberAndRevision, boolean bl, JvmMO_HandlerInterface jvmMO_HandlerInterface) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeChecksumLoadModuleInformation(FileWriter aChecksumFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision, boolean anIsHealthCheckRequested, JvmMO_HandlerInterface aJvmMoHandlerInterface)", "aChecksumFileWriter: " + fileWriter + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanInstallLM_Containers: " + vector + "\n\tanInstallSM_Interfaces: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tanIsHealthCheckRequested: " + bl);
        }
        try {
            this.writeInstallLM_ToLoadModuleInformation(fileWriter, vector, documentObjectProxyInterface, bl, productNumberAndRevision, loadModuleProxyInterface, jvmMO_HandlerInterface);
            this.writeInstallSMsToLoadModuleInformation(fileWriter, vector, collection, documentObjectProxyInterface, productNumberAndRevision, loadModuleProxyInterface, jvmMO_HandlerInterface);
        }
        catch (ChecksumFileWriterException checksumFileWriterException) {
            throw checksumFileWriterException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeChecksumLoadModuleInformation(FileWriter aChecksumFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, MoDataProxyInterface anMoDataProxyInterface, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision, boolean anIsHealthCheckRequested)", "Throwable caught when writing to the checksum file.aChecksumFileWriter: " + fileWriter + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanInstallLM_Containers: " + vector + "\n\tanInstallSM_Interfaces: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tanIsHealthCheckRequested: " + bl + "\n\tThrowable: " + throwable.toString());
            throw new ChecksumFileWriterException("Throwable caught when writing to the checksum file.\n\taChecksumFileWriter: " + fileWriter + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanInstallLM_Containers: " + vector + "\n\tanInstallSM_Interfaces: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tanIsHealthCheckRequested: " + bl + "\n\tThrowable: " + throwable.toString());
        }
    }

    private void writeInstallLM_ToLoadModuleInformation(FileWriter fileWriter, Vector vector, DocumentObjectProxyInterface documentObjectProxyInterface, boolean bl, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, JvmMO_HandlerInterface jvmMO_HandlerInterface) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInstallLM_ToLoadModuleInformation(FileWriter aChecksumFileWriter, Vector anInstallLM_Containers, DocumentObjectProxyInterface aDocumentObjectProxyInterface, boolean anIsHealthCheckRequested, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, JvmMO_HandlerInterface aJvmMoHandlerInterface)", "aChecksumFileWriter: " + fileWriter + "\n\tanInstallLM_Containers: " + vector + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanIsHealthCheckRequested: " + bl + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        InstallLM_Container installLM_Container = null;
        String string = null;
        String string2 = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            installLM_Container = (InstallLM_Container)iterator.next();
            if (!installLM_Container.getDirectory().equalsIgnoreCase("no")) continue;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "writeInstallLM_ToLoadModuleInformation(FileWriter aChecksumFileWriter, Vector anInstallLM_Containers, DocumentObjectProxyInterface aDocumentObjectProxyInterface, boolean anIsHealthCheckRequested, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, JvmMO_HandlerInterface aJvmMoHandlerInterface)", "A load module file has been identified for a load module.");
            }
            string = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
            boolean bl2 = true;
            if (bl) {
                if (string.indexOf(SECURITY_MANAGEMENT_PRP) != -1) {
                    bl2 = false;
                } else if (string.indexOf(TRACE_01_PROP) != -1) {
                    bl2 = false;
                }
            }
            if (bl2) {
                if ((loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.JVM) || loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.Other)) && string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) {
                    string = jvmMO_HandlerInterface.selectDestinationAbsolutePathForJVMLoadModule(string);
                }
                string2 = StringHandler.removeWhiteSpaces(loadModuleProxyInterface.getProductNumber() + "__" + loadModuleProxyInterface.getProductRevision());
                this.writeLoadModuleInformation(fileWriter, string, installLM_Container.getFileSize(), string2, installLM_Container.getChecksum());
                continue;
            }
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "writeInstallLM_ToLoadModuleInformation(FileWriter aChecksumFileWriter, Vector anInstallLM_Containers, DocumentObjectProxyInterface aDocumentObjectProxyInterface, boolean anIsHealthCheckRequested, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, JvmMO_HandlerInterface aJvmMoHandlerInterface)", "Due to healt check the file shall not be checksum controlled:" + string);
        }
        if (string2 != null) {
            this.myLoadModulesTable.put(string2, productNumberAndRevision);
        }
    }

    private void writeInstallSMsToLoadModuleInformation(FileWriter fileWriter, Vector vector, Collection collection, DocumentObjectProxyInterface documentObjectProxyInterface, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, JvmMO_HandlerInterface jvmMO_HandlerInterface) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInstallSMsToLoadModuleInformation(FileWriter aChecksumFileWriter, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, JvmMO_HandlerInterface aJvmMoHandlerInterface)", "aChecksumFileWriter: " + fileWriter + "\n\tanInstallLM_Containers: " + vector + "\n\tanInstallSM_Interfaces: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        InstallSMInterface installSMInterface = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            installSMInterface = (InstallSMInterface)iterator.next();
            InstallLM_Container installLM_Container = this.selectInstallLM_Container(installSMInterface, vector);
            this.writeInstallSM_ToLM_Information(fileWriter, installLM_Container, installSMInterface, documentObjectProxyInterface, productNumberAndRevision, loadModuleProxyInterface, jvmMO_HandlerInterface);
        }
    }

    private InstallLM_Container selectInstallLM_Container(InstallSMInterface installSMInterface, Collection collection) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectInstallLM_Container(InstallSMInterface anInstallSM_Interface, Collection anInstallLM_Containers)", "anInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Containers: " + collection);
        }
        InstallLM_Container installLM_Container = null;
        if (collection.size() == 1) {
            installLM_Container = (InstallLM_Container)collection.iterator().next();
            return installLM_Container;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            installLM_Container = (InstallLM_Container)iterator.next();
            if (installLM_Container.getDestFilePathName() == null || !installLM_Container.getDestFilePathName().equals(installSMInterface.getDestFilePathNameRef())) continue;
            return installLM_Container;
        }
        Trace.error(this.getClass(), "selectInstallLM_Container(InstallSMInterface anInstallSM_Interface, Collection anInstallLM_Containers)", "Couldn't find any InstallLM_Container that matches the InstallSM_Interface.\n\tanInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Containers: " + collection);
        throw new ChecksumFileWriterException("Couldn't find any InstallLM_Container that matches the InstallSM_Interface.\n\tanInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Containers: " + collection);
    }

    private void writeInstallSM_ToLM_Information(FileWriter fileWriter, InstallLM_Container installLM_Container, InstallSMInterface installSMInterface, DocumentObjectProxyInterface documentObjectProxyInterface, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, JvmMO_HandlerInterface jvmMO_HandlerInterface) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInstallSM_ToLM_Information(FileWriter aChecksumFileWriter, InstallLM_Container anInstallLM_Container, InstallSM_Interface anInstallSM_Interface, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, JvmMO_HandlerInterface aJvmMoHandlerInterface)", "aChecksumFileWriter: " + fileWriter + "\n\tanInstallLM_Containers: " + installLM_Container + "\n\tanInstallSM_Interfaces: " + installSMInterface + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        String string = this.getDestFilePathForSM_File(installSMInterface, installLM_Container, productNumberAndRevision, documentObjectProxyInterface, loadModuleProxyInterface);
        if ((loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.JVM) || loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.Other)) && string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) {
            string = jvmMO_HandlerInterface.selectDestinationAbsolutePathForJVMLoadModule(string);
        }
        this.writeLoadModuleInformation(fileWriter, string, installSMInterface.getFileSize(), loadModuleProxyInterface.getProductNumber() + "__" + loadModuleProxyInterface.getProductRevision(), installSMInterface.getChecksum());
    }

    private String getDestFilePathForSM_File(InstallSMInterface installSMInterface, InstallLM_Container installLM_Container, ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface, LoadModuleProxyInterface loadModuleProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDestFilePathForSM_File(InstallSM_Interface anInstallSM_Interface, InstallLM_Container anInstallLM_Container, ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxyInterface, LoadModuleProxyInterface aLoadModuleProxyInterface)", "anInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Container: " + installLM_Container + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        String string = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
        return string + "." + installSMInterface.getExtension();
    }

    private void writeLoadModuleInformation(FileWriter fileWriter, String string, int n, String string2, String string3) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadModuleInformation(FileWriter aChecksumFileWriter, String aDestinationFilePath, int aFileSize, String anLM_ID, String aChecksum)", "aChecksumFileWriter: " + fileWriter + "\n\taDestinationFilePath: " + string + "\n\taFileSize: " + n + "\n\tanLM_ID: " + string2 + "\n\taChecksum: " + string3);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)osaSwInstallProxyAccess)) {
                this.writeLoadModuleInformationV2(fileWriter, string, n, string2, string3);
            } else {
                this.writeLoadModuleInformationV1(fileWriter, string, n, string2, string3);
            }
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "writeLoadModuleInformation(FileWriter aChecksumFileWriter, String aDestinationFilePath, int aFileSize, String anLM_ID, String aChecksum)", "Failed to look up the version of Osa Sw Install function (aborting)");
            throw new ChecksumFileWriterException("Failed to look up the version of Osa Sw Install function (aborting).\n\tSU_ConditionalException: " + (Object)((Object)sU_ConditionalException));
        }
    }

    private void writeLoadModuleInformationV1(FileWriter fileWriter, String string, int n, String string2, String string3) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadModuleInformationV1(FileWriter aChecksumFileWriter, String aDestinationFilePath, int aFileSize, String aLM_ID, String aChecksum)", "aChecksumFileWriter: " + fileWriter + "\n\taDestinationFilePath: " + string + "\n\taFileSize: " + n + "\n\tanLM_ID: " + string2 + "\n\taChecksum: " + string3);
        }
        String string4 = "";
        try {
            fileWriter.write("    <LoadModule>\n");
            fileWriter.write("      <TransferMode transfermode=" + InstallLM_FTP_TransferModeValue.getDefaultValue().toUpperCase() + "/>\n");
            fileWriter.write("      <SFile sfile=" + string4 + "/>\n");
            fileWriter.write("      <DFile dfile=" + string + "/>\n");
            fileWriter.write("      <FileSize size=" + n + "/>\n");
            fileWriter.write("      <LMid lmid=" + string2 + "/>\n");
            fileWriter.write("      <Checksum value=" + string3 + "/>\n");
            if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
                fileWriter.write("      <Replicate replicate=yes/>\n");
            }
            fileWriter.write("    </LoadModule>\n");
        }
        catch (IOException iOException) {
            Trace.error(this.getClass(), "writeLoadModuleInformationV1(FileWriter aChecksumFileWriter, String aDestinationFilePath, int aFileSize, String anLM_ID, String aChecksum)", "aLoadListFileWriter: " + fileWriter + "\n\taDestinationFilePath: " + string + "\n\taFileSize: " + n + "\n\tanLM_ID: " + string2 + "\n\taChecksum: " + string3, iOException);
            throw new ChecksumFileWriterException(iOException.toString());
        }
    }

    private void writeLoadModuleInformationV2(FileWriter fileWriter, String string, int n, String string2, String string3) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadModuleInformationV2(FileWriter aChecksumFileWriter, String aDestinationFilePath, int aFileSize, String anLM_ID, String aChecksum)", "aChecksumFileWriter: " + fileWriter + "\n\taDestinationFilePath: " + string + "\n\taFileSize: " + n + "\n\tanLM_ID: " + string2 + "\n\taChecksum: " + string3);
        }
        try {
            if (string3 != null && !string3.equals("null")) {
                fileWriter.write("    <Module>\n");
                fileWriter.write("      <DFile dfile = \"" + string + "\"/>\n");
                fileWriter.write("      <LMid lmid = \"" + string2 + "\"/>\n");
                fileWriter.write("      <Checksum value = \"" + string3 + "\"/>\n");
                if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath()) || string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath()) || string.startsWith(this.mySystemUpgradeConstantsInterface.getCertCrlInstallLmRootPath())) {
                    fileWriter.write("      <Replicate replicate = \"yes\"/>\n");
                }
                fileWriter.write("    </Module>\n");
            }
        }
        catch (IOException iOException) {
            Trace.error(this.getClass(), "writeLoadModuleInformationV1(FileWriter aChecksumFileWriter, String aDestinationFilePath, int aFileSize, String anLM_ID, String aChecksum)", "aChecksumFileWriter: " + fileWriter + "\n\taDestinationFilePath: " + string + "\n\taFileSize: " + n + "\n\tanLM_ID: " + string2 + "\n\taChecksum: " + string3, iOException);
            throw new ChecksumFileWriterException(iOException.toString());
        }
    }

    private void writeChecksumLoadModulesInformation(FileWriter fileWriter, DocumentObjectProxyInterface documentObjectProxyInterface, Vector vector, boolean bl) throws ChecksumFileWriterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeChecksumLoadModulesInformation(FileWriter aChecksumFileWriter, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aLoadModulesToBeWritten, boolean anIsHealthCheckRequested)", "aChecksumFileWriter: " + fileWriter + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\tanIsHealthCheckRequested: " + bl);
        }
        try {
            Enumeration enumeration = vector.elements();
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            while (enumeration.hasMoreElements()) {
                ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)enumeration.nextElement();
                loadModuleProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface().getLoadModuleProxyInterface(productNumberAndRevision);
                this.writeChecksumLoadModuleInformation(fileWriter, loadModuleProxyInterface, loadModuleProxyInterface.getInstallDatas(), loadModuleProxyInterface.getInstallSMs(), documentObjectProxyInterface, productNumberAndRevision, bl, jvmMO_HandlerInterface);
            }
        }
        catch (ChecksumFileWriterException checksumFileWriterException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "writeChecksumLoadModulesInformation(FileWriter aChecksumFileWriter, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aLoadModulesToBeWritten, boolean anIsHealthCheckRequested)", "ChecksumFileWriterException caught when writing to the load module checksum to be checksum controlled.aChecksumFileWriter: " + fileWriter + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\tChecksumFileWriterException: " + checksumFileWriterException.toString());
            }
            throw checksumFileWriterException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "writeChecksumLoadModulesInformation(FileWriter aChecksumFileWriter, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aLoadModulesToBeWritten)", "Exception caught when writing to the load module checksum to be checksum controlled.aChecksumFileWriter: " + fileWriter + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector, exception);
            throw new ChecksumFileWriterException("Exception caught when writing to the load module checksum to be checksum controlled.\n\taChecksumFileWriter: " + fileWriter + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\tException: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "writeChecksumLoadModulesInformation(FileWriter aChecksumFileWriter, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aLoadModulesToBeWritten)", "Error caught when writing to the load module checksum to be checksum controlled.aChecksumFileWriter: " + fileWriter + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\tError: " + error.toString(), error);
            throw new ChecksumFileWriterException("Error caught when writing to the load module checksum to be checksum controlled.\n\taChecksumFileWriter: " + fileWriter + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeWritten: " + vector + "\n\tError: " + error.toString());
        }
    }
}

