/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SequenceInformation;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.FindPiu;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootPiuUpgrade;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequenceProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.verify.CoreMPsFTC_StatusInformation;
import se.ericsson.cello.upgradepackage.verify.ProgramConsistencyVerifier;
import se.ericsson.cello.upgradepackage.verify.UPIUsConnectionInformation;
import se.ericsson.cello.upgradepackage.verify.VerifyCoreMPsException;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;

public class CoreMPsFTC_StatusHandler {
    public CoreMPsFTC_StatusInformation verifyFTC_State(VerifyRequestEvent verifyRequestEvent, Collection collection) throws VerifyCoreMPsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyFTC_State(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taSequenceInformations: " + collection);
        }
        ManagedObject[] managedObjectArray = null;
        int[] nArray = null;
        try {
            ManagedElementMoSU_Access managedElementMoSU_Access = this.getManagedElement();
            managedObjectArray = managedElementMoSU_Access.getFtcsMos(null);
            nArray = managedElementMoSU_Access.getFtcStates(null);
            if (managedObjectArray.length == 1) {
                if (this.isPiuToBeRestartedInSequences(verifyRequestEvent, collection, (GenericUpgradeablePlugInUnit)managedObjectArray[0])) {
                    return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 3);
                }
                return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 0);
            }
            int n = this.getFTC_StateIndexToBeChecked(nArray);
            if (n == -1) {
                return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 0);
            }
            if (nArray[n] == 1 || nArray[n] == 5) {
                return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 2);
            }
            if (nArray[n] == 2) {
                Trace.warning(this.getClass(), "verifyFTC_State(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations)", "Unexpected ftc state 'not configureded' for passive core MP (assuming upgrade is possible).FTC_States: " + SuLib.toString(this.translateFTC_States(nArray)) + "thePIU_MOs: " + SuLib.toString(managedObjectArray));
                return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 0);
            }
            if (nArray[n] == 6) {
                return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 0);
            }
            if (nArray[n] == 4) {
                if (this.isPiuToBeRestartedInSequences(verifyRequestEvent, collection, (GenericUpgradeablePlugInUnit)managedObjectArray[0])) {
                    return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 1);
                }
                return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 0);
            }
            Trace.warning(this.getClass(), "verifyFTC_State(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations)", "Unexpected combination of FTC synch data (assuming upgrade is possible).FTC_States: " + SuLib.toString(this.translateFTC_States(nArray)) + "thePIU_MOs: " + SuLib.toString(managedObjectArray));
            return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), 0);
        }
        catch (VerifyCoreMPsException verifyCoreMPsException) {
            return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), -1, verifyCoreMPsException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyCoreMPs(VerifyRequestEvent aVerifyRequestEvent)", "A Throwable was caught at verification of Core MPs.", throwable);
            return new CoreMPsFTC_StatusInformation(managedObjectArray, this.translateFTC_States(nArray), -1, throwable.toString());
        }
    }

    private int getFTC_StateIndexToBeChecked(int[] nArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFTC_StateIndexToBeChecked ( int[] aFTC_States )", "aFTC_States: " + SuLib.toString(nArray));
        }
        if (nArray.length == 2) {
            if (nArray[0] == 3) {
                return 1;
            }
            if (nArray[1] == 3) {
                return 0;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getFTC_StateIndexToBeChecked ( int[] aFTC_States )", "aFTC_States: " + SuLib.toString(this.translateFTC_States(nArray)));
            }
            return -1;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getFTC_StateIndexToBeChecked ( int[] aFTC_States )", "aFTC_States.length: " + nArray.length + "aFTC_States: " + SuLib.toString(this.translateFTC_States(nArray)));
        }
        return -1;
    }

    private String[] translateFTC_States(int[] nArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "translateFTC_States (int[] aFTC_States )", "aFTC_States: " + SuLib.toString(nArray));
        }
        if (nArray != null) {
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = this.getManagedElement().getState(nArray[i]);
            }
            return stringArray;
        }
        return new String[0];
    }

    private ManagedElementMoSU_Access getManagedElement() {
        return (ManagedElementMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementMoSU_Access.class);
    }

    private boolean isPiuToBeRestartedInSequences(VerifyRequestEvent verifyRequestEvent, Collection collection, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws VerifyCoreMPsException {
        OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuToBeRestartedInSequences(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taSequenceInformations: " + collection + "\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        boolean bl = false;
        String[] stringArray = new String[]{"Repertoire", "ExplicitReplacement", "UpgradeSequence"};
        try {
            optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision, verifyRequestEvent.upgradePackageUCF_Path, stringArray, false);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isPiuToBeRestartedInSequences(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "UpgradeControlFileParserException caught when parsing UCF to find out if single FTC MP will be restarted at upgrade.", throwable);
            throw new VerifyCoreMPsException("Class: " + this.getClass().getName() + "\n\tMethod: isPiuToBeRestartedInSequences(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)" + "\n\tUpgradeControlFileParserException caught when parsing UCF to find out if single FTC MP will be restarted at upgrade." + "\n\tException info: " + throwable);
        }
        SequenceInformation sequenceInformation = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            sequenceInformation = (SequenceInformation)iterator.next();
            if (!this.isPiuToBeRestartedInSequence(verifyRequestEvent, optimizedDocumentObjectProxyInterface, sequenceInformation, genericUpgradeablePlugInUnit)) continue;
            bl = true;
            break;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuToBeRestartedInSequences(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Returning - isPiuToBeRestartedInSequences: " + bl);
        }
        return bl;
    }

    private boolean isPiuToBeRestartedInSequence(VerifyRequestEvent verifyRequestEvent, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, SequenceInformation sequenceInformation, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws VerifyCoreMPsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuToBeRestartedInSequence(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, SequenceInformation aSequenceInformation, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taSequenceInformation: " + sequenceInformation + "\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        boolean bl = false;
        UpgradeSequenceProxyInterface upgradeSequenceProxyInterface = optimizedDocumentObjectProxyInterface.getUpgradeSequencesProxyInterface().getUpgradeSequenceProxyInterface(sequenceInformation.label);
        if (upgradeSequenceProxyInterface == null) {
            Trace.info(this.getClass(), "isPiuToBeRestartedInSequence(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, SequenceInformation aSequenceInformation, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Could not find a sequence with label: " + sequenceInformation.label + " in UCF to find out if single FTC MP will be restarted at upgrade." + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taSequenceInformation: " + sequenceInformation);
            throw new VerifyCoreMPsException("Class: " + this.getClass().getName() + "\n\tMethod: isPiuToBeRestartedInSequence(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, SequenceInformation aSequenceInformation, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)" + "\n\tCould not find a sequence with label: " + sequenceInformation.label + " in UCF to find out if single FTC MP will be restarted at upgrade." + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taSequenceInformation: " + sequenceInformation);
        }
        RebootPiuUpgrade rebootPiuUpgrade = null;
        Iterator iterator = upgradeSequenceProxyInterface.getRebootPiuUpgradeOps().iterator();
        while (iterator.hasNext()) {
            rebootPiuUpgrade = (RebootPiuUpgrade)iterator.next();
            if (!this.isPiuToBeRestartedInRebootPiuUpgrade(verifyRequestEvent, optimizedDocumentObjectProxyInterface, rebootPiuUpgrade, genericUpgradeablePlugInUnit, sequenceInformation.currentCase)) continue;
            bl = true;
            break;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuToBeRestartedInSequence(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, SequenceInformation aSequenceInformation, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Returning - isPiuToBeRestartedInSequence: " + bl);
        }
        return bl;
    }

    private boolean isPiuToBeRestartedInRebootPiuUpgrade(VerifyRequestEvent verifyRequestEvent, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, RebootPiuUpgrade rebootPiuUpgrade, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuToBeRestartedInRebootPiuUpgrade(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, RebootPiuUpgrade aRebootPiuUpgrade, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taRebootPiuUpgrade: " + rebootPiuUpgrade + "\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCurrentCase: " + string);
        }
        boolean bl = false;
        FindPiu findPiu = null;
        Iterator iterator = rebootPiuUpgrade.getFindPiu().iterator();
        while (iterator.hasNext()) {
            findPiu = (FindPiu)iterator.next();
            if (!this.isPiuIncludedInFindPiu(verifyRequestEvent, optimizedDocumentObjectProxyInterface, findPiu, genericUpgradeablePlugInUnit, string)) continue;
            bl = true;
            break;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuToBeRestartedInRebootPiuUpgrade(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, RebootPiuUpgrade aRebootPiuUpgrade, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "Returning - theIsPiuToBeRestartedInRebootPiuUpgrade: " + bl);
        }
        return bl;
    }

    private boolean isPiuIncludedInFindPiu(VerifyRequestEvent verifyRequestEvent, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, FindPiu findPiu, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taFindPiu: " + findPiu + "\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCurrentCase: " + string);
        }
        boolean bl = false;
        if (findPiu.getMatchRepertoireName() != null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "matchRepertoireName found: " + findPiu.getMatchRepertoireName());
            }
            ProgramConsistencyVerifier programConsistencyVerifier = new ProgramConsistencyVerifier();
            try {
                UPIUsConnectionInformation uPIUsConnectionInformation = programConsistencyVerifier.collectConnectedRepertoireNames(genericUpgradeablePlugInUnit, verifyRequestEvent, string, optimizedDocumentObjectProxyInterface, new HashSet());
                if (uPIUsConnectionInformation.containsRepertoireName(findPiu.getMatchRepertoireName())) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "The single FTC MP will be connected to the repertoire after an upgrade.");
                    }
                    bl = true;
                }
            }
            catch (VerifyRequestException verifyRequestException) {
                Trace.error(this.getClass(), "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "Exception caught when checking if single FTC MP is refered by matchRepertoireName in FindPiu, i.e. might be included in the upgrade.\n\tAssuming that it is not.\n\taCurrentCase: " + string + "\n\taFindPiu: " + findPiu + "\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit, (Throwable)((Object)verifyRequestException));
            }
        } else if (findPiu.getUpgradeGroupTypeName() != null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "upgradeGroupTypeName found: " + findPiu.getUpgradeGroupTypeName());
            }
            try {
                if (findPiu.getUpgradeGroupTypeName().equals(findPiu.getUpgradeGroupTypeName())) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "The single FTC MP has matching upgradeGroupTypeName.");
                    }
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "Throwable caught when checking if single FTC MP is refered by upgradeGroupTypeName in FindPiu, i.e. might be included in the upgrade.\n\tAssuming that it is not.\n\taCurrentCase: " + string + "\n\taFindPiu: " + findPiu + "\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit, throwable);
            }
        } else {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "Neither matchRepertoireName or upgradeGroupTypeName is specified, i.e. all PIUs in the node will be affected.");
            }
            bl = true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuIncludedInFindPiu(VerifyRequestEvent aVerifyRequestEvent, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, FindPiu aFindPiu, GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCurrentCase)", "Returning - theIsPiuIncludedInFindPiu: " + bl);
        }
        return bl;
    }
}

