/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgramsContainer;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;

public class VerifyProgramHandler {
    public ProgramsContainer getReportingPgms(int[] nArray) throws VerifyRequestException {
        String string = "getReportingPgms(int[] types)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "types" + SuLib.toString(nArray));
        }
        try {
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            GenericUpgradeablePlugInUnit[] genericUpgradeablePlugInUnitArray = upgradeablePIU_HandlerInterface.getAllConfiguredCelloPius();
            ProgramsContainer programsContainer = this.getReportingPgms(nArray, genericUpgradeablePlugInUnitArray);
            return programsContainer;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getReportingPgms(int[] types)", "Throwable caught", throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private ProgramsContainer getReportingPgms(int[] nArray, GenericUpgradeablePlugInUnit[] genericUpgradeablePlugInUnitArray) throws VerifyRequestException {
        String string = "getReportingPgms(int[] types, GenericUpgradeablePlugInUnit[] piulist)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "types: " + SuLib.toString(nArray) + "\n\tpiulist: " + this.piusToString(genericUpgradeablePlugInUnitArray));
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                bl = true;
                continue;
            }
            if (nArray[i] == 1) {
                bl2 = true;
                continue;
            }
            if (nArray[i] == 2) {
                bl3 = true;
                continue;
            }
            if (nArray[i] != 3) continue;
            bl4 = true;
        }
        ProgramsContainer programsContainer = new ProgramsContainer();
        for (int i = 0; i < genericUpgradeablePlugInUnitArray.length; ++i) {
            Iterator iterator = this.getExistingConfiguredPgms(genericUpgradeablePlugInUnitArray[i]);
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof GenericProgramBase)) continue;
                try {
                    if (((GenericProgramBase)e).getStartState(null) != 0 || !bl2 && !bl) continue;
                    programsContainer.addProgram("disabled", (GenericProgramBase)e);
                }
                catch (MoRemovedException moRemovedException) {
                    if (bl3 || bl) {
                        programsContainer.addProgram("MoRemovedException", (GenericProgramBase)e);
                        continue;
                    }
                    if (!bl4) continue;
                    programsContainer.addProgram(((Object)((Object)moRemovedException)).getClass().getName(), (GenericProgramBase)e);
                }
                catch (Exception exception) {
                    if (!bl4 && !bl) continue;
                    programsContainer.addProgram(exception.getClass().getName(), (GenericProgramBase)e);
                }
            }
        }
        return programsContainer;
    }

    private Iterator getExistingConfiguredPgms(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws VerifyRequestException {
        String string = "getExistingConfiguredPrograms(ManagedObject anUpgradeablePlugInUnit)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        try {
            HashSet<GenericProgramBase> hashSet = new HashSet<GenericProgramBase>();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            if (genericUpgradeablePlugInUnit == null) {
                throw new ProgramMO_HandlerException("Method " + string + " expects that parameter anUpgradeablePlugInUnit contains an instance of GenericUpgradeablePlugInUnit but the parameter is null");
            }
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit2 = genericUpgradeablePlugInUnit;
            piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit2.getPiuType(null);
            if (piuTypeMoSU_Access == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "No PiuType for piu " + genericUpgradeablePlugInUnit2);
                }
            } else {
                Struct[] structArray;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "The PIU's Piutype: " + piuTypeMoSU_Access.toString());
                }
                if ((structArray = piuTypeMoSU_Access.getProgramConfiguration(null)) == null) {
                    Trace.error(this.getClass(), string, "For PlugInUnit: " + genericUpgradeablePlugInUnit2 + ", No Program Configuration for piuType: " + piuTypeMoSU_Access + ".");
                } else {
                    for (int i = 0; i < structArray.length; ++i) {
                        String string2 = (String)structArray[i].getValue("tag");
                        String string3 = (String)structArray[i].getValue("programMoTypeName");
                        String string4 = (String)structArray[i].getValue("subParentLDN");
                        ManagedObject managedObject = this.getProgramParentMO(string4, genericUpgradeablePlugInUnit2, "existing programs are collected (verification).");
                        if (managedObject == null) {
                            if (!Trace.valid(this.getClass(), 22)) continue;
                            Trace.debug(this.getClass(), 22, string, "theProgramParentMO == null  subParentLDN:" + string4 + " thePlugInUnit:" + genericUpgradeablePlugInUnit2);
                            continue;
                        }
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, string, "Removing Disabled Programs, Tag " + string2 + " Parent " + managedObject.toString() + " mo Type" + string3);
                        }
                        MoIterator moIterator = MoRepository.instance().select(managedObject, 1, (MoFilter)new MoTypeFilter(string3));
                        GenericProgramBase genericProgramBase = null;
                        if (moIterator == null) continue;
                        while (moIterator.hasMoreElements()) {
                            genericProgramBase = (GenericProgramBase)moIterator.nextMo();
                            hashSet.add(genericProgramBase);
                        }
                    }
                }
            }
            return hashSet.iterator();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Error when trying to get existing Programs in configuration (ignored)", throwable);
            return null;
        }
    }

    private ManagedObject getProgramParentMO(String string, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProgramParentMO(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, String anFunctionalTaskDescription)", "aProgramParentSubLDN: " + string + "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanFunctionalTaskDescription: " + string2);
        }
        String string3 = null;
        string3 = "".equalsIgnoreCase(string) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string;
        ManagedObject managedObject = MoRepository.instance().lookup(string3);
        if (managedObject == null) {
            Trace.warning(this.getClass(), "getProgramParentMO(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, String anFunctionalTaskDescription)", "Program Parent defined in PiuType MO not found under PIU, theProgramParentAbsoluteLDN: " + string3 + "\n\tDetected when " + string2 + "\n\taProgramParentSubLDN: " + string + "\n\ttheProgramParentAbsoluteLDN: " + string3 + "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        return managedObject;
    }

    private String piusToString(GenericUpgradeablePlugInUnit[] genericUpgradeablePlugInUnitArray) {
        String string = "[ ";
        try {
            if (genericUpgradeablePlugInUnitArray != null) {
                for (int i = 0; i < genericUpgradeablePlugInUnitArray.length; ++i) {
                    string = i < genericUpgradeablePlugInUnitArray.length - 1 ? string + genericUpgradeablePlugInUnitArray[i].getLocalDistinguishedName() + ", " : string + genericUpgradeablePlugInUnitArray[i].getLocalDistinguishedName() + " ]";
                }
                if (genericUpgradeablePlugInUnitArray.length == 0) {
                    string = string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "piusToString(GenericUpgradeablePlugInUnit[] piulist)", "Exception caught when trying to translate the array of GenericUpgradeablePlugInUnits to a string.\n\tpiulistString: " + string + "\n\tException data: " + exception.toString(), exception);
            return string;
        }
        catch (Error error) {
            Trace.error(this.getClass(), "piusToString(GenericUpgradeablePlugInUnit[] piulist)", "Error caught when trying to translate the array ofGenericUpgradeablePlugInUnits to a string.\n\tpiulistString: " + string + "\n\tError data: " + error.toString(), error);
            return string;
        }
    }
}

