/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import se.ericsson.cello.equipment.CbuMo;
import se.ericsson.cello.equipment.CppBoardMarker;
import se.ericsson.cello.equipment.ExchangeTerminalMarker;
import se.ericsson.cello.equipment.GeneralProcessorUnitMo;
import se.ericsson.cello.equipment.TimingUnitMarker;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Removable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class CbuMoImpl
extends CelloMao
implements CbuMo,
CppBoardMarker {
    private MoData data;
    private static final int MO_DATA_REVISION_44 = 4400;
    private static final int MO_DATA_REVISION_LATEST = 4400;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Cbu", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"PlugInUnit");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Cbu", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Cbu");
        return new CbuMoImpl(managedObject, string, string2, coordinator);
    }

    private CbuMoImpl(ManagedObject managedObject, String string, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Cbu", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.setRevision(4400);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public CbuMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4400);
        moDataRecoveryHelper.assertAttribute("userLabel");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deleteChildren(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (managedObject instanceof Removable) {
                    ((Removable)managedObject).doDelete(coordinator);
                }
                MessageLog.trace((int)4, this.getClass(), (String)("---CMA---Deleted child under CBU. " + managedObject.getType()));
            }
        }
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Cbu", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (managedObject.getType().equals("GeneralProcessorUnit")) {
                    n = ((GeneralProcessorUnitMo)managedObject).getOperationalState(coordinator);
                    MessageLog.trace((int)4, this.getClass(), (String)("---CMA---Getting opState from GPU under CBU. " + n));
                    continue;
                }
                if (managedObject instanceof ExchangeTerminalMarker) {
                    n3 = (Integer)managedObject.getAttribute("operationalState", coordinator);
                    MessageLog.trace((int)4, this.getClass(), (String)("---CMA---Getting opState from ExchangeTerminalMo under CBU. " + n3));
                    continue;
                }
                if (!(managedObject instanceof TimingUnitMarker)) continue;
                n2 = (Integer)managedObject.getAttribute("operationalState", coordinator);
                MessageLog.trace((int)4, this.getClass(), (String)("---CMA---Getting opState from TU under CBU. " + n2));
            }
        }
        if (n == 1 && n2 == 1 && n3 == 1) {
            return 1;
        }
        return 0;
    }

    public int getAvailabilityStatusEt(Coordinator coordinator) throws MoAccessException {
        int n = 0;
        boolean bl = false;
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements() && !bl) {
                managedObject = moIterator.nextMo();
                if (!(managedObject instanceof ExchangeTerminalMarker)) continue;
                n = (Integer)managedObject.getAttribute("availabilityStatus", coordinator);
                bl = true;
            }
        }
        return n;
    }

    public int getAvailabilityStatusTu(Coordinator coordinator) throws MoAccessException {
        int n = 0;
        boolean bl = false;
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements() && !bl) {
            managedObject = moIterator.nextMo();
            if (!(managedObject instanceof TimingUnitMarker)) continue;
            n = (Integer)managedObject.getAttribute("availabilityStatus", coordinator);
            bl = true;
        }
        return n;
    }

    public String getType() {
        return "Cbu";
    }
}

