/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.example.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.emas.example.config.ConfigParametersDialogView;
import se.ericsson.cello.emas.example.config.EmasDialogController;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class ConfigParametersDialogController
extends EmasDialogController
implements ActionListener {
    private ConfigParametersDialogView view;
    public String cpdName = null;
    public String cpdValue = null;

    protected void init() {
        this.view = (ConfigParametersDialogView)this.getView();
        this.view.addButton.setEnabled(false);
        this.setActionListeners();
        this.setButtonListeners();
    }

    protected void afterVisible() {
    }

    private void setActionListeners() {
        this.view.configParamName.setActionListener((ActionListener)this, "ENTERED_NAME");
        this.view.configParamValue.setActionListener((ActionListener)this, "ENTERED_VALUE");
    }

    private void setButtonListeners() {
        this.view.addButton.setActionListener((ActionListener)this, "ADD_PRESSED");
        this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL_PRESSED");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("ADD_PRESSED")) {
            Log.trace((String)"Dialog-Add button pressed");
            this.cpdName = this.view.configParamName.getValue() != null ? this.view.configParamName.getValue() : "";
            this.cpdValue = this.view.configParamValue.getValue() != null ? this.view.configParamValue.getValue() : "";
            this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
        } else if (event.getActionCommand().equals("CANCEL_PRESSED")) {
            Log.trace((String)"Dialog-Cancel button pressed");
            this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
        } else if (event.getActionCommand().equals("ENTERED_NAME")) {
            boolean nameCheck = this.validateNameValue();
            this.view.addButton.setEnabled(nameCheck);
        } else if (event.getActionCommand().equals("ENTERED_VALUE")) {
            boolean valueCheck = this.validateNameValue();
            this.view.addButton.setEnabled(valueCheck);
        }
    }

    private boolean validateNameValue() {
        String strName = this.view.configParamName.getValue();
        String strValue = this.view.configParamValue.getValue();
        boolean result = false;
        boolean nameValidity = false;
        nameValidity = strName != null && strName.startsWith("$") && strName.length() > 1;
        boolean valueValidity = false;
        valueValidity = strValue != null && strValue.length() > 0;
        result = nameValidity && valueValidity;
        return result;
    }
}

