/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.ericsson.cello.emas.sm.applications.RestoreSlide1FtpServerDataWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlide2VerificationWizardController;
import se.ericsson.cello.emas.sm.applications.RestoreSlide2VerificationWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlidesController;
import se.ericsson.cello.emas.sm.applications.ResultPrintoutHelper;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.gengui.InputVerifier;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.cellomom.CVActionMainResult;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentDetailedActivity;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentMainActivity;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class RestoreSlide1FtpServerDataWizardController
extends RestoreSlidesController
implements ActionListener,
MOProxy.MOListener {
    private RestoreSlide1FtpServerDataWizardView view;
    private NameValue[] getFromFtpServerActionParameters = new NameValue[4];
    private boolean downloadIsOngoing = false;
    private boolean downloadFinished = false;
    private PathForCvBackupOnFtpServer_verifier pathForCvBackupOnFtpServer_verifier = new PathForCvBackupOnFtpServer_verifier();
    protected final String PATH_FOR_CV_BACKUP_ON_FTP_SERVER = "pathForCvBackupOnFtpServer";
    protected final String FTP_SERVER_IP_ADDRESS = "ftpServerIpAddress";
    protected final String FTP_SERVER_USER_ID = "ftpServerUserId";
    protected final String FTP_SERVER_PASSWORD = "ftpServerPassword";

    protected void init() {
        this.view = (RestoreSlide1FtpServerDataWizardView)this.getView();
        this.view.setInfoJTextArea(this.getString("RESTORE_INFO_TEXT_WIZARD_SLIDE1", null));
        this.ldn = (String)this.getParameter("LDNLIST");
        configurationVersionMo = new MOProxy(this.ldn);
        this.view.setActionListener(this);
        this.view.pathForCvBackupOnFtpServer.setInputVerifier((InputVerifier)this.pathForCvBackupOnFtpServer_verifier);
    }

    protected Class getNextViewClass() {
        return RestoreSlide2VerificationWizardView.class;
    }

    protected Class getNextControllerClass() {
        return RestoreSlide2VerificationWizardController.class;
    }

    protected void beforeVisible() {
        this.setWizardTitle("CV_RESTORE_WIZARD_SLIDE_1", null);
        this.setNextEnabled(this.view.checkMandatoryFields());
        this.setCancelVisible(false);
        this.setCloseVisible(true);
        this.setNextAsDefaultButton();
        this.view.setToolTips();
        if (!this.downloadFinished) {
            this.view.resquestFocusInFtpServerIpAddressField();
        } else {
            this.requestFocusNextButton();
        }
    }

    protected boolean next() {
        if (configurationVersionMo != null) {
            if (!this.downloadFinished) {
                configurationVersionMo.addMOListener((MOProxy.MOListener)this);
                this.setNextEnabled(false);
                this.view.setAllInputFieldsEditable(false);
                try {
                    this.getFromFtpServerActionParameters[0] = new NameValue("pathForCvBackupOnFtpServer", (Object)this.view.pathForCvBackupOnFtpServer.getValue());
                    this.getFromFtpServerActionParameters[1] = new NameValue("ftpServerIpAddress", (Object)this.view.ftpServerIpAddress.getValue());
                    this.getFromFtpServerActionParameters[2] = new NameValue("ftpServerUserId", (Object)this.view.ftpServerUserId.getValue());
                    if (!this.nextButtonHasFocus()) {
                        this.requestFocusNextButton();
                    }
                    this.getFromFtpServerActionParameters[3] = new NameValue("ftpServerPassword", (Object)this.view.ftpServerPassword.getValue());
                    configurationVersionMo.action("getFromFtpServer", this.getFromFtpServerActionParameters);
                    this.view.startIndeterminateProgressBar();
                    this.downloadIsOngoing = true;
                    return false;
                }
                catch (CSException e) {
                    Log.logError((String)"Exception getting parameters.", (Throwable)e);
                    this.reportException((Exception)((Object)e), "ERROR_GET", null);
                    this.letTheUserTryAgain();
                    return false;
                }
                catch (SyntaxException e) {
                    Log.logError((String)"SyntaxException", (Throwable)e);
                    this.reportException((Exception)((Object)e), "ERROR_GET", null);
                    this.letTheUserTryAgain();
                    return false;
                }
            }
            configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        }
        return true;
    }

    protected boolean close() {
        configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        return true;
    }

    protected void viewClosing() {
        configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        this.getApplicationManager().exitApplicationEMTApp();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("ENTRYFIELD_FILLEDIN")) {
            this.setNextEnabled(this.view.checkMandatoryFields());
            this.setNextAsDefaultButton();
        }
    }

    public void attributesChanged(MOProxy anMO, NameValue[] someAttributes) {
        Log.trace((String)"------  method attributesChanged in class RestoreSlide1FtpServerDataWizardController");
        try {
            if (this.downloadIsOngoing) {
                for (int i = 0; i < someAttributes.length; ++i) {
                    if (someAttributes[i].name.equals("currentDetailedActivity")) {
                        this.view.setTextInProgressBar(this.getString(CVCurrentDetailedActivity.get((Object)someAttributes[i].value).toString(), null));
                        continue;
                    }
                    if (!someAttributes[i].name.equals("currentMainActivity") || CVCurrentMainActivity.get((Object)someAttributes[i].value) != CVCurrentMainActivity.IDLE) continue;
                    this.downloadIsOngoing = false;
                    this.view.stopIndeterminateProgressBar();
                    this.goToNextSlideIfPossible();
                }
            }
        }
        catch (Exception e) {
            this.view.stopIndeterminateProgressBar();
            Log.logError((String)"Exception getting parameters.", (Throwable)e);
            this.reportException(e, "ERROR_GET", null);
        }
    }

    private void goToNextSlideIfPossible() {
        configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        try {
            this.actionResult = (Struct)configurationVersionMo.getAttribute("actionResult");
            this.mainResult = (Integer)this.actionResult.getElementValue("mainResult");
            downloadedCv = this.actionResult.getElementValue("configurationVersionName");
        }
        catch (Exception e) {
            Log.logError((String)"Exception getting parameters.", (Throwable)e);
            this.reportException(e, "ERROR_GET", null);
        }
        if (CVActionMainResult.get((Object)this.mainResult) == CVActionMainResult.EXECUTED) {
            this.downloadIsOngoing = false;
            this.downloadFinished = true;
            this.view.stopIndeterminateProgressBar();
            this.view.setTextInProgressBar(this.getString("RESTORE_DOWNLOAD_ALREADY_PERFORMED", null));
            this.getWizardPresenter().showNext();
        } else if (CVActionMainResult.get((Object)this.mainResult) == CVActionMainResult.EXECUTED_WITH_WARNINGS) {
            Object[] args = new Object[]{downloadedCv};
            String stringWarningMessage = this.getString("RESTORE_DOWNLOAD_WARNING_MESSAGE", args) + "\n\n\n" + ResultPrintoutHelper.processResult(this.view.getBundle());
            JTextArea jTextAreaWarningMessage = new JTextArea(stringWarningMessage);
            jTextAreaWarningMessage.setEditable(false);
            jTextAreaWarningMessage.setSize(new Dimension(550, 300));
            jTextAreaWarningMessage.setLineWrap(true);
            jTextAreaWarningMessage.setWrapStyleWord(true);
            jTextAreaWarningMessage.setBackground(this.view.basePanel.getBackground());
            Object[] buttons = new String[]{this.getString("GSL_YES", null), this.getString("GSL_NO", null)};
            int userChoice = JOptionPane.showOptionDialog((Component)((Object)this.view), new JScrollPane(jTextAreaWarningMessage), this.getString("RESTORE_WARNING", null), 0, 2, null, buttons, buttons[0]);
            if (userChoice == 0) {
                this.downloadFinished = true;
                this.view.setTextInProgressBar(this.getString("RESTORE_DOWNLOAD_ALREADY_PERFORMED", null));
                this.getWizardPresenter().showNext();
            } else {
                this.letTheUserTryAgain();
            }
        } else if (CVActionMainResult.get((Object)this.mainResult) == CVActionMainResult.EXECUTION_FAILED) {
            this.showErrorMessage();
        }
    }

    private void showErrorMessage() {
        ErrorDialog errorDialog = ErrorDialog.create((Component)((Object)this.view), (String)ResultPrintoutHelper.processResult(this.view.getBundle()), null, null, null, null, (String)this.getString("RESTORE_DOWNLOAD_ERROR_MESSAGE", null));
        errorDialog.setModal(false);
        errorDialog.show();
        this.letTheUserTryAgain();
    }

    private void letTheUserTryAgain() {
        this.view.setTextInProgressBar("");
        this.setNextEnabled(true);
        this.view.setAllInputFieldsEditable(true);
    }

    public void childCreated(MOProxy childMO) {
    }

    public void childDeleted(MOProxy childMO) {
    }

    private class PathForCvBackupOnFtpServer_verifier
    extends InputVerifier {
        private PathForCvBackupOnFtpServer_verifier() {
        }

        public boolean verify(JComponent input) {
            JTextField field = (JTextField)input;
            String value = field.getText();
            return value.length() <= 255;
        }
    }
}

