/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import se.ericsson.cello.emas.sm.applications.UpgradePackageController;
import se.ericsson.cello.emas.sm.applications.UpgradePackagePiuTypeView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.mgr.cellomom.LmFilesInstallState;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class UpgradePackagePiuTypeController
extends AbstractDialogController
implements ActionListener {
    private UpgradePackagePiuTypeView viewer = null;
    private Hashtable piuTypes = null;
    private MOProxy upgradePackageMo;
    private MOProxy swMo;
    private String[] moAttrs = new String[]{"lmFilesInstallState"};

    protected void init() {
        this.setTitle();
        this.viewer = (UpgradePackagePiuTypeView)this.getView();
        this.viewer.btnPiuTypeFrcInstall.setEnabled(false);
        this.viewer.btnPiuTypeInstall.setEnabled(false);
        this.swMo = new MOProxy("ManagedElement=1,SwManagement=1");
        String[] header = new String[this.moAttrs.length + 1];
        if (header.length > 0) {
            header[0] = "PIUTYPE_AVAIL";
        }
        for (int i = 0; i < this.moAttrs.length; ++i) {
            header[i + 1] = this.moAttrs[i];
        }
        this.viewer.setColumnName(header);
        this.piuTypes = this.searchForMos(this.swMo, "PiuType", this.moAttrs);
        this.performQuery();
        this.upgradePackageMo = new MOProxy(this.getUpLdn());
        this.viewer.upLdn.setValue((String)this.getParameter("LDNLIST"));
        this.viewer.addActionListener(this);
    }

    public boolean canStop() {
        return true;
    }

    protected void setTitle() {
        String titleKey = "PIUTYPE_INSTALL_TITLE";
        this.getApplication().setTitle(titleKey, null);
    }

    private String getUpLdn() {
        return (String)this.getParameter("LDNLIST");
    }

    protected void beforeVisible() {
        this.viewer.setToolTipsOnLabels();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        Log.trace((String)("actionPerformed: actionCommand = " + command));
        if (command == "force install piu selected") {
            this.installPiuType("piuTypeForcedInstall");
            this.stopDialog();
        } else if (command == "install piu selected") {
            this.installPiuType("piuTypeInstall");
            this.stopDialog();
        } else if (command == "btSearch") {
            this.performQuery();
        } else if (command == "btCancel") {
            ((UpgradePackageController)this.getParentController()).showMoAttributes();
            this.stopDialog();
        }
    }

    protected void performQuery() {
        String filterString = this.viewer.inputField.getText();
        Enumeration e = this.piuTypes.keys();
        ArrayList<PiuTypeAttributes> lista = new ArrayList<PiuTypeAttributes>();
        while (e.hasMoreElements()) {
            Object obj;
            String k = (String)e.nextElement();
            if (k.indexOf(filterString) == -1 || !((obj = this.piuTypes.get(k)) instanceof HashMap)) continue;
            HashMap hm = (HashMap)obj;
            lista.add(new PiuTypeAttributes(k, hm));
        }
        Object[][] tblData = new Object[lista.size()][this.moAttrs.length + 1];
        Iterator iter = lista.iterator();
        int row = 0;
        while (iter.hasNext()) {
            PiuTypeAttributes piu = (PiuTypeAttributes)iter.next();
            tblData[row][0] = piu.getLdn();
            for (int j = 0; j < this.moAttrs.length; ++j) {
                if ("lmFilesInstallState".equalsIgnoreCase(this.moAttrs[j])) {
                    String value = LmFilesInstallState.get((Object)piu.getAttrValue(this.moAttrs[j])).toString();
                    tblData[row][j + 1] = value.substring(value.indexOf(46) + 1).toLowerCase();
                    continue;
                }
                tblData[row][j + 1] = piu.getAttrValue(this.moAttrs[j]);
            }
            ++row;
        }
        this.viewer.setTableData(tblData);
    }

    private Hashtable searchForMos(MOProxy parent, String moType, String[] moAttrs) {
        Hashtable result = null;
        try {
            result = parent.getChildrenWithAttributes(moType, moAttrs, 1);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_PIU_INSTALL_SEARCH_PIUS_ERROR_MSG", null);
        }
        return result;
    }

    private void installPiuType(String action) {
        String instPiuTypeLDN = this.viewer.getSelectedLDN();
        if (instPiuTypeLDN != null && !"".equals(instPiuTypeLDN)) {
            Object[] args = new Object[]{instPiuTypeLDN};
            NameValue[] installPiuTypeMo = new NameValue[]{new NameValue("aPiuTypeMo", (Object)new MOProxy(instPiuTypeLDN))};
            try {
                this.upgradePackageMo.action(action, installPiuTypeMo);
            }
            catch (CSException e) {
                this.reportException((Exception)((Object)e), "UP_PIU_INSTALL_ERROR_MSG", args);
            }
        }
    }

    private class PiuTypeAttributes {
        private String ldn;
        private HashMap attrs;

        public PiuTypeAttributes(String k, HashMap hm) {
            this.ldn = k;
            this.attrs = hm;
        }

        public String getLdn() {
            return this.ldn;
        }

        public String getValue(String attrType) {
            return (String)this.attrs.get(attrType);
        }

        public Object getAttrValue(String header) {
            Object h = this.attrs.get(header);
            return h;
        }
    }
}

