/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.swmanagement.RemoteFileDataMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;

public class RemoteFileDataMoImpl
extends CelloMao
implements RemoteFileDataMo,
Reservable {
    private static String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"RemoteFileDataId", "userLabel", "directoryPath", "fileName", "remoteFileServerRef"};
    protected MoData data;
    protected static final int MO_DATA_REVISION_LATEST = 14000;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryAttribute("directoryPath", attrList);
        this.checkMandatoryAttribute("fileName", attrList);
        this.checkMandatoryRefAttribute("remoteFileServerRef", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "RemoteFileData");
        }
    }

    private void checkMandatoryRefAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0) {
            throw new AttrMissingAtCreateException(string, "RemoteFileData");
        }
    }

    public RemoteFileDataMoImpl(Coordinator coordinator, ManagedObject managedObject, String string, InitialMaoContext initialMaoContext, AttrList attrList) throws MoAccessException {
        super(managedObject, "RemoteFileData", string, coordinator, initialMaoContext);
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("RemoteFileData");
        setRequestContextImpl.assertAllowedAttributes(NON_READONLY_MOM_ATTRIBUTES, "RemoteFileData");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "RemoteFileData", true, coordinator);
        this.registerAttributes();
        this.data.setRevision(14000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"RemoteFileData");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"directoryPath", (AttrList)attrList, (Class)String.class, (String)"RemoteFileData");
        this.validateDirectoryPath(string3, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("directoryPath")).setValue(string3);
        String string4 = (String)MoGenUtil.checkAndGetAttributeType((String)"fileName", (AttrList)attrList, (Class)String.class, (String)"RemoteFileData");
        this.validateFileName(string4, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("fileName")).setValue(string4);
        ManagedObject managedObject2 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"remoteFileServerRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"RemoteFileData");
        this.validateRemoteFileServerRef(managedObject2, (SetRequestContext)setRequestContextImpl);
        ((ReferenceAttribute)this.data.getAttribute("remoteFileServerRef")).setValue(managedObject2);
        this.onCreate((SetRequestContext)setRequestContextImpl);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
    }

    public RemoteFileDataMoImpl(MoData moData, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14000);
        this.registerAttributes();
        try {
            Control control = initialMaoContext.getTransactionFactory().create(100);
            this.data.handleTransaction(control.getCoordinator(), MoData.WRITE_ACCESS);
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            Assert.cppAssert((boolean)false, (String)("Unable to recover VirtualMachine MO, transaction fault: " + exception));
        }
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = null;
        managedObject = this.getRemoteFileServerRef(coordinator);
        if (managedObject != null && managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length > 0) {
            throw new MoReservedNotDeletableException("RemoteFileData");
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public String getDirectoryPath(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("directoryPath", coordinator);
    }

    public String getFileName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("fileName", coordinator);
    }

    public void setRemoteFileServerRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("remoteFileServerRef", managedObject, coordinator);
    }

    public ManagedObject getRemoteFileServerRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("remoteFileServerRef", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public String getType() {
        return "RemoteFileData";
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("directoryPath")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("directoryPath")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fileName")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("fileName")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remoteFileServerRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("remoteFileServerRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                SequenceAttribute sequenceAttribute = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)sequenceAttribute, (Coordinator)coordinator);
                continue;
            }
            objectArray[i] = super.getAttribute(stringArray[i], coordinator);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("RemoteFileData");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "RemoteFileData");
            }
            if (string.equalsIgnoreCase("remoteFileServerRef")) {
                if (object instanceof ManagedObject) {
                    string2 = (ManagedObject)object;
                    this.validateRemoteFileServerRef((ManagedObject)string2, (SetRequestContext)setRequestContextImpl);
                    ManagedObject managedObject = this.getRemoteFileServerRef(coordinator);
                    this.updateReservedMos(managedObject, (ManagedObject)string2, coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("remoteFileServerRef")).setValue((ManagedObject)string2);
                    continue;
                }
                throw new WrongAttributeTypeException("remoteFileServerRef", "RemoteFileData");
            }
            throw new NoSuchAttributeException(string, "RemoteFileData");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
    }

    private boolean isAttrMissing(String string) {
        return this.data.getAttribute(string) == null;
    }

    private void registerAttributes() {
        if (this.isAttrMissing("userLabel")) {
            this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        }
        if (this.isAttrMissing("reservedBy")) {
            this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        }
        if (this.isAttrMissing("directoryPath")) {
            this.data.registerPersistentAttr((Attribute)new StringAttribute("directoryPath", false));
        }
        if (this.isAttrMissing("fileName")) {
            this.data.registerPersistentAttr((Attribute)new StringAttribute("fileName", true));
        }
        if (this.isAttrMissing("remoteFileServerRef")) {
            this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("remoteFileServerRef", true));
        }
    }

    protected void updateReservedMos(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"RemoteFileData");
    }

    protected void validateDirectoryPath(String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateFileName(String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateRemoteFileServerRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject == null) {
            throw new ValueOutOfRangeException("remoteFileServerRef", "RemoteFileData");
        }
    }
}

