/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement.handler;

import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.swmanagement.handler.RepertoireMoDataConversionHandlerException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class RepertoireMoDataConversionHandler {
    public static final RepertoireMoDataConversionHandler INSTANCE = new RepertoireMoDataConversionHandler();
    private static final char LM_INFO_DELIM_CHAR = "&".charAt(0);
    private static final char LOAD_LIST_DELIM_CHAR = "#".charAt(0);
    private static final int OLD_NUMBER_OF_LM_INFO_DELIM_CHARS = 4;
    private static final int ONE_HOUR = 3600;
    private static final String NEW_ATTRIBUTES_WITH_NO_VALUES_STRING = "&&&";
    private boolean myIsAnyLoadModuleRefChecked = false;
    private boolean myIsConversionOfLoadModuleRefsNeeded = false;

    private RepertoireMoDataConversionHandler() {
    }

    public SequenceAttribute convertLoadModuleRefs(SequenceAttribute sequenceAttribute, MoData moData) throws RepertoireMoDataConversionHandlerException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertLoadModuleRefs(SequenceAttribute aLoadModuleRefs, MoData anMO_Data)", (String)("aLoadModuleRefs:\n\t" + Lib.toString((SequenceAttribute)sequenceAttribute) + "\n\tmyIsAnyLoadModuleRefChecked: " + this.myIsAnyLoadModuleRefChecked + "\n\tmyIsConversionOfLoadModuleRefsNeeded: " + this.myIsConversionOfLoadModuleRefsNeeded));
        try {
            if (this.myIsAnyLoadModuleRefChecked && !this.myIsConversionOfLoadModuleRefsNeeded) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"convertLoadModuleRefs(SequenceAttribute aLoadModuleRefs, MoData anMO_Data)", (String)"Conversion is NOT needed, returning received data.");
                return sequenceAttribute;
            }
            if (!this.isConversionOfLoadModuleRefsNeededForThisRepertoire(sequenceAttribute)) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"convertLoadModuleRefs(SequenceAttribute aLoadModuleRefs, MoData anMO_Data)", (String)"Conversion is NOT needed, returning received data.");
                return sequenceAttribute;
            }
            sequenceAttribute = this.convertLoadModuleRefsForOneRepertoire(sequenceAttribute, moData);
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"convertLoadModuleRefs(SequenceAttribute aLoadModuleRefs, MoData anMO_Data)", (String)("Conversion is done, returning converted data:\n\t" + Lib.toString((SequenceAttribute)sequenceAttribute)));
            return sequenceAttribute;
        }
        catch (RepertoireMoDataConversionHandlerException repertoireMoDataConversionHandlerException) {
            throw repertoireMoDataConversionHandlerException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"convertLoadModuleRefs(SequenceAttribute aLoadModuleRefs, MoData anMO_Data)", (String)("Throwable caught when trying to check if value of attribute 'loadModuleRefs' for a Repertoire needs to be converted,\n\taLoadModuleRefs: " + Lib.toString((SequenceAttribute)sequenceAttribute)), (Throwable)throwable);
            throw new RepertoireMoDataConversionHandlerException("Throwable caught when trying to check if value of attribute 'loadModuleRefs' for a Repertoire needs to be converted,\n\tThrowable data: " + throwable);
        }
    }

    private SequenceAttribute convertLoadModuleRefsForOneRepertoire(SequenceAttribute sequenceAttribute, MoData moData) throws RepertoireMoDataConversionHandlerException {
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            Attribute[] attributeArray = sequenceAttribute.getValue(null);
            StringAttribute stringAttribute = null;
            String string = null;
            for (int i = 0; i < attributeArray.length; ++i) {
                stringAttribute = (StringAttribute)attributeArray[i];
                string = stringAttribute.getValue(null);
                string = this.convertLoadModuleRefsForOnePiuTypeLoadList(string);
                stringAttribute.setValue(string);
            }
            sequenceAttribute.setValue(attributeArray);
            control.getTerminator().commit();
            return sequenceAttribute;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"convertLoadModuleRefsForOneRepertoire(SequenceAttribute aLoadModuleRefs, MoData anMO_Data)", (String)("Throwable caught when trying to convert value of attribute 'loadModuleRefs' for a Repertoire,\n\taLoadModuleRefs: " + Lib.toString((SequenceAttribute)sequenceAttribute)), (Throwable)throwable);
            throw new RepertoireMoDataConversionHandlerException("Throwable caught when trying to convert value of attribute 'loadModuleRefs' for a Repertoire,\n\tThrowable data: " + throwable);
        }
    }

    private String convertLoadModuleRefsForOnePiuTypeLoadList(String string) {
        int n = string.indexOf(LOAD_LIST_DELIM_CHAR);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == LOAD_LIST_DELIM_CHAR && i > n) {
                stringBuffer.append(NEW_ATTRIBUTES_WITH_NO_VALUES_STRING);
            }
            stringBuffer.append(c);
        }
        stringBuffer.append(NEW_ATTRIBUTES_WITH_NO_VALUES_STRING);
        return stringBuffer.toString();
    }

    private boolean isConversionOfLoadModuleRefsNeededForThisRepertoire(SequenceAttribute sequenceAttribute) {
        Attribute[] attributeArray = sequenceAttribute.getValue(null);
        StringAttribute stringAttribute = null;
        String string = null;
        int n = 0;
        if (n < attributeArray.length) {
            stringAttribute = (StringAttribute)attributeArray[n];
            string = stringAttribute.getValue(null);
            if (!this.myIsAnyLoadModuleRefChecked) {
                this.myIsConversionOfLoadModuleRefsNeeded = this.isConversionOfLoadModuleRefsNeeded(string);
                this.myIsAnyLoadModuleRefChecked = true;
            }
            return this.myIsConversionOfLoadModuleRefsNeeded;
        }
        return false;
    }

    private boolean isConversionOfLoadModuleRefsNeeded(String string) {
        int n = string.indexOf(LOAD_LIST_DELIM_CHAR) + 1;
        int n2 = string.indexOf(LOAD_LIST_DELIM_CHAR, n) - 1;
        if (n2 < n) {
            n2 = string.length() - 1;
        }
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            char c = string.charAt(i);
            if (c != LM_INFO_DELIM_CHAR || ++n3 <= 4) continue;
            return false;
        }
        return true;
    }
}

