/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.launchpad;

import java.util.Properties;
import se.ericsson.cello.launchpad.LaunchpadLog;
import se.ericsson.cello.launchpad.toolservice.ToolHandling;
import se.ericsson.cello.launchpad.toolservice.ToolHandlingFactory;
import se.ericsson.cello.launchpad.toolservice.ToolServiceFactory;
import se.ericsson.cello.launchpad.toolservice.ToolServices;
import se.ericsson.cello.launchpad.view.LaunchPadGui;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class LaunchPadTool
implements Launchable {
    private LauncherInterface launcher;
    private LaunchPadGui gui;
    private ToolHandling toolHandling;

    public void exit() {
        this.gui.setVisible(false);
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return true;
    }

    public void run(String hostName, Properties arguments, LauncherInterface launcher, Launchable parent) {
        LaunchpadLog.logger().finer("Entering run");
        this.launcher = launcher;
        this.toolHandling = ToolHandlingFactory.createToolHandler(arguments);
        ToolServices toolServices = ToolServiceFactory.createToolServices(launcher, this, this.toolHandling);
        this.gui = new LaunchPadGui(hostName, toolServices);
        LaunchpadLog.logger().finer("Show Launcpad gui");
        this.gui.setVisible(true);
    }

    public String toString() {
        if (this.toolHandling != null) {
            return this.toolHandling.getTitle();
        }
        return "Launchpad";
    }
}

