/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import enea.ose.system.Signal;
import java.util.StringTokenizer;
import se.ericsson.cello.iptransport.IpAccessAutoConfigMo;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiCreateCfm;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiDeleteCfm;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiGetAttrCfm;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiNetworkAddress;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiProxy;
import se.ericsson.cello.iptransport.ipac_acmi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpAccessAutoConfigMoImpl
extends ManagedObjectBase
implements IpAccessAutoConfigMo,
Reservable {
    private MoData data;
    private IntegerAttribute ipAccessAutoConfigFroId;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private static final String IPAC_AC_FRO_ID = "ipacAcFroId";
    private static final int MAX_NUMBER_AUTO_CONFIG = 32;
    private static IpacAcMiProxy ipacAcMiProxy = IpacAcMiProxy.instance(ipac_acmi.class, "IpAccessAutoConfig");
    private static final int MO_DATA_REVISION_42 = 4200;
    private static final int MO_DATA_REVISION_LATEST = 4200;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkIdentity((String)"IpAccessAutoConfig", (String)string);
        MoAttributeValidator.checkCardinality((String)"IpAccessAutoConfig", (int)32);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpAccessAutoConfig", (int)128, (int)0);
        String string3 = IpAccessAutoConfigMoImpl.checkAndGetNetworkAddress(attrList, "minIpAddress");
        String string4 = IpAccessAutoConfigMoImpl.checkAndGetNetworkAddress(attrList, "maxIpAddress");
        IpAccessAutoConfigMoImpl.verifyIpAddress(string4, string3);
        int[] nArray = MaoFroTypeConverter.ipacIpAddrString2IntArray((String)string3);
        int[] nArray2 = MaoFroTypeConverter.ipacIpAddrString2IntArray((String)string4);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpAccessAutoConfig");
        return new IpAccessAutoConfigMoImpl(managedObject, string, string2, nArray, nArray2, coordinator);
    }

    private IpAccessAutoConfigMoImpl(ManagedObject managedObject, String string, String string2, int[] nArray, int[] nArray2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "IpAccessAutoConfig", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        int n = this.createFro(coordinator, nArray, nArray2);
        this.ipAccessAutoConfigFroId = new IntegerAttribute(IPAC_AC_FRO_ID, false);
        this.ipAccessAutoConfigFroId.setValue(n);
        this.data.registerPersistentAttr((Attribute)this.ipAccessAutoConfigFroId);
        this.data.setRevision(4200);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpAccessAutoConfigMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4200);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(IPAC_AC_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        this.ipAccessAutoConfigFroId = (IntegerAttribute)moData.getAttribute(IPAC_AC_FRO_ID);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("IpAccessAutoConfig");
        }
        this.deleteFro(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void deleteFro(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        IpacAcMiDeleteCfm ipacAcMiDeleteCfm = ipacAcMiProxy.sendIpacAcMiDeleteReq(coordinator.getTransactionID(), this.getFroId(coordinator));
        IpAccessAutoConfigMoImpl.checkSignal((Signal)ipacAcMiDeleteCfm);
        IpAccessAutoConfigMoImpl.checkResult(ipacAcMiDeleteCfm.getResult(), "DeleteFroReq: ");
    }

    private static void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("IpAccessAutoConfig", "IpAccessAutoConfigFro");
        }
    }

    private static void checkResult(int n, String string) throws FroRequestFailedException {
        if (n != 1) {
            throw new FroRequestFailedException("IpAccessAutoConfig", "IpAccessAutoConfig", string + ipacAcMiProxy.getResultMsg(n), n);
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ipAccessAutoConfigFroId.getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"IpAccessAutoConfig", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[this.reservedBy.size()];
        for (int i = 0; i < this.reservedBy.size(); ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public String getMinIpAddress(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm = this.getFroAttributes(coordinator);
        IpacAcMiNetworkAddress ipacAcMiNetworkAddress = ipacAcMiGetAttrCfm.getNetworkAddress();
        return MaoFroTypeConverter.intArray2String((int[])ipacAcMiNetworkAddress.minIpAddress);
    }

    public String getMaxIpAddress(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm = this.getFroAttributes(coordinator);
        IpacAcMiNetworkAddress ipacAcMiNetworkAddress = ipacAcMiGetAttrCfm.getNetworkAddress();
        return MaoFroTypeConverter.intArray2String((int[])ipacAcMiNetworkAddress.maxIpAddress);
    }

    public int getNrOfUnusedAdresses(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm = this.getFroAttributes(coordinator);
        return ipacAcMiGetAttrCfm.getNoOfNotUsedAddresses();
    }

    public int getTotalNrOfAddresses(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm = this.getFroAttributes(coordinator);
        return ipacAcMiGetAttrCfm.getTotNoOfAddresses();
    }

    public String getType() {
        return "IpAccessAutoConfig";
    }

    public String getIpAccessAutoConfigId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("IpAccessAutoConfigId", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray = new Object[stringArray.length];
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm = new IpacAcMiGetAttrCfm();
        ipacAcMiGetAttrCfm = null;
        for (int i = 0; i < stringArray.length; ++i) {
            IpacAcMiNetworkAddress ipacAcMiNetworkAddress;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = this.userLabel.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = this.getReservedBy(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("minIpAddress")) {
                ipacAcMiGetAttrCfm = this.getAttrFromRes(ipacAcMiGetAttrCfm, coordinator);
                ipacAcMiNetworkAddress = ipacAcMiGetAttrCfm.getNetworkAddress();
                objectArray[i] = MaoFroTypeConverter.intArray2String((int[])ipacAcMiNetworkAddress.minIpAddress);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxIpAddress")) {
                ipacAcMiGetAttrCfm = this.getAttrFromRes(ipacAcMiGetAttrCfm, coordinator);
                ipacAcMiNetworkAddress = ipacAcMiGetAttrCfm.getNetworkAddress();
                objectArray[i] = MaoFroTypeConverter.intArray2String((int[])ipacAcMiNetworkAddress.maxIpAddress);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nrOfUnusedAdresses")) {
                ipacAcMiGetAttrCfm = this.getAttrFromRes(ipacAcMiGetAttrCfm, coordinator);
                objectArray[i] = new Integer(ipacAcMiGetAttrCfm.getNoOfNotUsedAddresses());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("totalNrOfAddresses")) {
                ipacAcMiGetAttrCfm = this.getAttrFromRes(ipacAcMiGetAttrCfm, coordinator);
                objectArray[i] = new Integer(ipacAcMiGetAttrCfm.getTotNoOfAddresses());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IpAccessAutoConfigId")) {
                objectArray[i] = this.getNamingAttributeValue();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessAutoConfig");
        }
        return objectArray;
    }

    private IpacAcMiGetAttrCfm getAttrFromRes(IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm, Coordinator coordinator) throws MoAccessException {
        if (ipacAcMiGetAttrCfm == null) {
            return this.getFroAttributes(coordinator);
        }
        return ipacAcMiGetAttrCfm;
    }

    private int createFro(Coordinator coordinator, int[] nArray, int[] nArray2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        IpacAcMiNetworkAddress ipacAcMiNetworkAddress = new IpacAcMiNetworkAddress();
        ipacAcMiNetworkAddress.minIpAddress = nArray;
        ipacAcMiNetworkAddress.maxIpAddress = nArray2;
        IpacAcMiCreateCfm ipacAcMiCreateCfm = ipacAcMiProxy.sendIpacAcMiCreateReq(coordinator.getTransactionID(), ipacAcMiNetworkAddress);
        IpAccessAutoConfigMoImpl.checkSignal((Signal)ipacAcMiCreateCfm);
        if (ipacAcMiCreateCfm.getResult() != 1) {
            throw new FroRequestFailedException("IpAccessAutoConfig", "IpacMi", "CreateFroReq: " + ipacAcMiProxy.getResultMsg(ipacAcMiCreateCfm.getResult()), ipacAcMiCreateCfm.getResult());
        }
        return ipacAcMiCreateCfm.getFroId();
    }

    private IpacAcMiGetAttrCfm getFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        IpacAcMiGetAttrCfm ipacAcMiGetAttrCfm = ipacAcMiProxy.sendIpacAcMiGetAttrReq(n, this.getFroId(coordinator));
        IpAccessAutoConfigMoImpl.checkSignal((Signal)ipacAcMiGetAttrCfm);
        if (ipacAcMiGetAttrCfm.getResult() != 1) {
            throw new FroRequestFailedException("IpAccessAutoConfig", "IpacMi", "GetAttrReq" + ipacAcMiProxy.getResultMsg(ipacAcMiGetAttrCfm.getResult()), ipacAcMiGetAttrCfm.getResult());
        }
        return ipacAcMiGetAttrCfm;
    }

    private static String checkAndGetNetworkAddress(AttrList attrList, String string) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            throw new AttrMissingAtCreateException(string, "IpAccessAutoConfig");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException(string, "IpAccessAutoConfig");
        }
        String string2 = (String)attrList.getValue(n);
        new IpAddress(string2);
        attrList.removeElementAt(n);
        return string2;
    }

    private static void verifyIpAddress(String string, String string2) throws MoAccessException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (n >= (n2 = Integer.parseInt(stringTokenizer2.nextToken()))) continue;
            throw new ValueOutOfRangeException("minIpAddress is greater than maxIpAddress", "IpAccessAutoConfig");
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"IpAccessAutoConfig", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"IpAccessAutoConfig", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }
}

