/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.TrafficManagementQueueMo;
import se.ericsson.cello.iptransport.TrafficManagementQueueMoFactory;
import se.ericsson.cello.iptransport.TrafficSchedulerMo;
import se.ericsson.cello.iptransport.TrafficSchedulerMoImpl;
import se.ericsson.cello.iptransport.mom.EnumDropMechanism;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class TrafficManagementQueueMoImpl
extends CelloMao
implements TrafficManagementQueueMo {
    private MoData data;
    private FroProxy genericProxyInstance = TrafficManagementQueueMoFactory.proxy;
    private MaoFroIndicationHandler indicationHandler = TrafficManagementQueueMoFactory.indicationHandler;
    private StringAttribute userLabel;
    static final String[] RED_PROPERTIES_ELEMENT_NAMES = new String[]{"redMinThreshold", "redMaxThreshold", "redAveragingWeightFactor"};
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private static final String FRO_ID = "froId";
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TrafficScheduler");
        MoAttributeValidator.checkIdentity((String)"TrafficManagementQueue", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"TrafficManagementQueue", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerType((String)"queueNumber", (AttrList)attrList, (String)"TrafficManagementQueue");
        int n2 = MoAttributeValidator.checkAndGetIntegerType((String)"tsFroId", (AttrList)attrList, (String)"TrafficManagementQueue");
        int n3 = MoAttributeValidator.checkAndGetEnumAttribute((String)"dropMechanism", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumDropMechanism.VALUES_ARRAY, (String)"TrafficManagementQueue");
        Struct struct = MoAttributeValidator.checkAndGetStructAttribute((String)"redProperties", (AttrList)attrList, (boolean)false, (String)"TrafficManagementQueue");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"TrafficManagementQueue");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("queueNumber", n));
        arrayList.add(new SignedIntParameter("queueLength", 1024000));
        arrayList.add(new SignedIntParameter("queueWeight", 1));
        arrayList.add(new SignedIntParameter("tsFroId", n2));
        arrayList.add(new SignedIntParameter("dropMechanism", n3));
        if (struct != null) {
            arrayList.add(TrafficManagementQueueMoImpl.createStructParameter("redProperties", struct, coordinator));
        } else {
            Object[] objectArray = new Object[]{new Integer(10), new Integer(30), new Integer(8)};
            arrayList.add(TrafficManagementQueueMoImpl.createStructParameter("redProperties", (Struct)new StructImpl(RED_PROPERTIES_ELEMENT_NAMES, objectArray), coordinator));
        }
        return new TrafficManagementQueueMoImpl(managedObject, string, string2, arrayList, coordinator);
    }

    private TrafficManagementQueueMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "TrafficManagementQueue", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FRO_ID, false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public TrafficManagementQueueMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FRO_ID)).getValue(null));
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("TrafficManagementQueueId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("queueLength")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("queueLength");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("queueWeight")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("queueWeight");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dropMechanism")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("dropMechanism");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("redProperties")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (StructParameter)map.get("redProperties");
                Object[] objectArray2 = new Object[]{new Integer(((SignedIntParameter)signedIntParameter.get("redMinThreshold")).getValue()), new Integer(((SignedIntParameter)signedIntParameter.get("redMaxThreshold")).getValue()), new Integer(((SignedIntParameter)signedIntParameter.get("redAveragingWeightFactor")).getValue())};
                objectArray[i] = new StructImpl(RED_PROPERTIES_ELEMENT_NAMES, objectArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("queueOccupancyPackets")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("queueOccupancyPackets");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("queueOccupancyPercentage")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("queueOccupancyPercentage");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmQueueOutOctets")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmQueueOutOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmQueueOutPackets")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmQueueOutPackets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmQueueDroppedPackets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmQueueDroppedPackets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmQueueDroppedOctets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmQueueDroppedOctets", coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TrafficManagementQueue");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.prepareSetFroAttr(coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? TrafficManagementQueueMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "TrafficManagementQueue");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"TrafficManagementQueue", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("queueLength")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? TrafficManagementQueueMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("queueLength", "TrafficManagementQueue");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"queueLength", (int)n, (int)0, (int)6000000, (String)"TrafficManagementQueue");
                map.put("queueLength", new SignedIntParameter("queueLength", n));
                this.sendNotification("queueLength", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("queueWeight")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? TrafficManagementQueueMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("queueWeight", "TrafficManagementQueue");
                }
                int n = (Integer)objectArray[i];
                if (this.getQueueWeights(coordinator) + n > 100) {
                    throw new ValueOutOfRangeException("The sum of queueWeight for all queues belonging to the Weighted Priority Scheduling group can not exceed 100 ", "TrafficManagementQueue");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"queueWeight", (int)n, (int)1, (int)100, (String)"TrafficManagementQueue");
                map.put("queueWeight", new SignedIntParameter("queueWeight", n));
                this.sendNotification("queueWeight", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("redProperties")) {
                if (!(objectArray[i] instanceof Struct)) {
                    throw new WrongAttributeTypeException("redProperties", "TrafficManagementQueue");
                }
                StructParameter structParameter = TrafficManagementQueueMoImpl.createStructParameter("redProperties", (Struct)objectArray[i], coordinator);
                map.put("redProperties", structParameter);
                this.sendNotification("redProperties", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dropMechanism")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? TrafficManagementQueueMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("dropMechanism", "TrafficManagementQueue");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"dropMechanism", (int)n, (int[])EnumDropMechanism.VALUES_ARRAY, (String)"TrafficManagementQueue");
                map.put("dropMechanism", new SignedIntParameter("dropMechanism", n));
                this.sendNotification("dropMechanism", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TrafficManagementQueue");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(map.values());
        this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private static StructParameter createStructParameter(String string, Struct struct, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = new StructParameter(string);
        String[] stringArray = struct.getNames();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            structParameter.add(TrafficManagementQueueMoImpl.validateRedPropertiesStructValue(stringArray[i], struct.getValue(stringArray[i])));
            Object object = struct.getValue(stringArray[i]);
            if (stringArray[i].equals("redMinThreshold")) {
                n = (Integer)object;
            }
            if (!stringArray[i].equals("redMaxThreshold")) continue;
            n2 = (Integer)object;
        }
        if (n > n2) {
            throw new IllegalParameterValueException("redMinThreshold cannot be greater than redMaxThreshold");
        }
        return structParameter;
    }

    private static Parameter validateRedPropertiesStructValue(String string, Object object) throws IllegalParameterValueException, WrongAttributeTypeException, NoSuchAttributeException {
        int n = -1;
        if (!object.getClass().equals(Integer.class)) {
            throw new WrongAttributeTypeException(string, "TrafficManagementQueue");
        }
        if (string.equals("redMinThreshold")) {
            if (object != null) {
                n = (Integer)object;
            }
            if (n < 1 || n > 100) {
                TrafficManagementQueueMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, n);
        }
        if (string.equals("redMaxThreshold")) {
            if (object != null) {
                n = (Integer)object;
            }
            if (n < 1 || n > 100) {
                TrafficManagementQueueMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, n);
        }
        if (string.equals("redAveragingWeightFactor")) {
            if (object != null) {
                n = (Integer)object;
            }
            if (n < 1 || n > 8) {
                TrafficManagementQueueMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, n);
        }
        throw new NoSuchAttributeException("redProperties" + string, "TrafficManagementQueue");
    }

    private static void throwMeIllegalValueException(String string, Object object) throws IllegalParameterValueException {
        throw new IllegalParameterValueException("parameter " + string + " has illegal value=" + object);
    }

    private int getQueueWeights(Coordinator coordinator) throws MoAccessException {
        int n = ((TrafficSchedulerMo)this.getParent()).getWpStartQueue(coordinator);
        int n2 = ((TrafficSchedulerMo)this.getParent()).getWpEndQueue(coordinator);
        String string = this.getQueueId(coordinator);
        int n3 = this.getQueueWeight(coordinator);
        int n4 = 0;
        if (Integer.parseInt(string) >= n && Integer.parseInt(string) <= n2) {
            n4 = ((TrafficSchedulerMoImpl)this.getParent()).getQueueWeights(n, n2, coordinator) - n3;
        }
        return n4;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private Map prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator), null);
        return map;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FRO_ID)).getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"TrafficManagementQueue", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getType() {
        return "TrafficManagementQueue";
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return null;
    }

    public String getQueueId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("TrafficManagementQueueId", coordinator);
    }

    public int getQueueLength(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("queueLength", coordinator);
    }

    public void setQueueLength(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("queueLength", new Integer(n), coordinator);
    }

    public int getQueueWeight(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("queueWeight", coordinator);
    }

    public void setQueueWeight(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("queueWeight", new Integer(n), coordinator);
    }

    public int getDropMechanism(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("dropMechanism", coordinator);
    }

    public void setDropMechanism(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("dropMechanism", new Integer(n), coordinator);
    }

    public Struct getRedProperties(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("redProperties", coordinator);
    }

    public void setRedProperties(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("redProperties", struct, coordinator);
    }

    public long getPmQueueOutOctets(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmQueueOutOctets", coordinator);
    }

    public long getPmQueueOutPackets(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmQueueOutPackets", coordinator);
    }

    public int getPmQueueDroppedPackets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmQueueDroppedPackets", coordinator);
    }

    public int getPmQueueDroppedOctets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmQueueDroppedOctets", coordinator);
    }

    public int getQueueOccupancyPackets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("queueOccupancyPackets", coordinator);
    }

    public int getQueueOccupancyPercentage(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("queueOccupancyPercentage", coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) {
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) {
    }
}

