/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.hwtest.control;

import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.Board;
import se.ericsson.wcdma.rbs.bem.common.trace.BEMTrace;

class StatusTableModel
extends AbstractTableModel {
    private static final int COLUMN_BOARD = 0;
    private static final int COLUMN_RESULT = 1;
    private static final int BOARD_DELETED = 0;
    private static final int BOARD_CREATED = 1;
    private static final int HW_TEST_RESULT_CHANGED = 2;
    private String myResultPassed;
    private String myResultFailed;
    private String myResultUndetermined;
    private String myResultPending;
    private String myStateLocked;
    private String myStateUnlocked;
    private String myStateShuttingdown;
    private String myHwResult = null;
    private String myAdmState = null;
    private Board[] myBoards;
    private Board thisBoard;
    private String aBoardName;
    private Object aBoardNameObject;
    private boolean rowFound = false;
    private int foundBoardsPos;
    private int noOfPassedBoards = 0;
    private int noOfFailedBoards = 0;
    private int noOfPendingBoards = 0;
    private int noOfUndeterminedBoards = 0;
    private String[] columnNames = new String[]{"HWT_TABLE_HEAD_BOARD", "HWT_TABLE_HEAD_RESULT", "HWT_TABLE_HEAD_ADMSTATE", "HWT_TABLE_HEAD_PRODNO", "HWT_TABLE_HEAD_REV"};
    private Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class};
    private Vector myBoardsVector = new Vector();
    private Vector tableDataVector = new Vector();
    private Vector rowVector;
    private Vector aTempRowVector;

    public StatusTableModel(Board[] boardArray, ResourceBundle resourceBundle) {
        int n;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(StatusTableModel.class, "StatusTableModel(Board[])", boardArray);
        }
        this.myBoards = new Board[boardArray.length];
        this.myBoards = (Board[])boardArray.clone();
        for (n = 0; n < this.myBoards.length; ++n) {
            this.myBoardsVector.addElement(this.myBoards[n]);
        }
        if (resourceBundle != null) {
            this.setTableModelLanguageBundleMessages(resourceBundle);
        }
        for (n = 0; n < this.myBoardsVector.size(); ++n) {
            block7: {
                this.rowVector = new Vector();
                this.thisBoard = (Board)this.myBoardsVector.elementAt(n);
                this.rowVector.addElement(this.thisBoard.getBoardName());
                this.myHwResult = this.getHwTestResultString(this.thisBoard.getHwTestResult());
                this.increaseBoardStates(this.myHwResult);
                this.rowVector.addElement(this.myHwResult);
                this.myAdmState = this.getAdminStateString(this.thisBoard.getAdminState());
                this.rowVector.addElement(this.myAdmState);
                try {
                    this.rowVector.addElement(this.thisBoard.getProductNumber());
                    this.rowVector.addElement(this.thisBoard.getProductRev());
                }
                catch (Exception exception) {
                    if (!BEMTrace.ENABLED) break block7;
                    BEMTrace.exception(StatusTableModel.class, "StatusTableModel(Board[] someBoards)", exception);
                }
            }
            this.tableDataVector.addElement(this.rowVector);
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(StatusTableModel.class, "StatusTableModel(Board[])");
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.tableDataVector.size();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Class getColumnClass(int n) {
        return this.columnClasses[n];
    }

    public Object getValueAt(int n, int n2) {
        this.rowVector = (Vector)this.tableDataVector.elementAt(n);
        return this.rowVector.elementAt(n2);
    }

    protected void updateTable(Board board, String string, int n) {
        int n2 = n;
        Vector vector = new Vector();
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(StatusTableModel.class, "updateTable(Board)", board);
        }
        this.rowFound = false;
        this.thisBoard = board;
        for (int i = 0; i < this.tableDataVector.size(); ++i) {
            this.rowVector = (Vector)this.tableDataVector.elementAt(i);
            this.aBoardNameObject = this.rowVector.elementAt(0);
            this.aBoardName = this.aBoardNameObject.toString();
            if (!this.aBoardName.equals(string)) continue;
            this.rowFound = true;
            this.foundBoardsPos = i;
            vector = this.rowVector;
            break;
        }
        String string2 = null;
        string2 = (String)vector.elementAt(1);
        if (this.rowFound) {
            if (n2 == 0) {
                this.decreaseBoardStates(string2);
                this.tableDataVector.removeElementAt(this.foundBoardsPos);
            }
        }
        if (n2 != 0) {
            block13: {
                this.aTempRowVector = new Vector();
                this.aTempRowVector.addElement(this.thisBoard.getBoardName());
                this.myHwResult = this.getHwTestResultString(this.thisBoard.getHwTestResult());
                if (n2 == 1) {
                    this.increaseBoardStates(this.myHwResult);
                } else if (n2 == 2) {
                    this.decreaseBoardStates(string2);
                    this.increaseBoardStates(this.myHwResult);
                }
                this.aTempRowVector.addElement(this.myHwResult);
                this.myAdmState = this.getAdminStateString(this.thisBoard.getAdminState());
                this.aTempRowVector.addElement(this.myAdmState);
                try {
                    this.aTempRowVector.addElement(this.thisBoard.getProductNumber());
                    this.aTempRowVector.addElement(this.thisBoard.getProductRev());
                }
                catch (Exception exception) {
                    if (!BEMTrace.ENABLED) break block13;
                    BEMTrace.exception(StatusTableModel.class, "updateTable(Board)", exception);
                }
            }
            if (this.rowFound) {
                this.tableDataVector.insertElementAt(this.aTempRowVector, this.foundBoardsPos);
                this.tableDataVector.removeElementAt(this.foundBoardsPos + 1);
            } else {
                this.tableDataVector.addElement(this.aTempRowVector);
            }
            if (BEMTrace.ENABLED) {
                BEMTrace.exit(StatusTableModel.class, "updateTable(Board)");
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void setTableModelLanguageBundleMessages(ResourceBundle resourceBundle) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(StatusTableModel.class, "setTableModelLanguageBundleMessages(ResourceBundle)", resourceBundle);
        }
        if (resourceBundle != null) {
            this.myResultPassed = resourceBundle.getString("BEM_HWT_RES_PASSED");
            this.myResultFailed = resourceBundle.getString("BEM_HWT_RES_FAILED");
            this.myResultUndetermined = resourceBundle.getString("BEM_HWT_RES_UNDETERMINED");
            this.myResultPending = resourceBundle.getString("BEM_HWT_RES_PENDING");
            this.myStateLocked = resourceBundle.getString("BEM_ADMIN_STATE_LOCKED");
            this.myStateUnlocked = resourceBundle.getString("BEM_ADMIN_STATE_UNLOCKED");
            this.myStateShuttingdown = resourceBundle.getString("BEM_ADMIN_STATE_SHUTTINGDOWN");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(StatusTableModel.class, "setTableModelLanguageBundleMessages(ResourceBundle)");
        }
    }

    protected String getAdminStateString(Object object) {
        String string = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(StatusTableModel.class, "getAdminStateString(Object)", object);
        }
        switch ((Integer)object) {
            case 0: {
                string = this.myStateLocked;
                break;
            }
            case 1: {
                string = this.myStateUnlocked;
                break;
            }
            case 2: {
                string = this.myStateShuttingdown;
                break;
            }
            default: {
                string = "Untranslated state";
            }
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(StatusTableModel.class, "getAdminStateString(Object)", string);
        }
        return string;
    }

    protected String getHwTestResultString(Object object) {
        String string = null;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(StatusTableModel.class, "getHwTestResultString(Object)", object);
        }
        switch ((Integer)object) {
            case 0: {
                string = this.myResultPassed;
                break;
            }
            case 1: {
                string = this.myResultFailed;
                break;
            }
            case 3: {
                string = this.myResultUndetermined;
                break;
            }
            case 2: {
                string = this.myResultPending;
                break;
            }
            default: {
                string = "Untranslated result";
            }
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(StatusTableModel.class, "getHwTestResultString(Object)", string);
        }
        return string;
    }

    protected String getNoOfBoardsForState(int n) {
        String string;
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(StatusTableModel.class, "getNoOfBoardsForState(String)", n);
        }
        switch (n) {
            case 0: {
                string = String.valueOf(this.noOfPassedBoards);
                break;
            }
            case 1: {
                string = String.valueOf(this.noOfFailedBoards);
                break;
            }
            case 2: {
                string = String.valueOf(this.noOfPendingBoards);
                break;
            }
            case 3: {
                string = String.valueOf(this.noOfUndeterminedBoards);
                break;
            }
            default: {
                string = "Untranslated result";
            }
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(StatusTableModel.class, "getNoOfBoardsForState(String)", string);
        }
        return string;
    }

    private void increaseBoardStates(String string) {
        if (string.equals(this.myResultPassed)) {
            ++this.noOfPassedBoards;
        } else if (string.equals(this.myResultFailed)) {
            ++this.noOfFailedBoards;
        } else if (string.equals(this.myResultPending)) {
            ++this.noOfPendingBoards;
        } else {
            ++this.noOfUndeterminedBoards;
        }
    }

    private void decreaseBoardStates(String string) {
        if (string.equals(this.myResultPassed)) {
            if (this.noOfPassedBoards != 0) {
                --this.noOfPassedBoards;
            }
        } else if (string.equals(this.myResultFailed)) {
            if (this.noOfFailedBoards != 0) {
                --this.noOfFailedBoards;
            }
        } else if (string.equals(this.myResultPending)) {
            if (this.noOfPendingBoards != 0) {
                --this.noOfPendingBoards;
            }
        } else if (this.noOfUndeterminedBoards != 0) {
            --this.noOfUndeterminedBoards;
        }
    }
}

