/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.control.ConfigReportController;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.control.IntegrateRbsController;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.util.IntegrateRbsUtil;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterGroupPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPasswordField;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.gui.IndeterminateProgressDialog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;

public class StoreConfigReportController
extends JDialog
implements ActionListener {
    private JPanel ftpServerPanel = new JPanel();
    private JPanel clientPanel = new JPanel();
    private JDialog dialog = null;
    private JButton browseButton = new JButton();
    private JButton saveButton;
    private JButton cancelButton;
    private Rbs rbs = null;
    private ConfigReportController configReportController = null;
    private IntegrateRbsController parentController = null;
    private IntegrateRbsUtil integrateRbsUtil = null;
    private String configurationReport = null;
    private List customerParameterPanels = new ArrayList();
    private CustomerParameter storeOnFtpParam;
    private CustomerParameter storeOnClientParam;

    public StoreConfigReportController(ConfigReportController configReportController, IntegrateRbsController integrateRbsController, Rbs rbs, String string) {
        this.rbs = rbs;
        this.configReportController = configReportController;
        this.parentController = integrateRbsController;
        this.configurationReport = string;
        this.integrateRbsUtil = integrateRbsController.getIntegrateRbsUtil();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.ftpServerPanel.setLayout(new GridBagLayout());
        this.ftpServerPanel.setBorder(new TitledBorder(new EtchedBorder(), "FTP Server"));
        jPanel.add((Component)this.ftpServerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.clientPanel.setLayout(new GridBagLayout());
        this.clientPanel.setBorder(new TitledBorder(new EtchedBorder(), "Client"));
        jPanel.add((Component)this.clientPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        try {
            this.storeOnFtpParam = rbs.getCustomerParameterObject("AI_ftpStoreReport");
            this.storeOnFtpParam.setValue("NO");
            CustomerParameter customerParameter = rbs.getCustomerParameterObject("AI_ftpStoreReportAddress");
            CustomerParameter customerParameter2 = rbs.getCustomerParameterObject("AI_ftpStoreReportFilePath");
            CustomerParameter customerParameter3 = rbs.getCustomerParameterObject("AI_ftpStoreReportUserName");
            CustomerParameter customerParameter4 = rbs.getCustomerParameterObject("AI_ftpStoreReportPassword");
            this.setFTPServerPanel(this.storeOnFtpParam, customerParameter, customerParameter2, customerParameter3, customerParameter4);
            this.storeOnClientParam = rbs.getCustomerParameterObject("AI_clientStoreReport");
            this.storeOnClientParam.setValue("NO");
            CustomerParameter customerParameter5 = rbs.getCustomerParameterObject("AI_clientStoreReportFilePath");
            this.setClientPanel(this.storeOnClientParam, customerParameter5);
            this.saveButton = new JButton("Save");
            this.cancelButton = new JButton("Cancel");
            this.saveButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            jPanel2.add(this.saveButton);
            jPanel2.add(this.cancelButton);
            this.dialog = new JDialog(JOptionPane.getFrameForComponent(integrateRbsController.getView()), "Integrate RBS - Store Configuration Report");
            this.dialog.getContentPane().add((Component)jPanel, "Center");
            this.dialog.setLocationRelativeTo(integrateRbsController.getView());
            this.dialog.setSize(900, 900);
            this.dialog.getContentPane().add((Component)jPanel2, "South");
            this.dialog.pack();
            this.dialog.setVisible(true);
        }
        catch (Exception exception) {
            Nal.getLog().nalTraceError(this.getClass(), "Failed to create StoreConfigReportController", exception);
        }
    }

    public void setFTPServerPanel(CustomerParameter customerParameter, CustomerParameter customerParameter2, CustomerParameter customerParameter3, CustomerParameter customerParameter4, CustomerParameter customerParameter5) {
        try {
            CustomerParameterCheckbox customerParameterCheckbox = new CustomerParameterCheckbox("Store configuration report on server", (BooleanCustomerParameter)customerParameter);
            this.ftpServerPanel.add((Component)customerParameterCheckbox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 10, 10), 0, 0));
            CustomerParameterGroupPanel customerParameterGroupPanel = new CustomerParameterGroupPanel();
            CustomerParameterTextField customerParameterTextField = new CustomerParameterTextField(customerParameter2);
            CustomerParameterPanel customerParameterPanel = new CustomerParameterPanel("FTP address:", customerParameterTextField, true);
            customerParameterGroupPanel.add(customerParameterPanel);
            this.customerParameterPanels.add(customerParameterPanel);
            CustomerParameterTextField customerParameterTextField2 = new CustomerParameterTextField(customerParameter3);
            CustomerParameterPanel customerParameterPanel2 = new CustomerParameterPanel("File path:", customerParameterTextField2);
            customerParameterGroupPanel.add(customerParameterPanel2);
            this.customerParameterPanels.add(customerParameterPanel2);
            CustomerParameterTextField customerParameterTextField3 = new CustomerParameterTextField(customerParameter4);
            CustomerParameterPanel customerParameterPanel3 = new CustomerParameterPanel("User name:", customerParameterTextField3);
            customerParameterGroupPanel.add(customerParameterPanel3);
            this.customerParameterPanels.add(customerParameterPanel3);
            CustomerParameterPasswordField customerParameterPasswordField = new CustomerParameterPasswordField(customerParameter5);
            CustomerParameterPanel customerParameterPanel4 = new CustomerParameterPanel("Password:", customerParameterPasswordField);
            customerParameterGroupPanel.add(customerParameterPanel4);
            this.customerParameterPanels.add(customerParameterPanel4);
            this.ftpServerPanel.add((Component)customerParameterGroupPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 10, 10), 0, 0));
        }
        catch (Exception exception) {
            Nal.getLog().nalTraceError(this.getClass(), "Failed in setFTPServerPanel", exception);
        }
    }

    public void setClientPanel(CustomerParameter customerParameter, CustomerParameter customerParameter2) {
        try {
            CustomerParameterCheckbox customerParameterCheckbox = new CustomerParameterCheckbox("Store configuration report on client", (BooleanCustomerParameter)customerParameter);
            customerParameter.addCustomerParameterListener(new StoreOnClientListener());
            this.clientPanel.add((Component)customerParameterCheckbox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 10, 10), 0, 0));
            CustomerParameterTextField customerParameterTextField = new CustomerParameterTextField(customerParameter2);
            CustomerParameterPanel customerParameterPanel = new CustomerParameterPanel("File path:", customerParameterTextField);
            this.customerParameterPanels.add(customerParameterPanel);
            this.clientPanel.add((Component)customerParameterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 10, 10), 0, 0));
            this.browseButton.setText("Browse...");
            this.browseButton.setEnabled(false);
            this.browseButton.addActionListener(new BrowseButtonListener(customerParameter2));
            this.clientPanel.add((Component)this.browseButton, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        }
        catch (Exception exception) {
            Nal.getLog().nalTraceError(this.getClass(), "Failed in setClientPanel", exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButton.removeActionListener(this);
            this.saveButton.removeActionListener(this);
            if (this.dialog != null) {
                this.closeDialog();
            }
        } else if (actionEvent.getSource() == this.saveButton) {
            StoreReportThread storeReportThread = new StoreReportThread();
            storeReportThread.start();
        }
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        this.configReportController.enableSaveButton();
    }

    public String getGuiNameForCustomerParameter(String string) {
        Iterator iterator = this.customerParameterPanels.iterator();
        CustomerParameterPanel customerParameterPanel = null;
        while (iterator.hasNext()) {
            customerParameterPanel = (CustomerParameterPanel)iterator.next();
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            String string2 = customerParameterPanel.getLabel().getText().replace(':', ' ');
            return string2;
        }
        return "";
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        Iterator iterator = this.customerParameterPanels.iterator();
        CustomerParameterPanel customerParameterPanel = null;
        while (iterator.hasNext()) {
            customerParameterPanel = (CustomerParameterPanel)iterator.next();
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            customerParameterPanel.requestFocus();
        }
    }

    static class BrowseButtonListener
    implements ActionListener {
        private CustomerParameter filePathParam;

        public BrowseButtonListener(CustomerParameter customerParameter) {
            String string = "XML_PATH";
            RbsEmPropertiesFileHandler rbsEmPropertiesFileHandler = RbsEmPropertiesFileHandler.getInstance();
            String string2 = rbsEmPropertiesFileHandler.getProperty(string);
            this.filePathParam = customerParameter;
            try {
                this.filePathParam.setValue(string2);
            }
            catch (Exception exception) {
                Nal.getLog().nalTraceError(this.getClass(), "Failed to create BrowseButtonListener", exception);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.filePathParam.getValue();
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setBackground(Color.white);
            BemFileFilter bemFileFilter = new BemFileFilter("txt", "text files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Save Configuration Report");
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                try {
                    this.filePathParam.setValue(string2);
                    String string3 = "XML_PATH";
                    RbsEmPropertiesFileHandler rbsEmPropertiesFileHandler = RbsEmPropertiesFileHandler.getInstance();
                    File file = jFileChooser.getCurrentDirectory();
                    rbsEmPropertiesFileHandler.setProperty(string3, file.getPath());
                    rbsEmPropertiesFileHandler.storeBemPropInFile();
                }
                catch (Exception exception) {
                    Nal.getLog().nalTraceError(this.getClass(), "Failed in actionPerformed", exception);
                }
            }
        }
    }

    private class StoreReportThread
    extends Thread {
        private IndeterminateProgressDialog progressDialog;

        private StoreReportThread() {
        }

        public void run() {
            String string;
            Object object;
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            try {
                StoreConfigReportController.this.rbs.checkConsistency();
                bl5 = true;
            }
            catch (CustomerParameterException customerParameterException) {
                object2 = customerParameterException.getParameter();
                String string2 = customerParameterException.getReason();
                object = new Runnable((CustomerParameter)object2, string2){
                    final /* synthetic */ CustomerParameter val$cp;
                    final /* synthetic */ String val$reason;
                    {
                        this.val$cp = customerParameter;
                        this.val$reason = string;
                    }

                    public void run() {
                        String string = this.val$cp.getName();
                        String string2 = StoreConfigReportController.this.getGuiNameForCustomerParameter(string);
                        StoreConfigReportController.this.parentController.displayWarningMessage(string2 + "\n" + this.val$reason);
                        StoreConfigReportController.this.setFocusOnCustomerParameterComponent(string);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait((Runnable)object);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                this.reportException(exception, "Could not store report");
            }
            if (!bl5) {
                return;
            }
            this.hide();
            try {
                string = StoreConfigReportController.this.rbs.getCustomerParameter("AI_clientStoreReport");
                if ("YES".equals(string)) {
                    bl4 = true;
                    object2 = StoreConfigReportController.this.rbs.getCustomerParameter("AI_clientStoreReportFilePath");
                    boolean bl6 = this.isFilePathOk((String)object2);
                    if (bl6) {
                        object = new File((String)object2);
                        if (((File)object).getName().indexOf(46) == -1) {
                            object2 = (String)object2 + ".txt";
                        } else if (((File)object).getName().endsWith(".")) {
                            object2 = (String)object2 + "txt";
                        }
                        bl6 = this.isFilePathOk((String)object2);
                    }
                    if (bl6) {
                        bl2 = StoreConfigReportController.this.integrateRbsUtil.storeConfigurationReportOnClient((String)object2, StoreConfigReportController.this.configurationReport);
                    }
                }
            }
            catch (Exception exception) {
                bl2 = false;
                this.reportException(exception, "Could not store report on client");
            }
            try {
                string = StoreConfigReportController.this.rbs.getCustomerParameter("AI_ftpStoreReport");
                if ("YES".equals(string)) {
                    bl3 = true;
                    this.showProgressBar();
                    object2 = StoreConfigReportController.this.rbs.getCustomerParameter("AI_ftpStoreReportAddress");
                    String string3 = StoreConfigReportController.this.rbs.getCustomerParameter("AI_ftpStoreReportFilePath");
                    if (string3.indexOf(46) == -1) {
                        string3 = string3 + ".txt";
                    } else if (string3.endsWith(".")) {
                        string3 = string3 + "txt";
                    }
                    object = StoreConfigReportController.this.rbs.getCustomerParameter("AI_ftpStoreReportUserName");
                    String string4 = StoreConfigReportController.this.rbs.getCustomerParameter("AI_ftpStoreReportPassword");
                    boolean bl7 = StoreConfigReportController.this.integrateRbsUtil.checkFileOnServer((String)object2, string3, (String)object, string4);
                    if (!bl7) {
                        bl = true;
                    } else {
                        String[] stringArray = new String[]{string3};
                        String string5 = MessageFormat.format("File {0} already exists on FTP Server. Do you want to overwrite?", stringArray);
                        bl = StoreConfigReportController.this.parentController.displayConfirmDialog(string5);
                    }
                    if (bl) {
                        StoreConfigReportController.this.integrateRbsUtil.storeConfigurationReportOnServer((String)object2, string3, (String)object, string4, StoreConfigReportController.this.configurationReport);
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
                this.reportException(exception, "Could not store report on FTP server");
            }
            this.hideProgressBar();
            if (bl && bl2) {
                this.displayInformation("Report successfully stored on both FTP server and client.");
            } else if (bl) {
                this.displayInformation("Report successfully stored on FTP server.");
            } else if (bl2) {
                this.displayInformation("Report successfully stored on client.");
            } else if (!bl3 && !bl4) {
                this.show();
                this.displayWarningMessage("First select where to store the configuration report and then press Save button.");
                return;
            }
            if (bl3 && !bl || bl4 && !bl2) {
                this.show();
            } else {
                this.close();
            }
        }

        private boolean isFilePathOk(final String string) {
            final AtomicBoolean atomicBoolean = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                public void run() {
                    boolean bl = StoreConfigReportController.this.integrateRbsUtil.checkFileName(string);
                    atomicBoolean.set(bl);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Nal.getLog().nalTrace(6, this.getClass(), "File path check failed: " + string);
            }
            return atomicBoolean.get();
        }

        private void showProgressBar() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Saving logs");
            this.progressDialog = new IndeterminateProgressDialog(null, "Progress", arrayList, false);
            SwingUtilities.invokeLater(this.progressDialog);
        }

        private void hideProgressBar() {
            if (this.progressDialog == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreReportThread.this.progressDialog.setVisible(false);
                    StoreReportThread.this.progressDialog.dispose();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void close() {
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreConfigReportController.this.closeDialog();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void show() {
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreConfigReportController.this.dialog.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void hide() {
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreConfigReportController.this.dialog.setVisible(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void reportException(final Exception exception, final String string) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreConfigReportController.this.parentController.reportException(exception, string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void displayInformation(final String string) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreConfigReportController.this.parentController.displayInformation(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void displayWarningMessage(final String string) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StoreConfigReportController.this.parentController.displayWarningMessage(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected class StoreOnClientListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                if (customerParameter.getValue().equalsIgnoreCase("YES")) {
                    StoreConfigReportController.this.browseButton.setEnabled(true);
                } else {
                    StoreConfigReportController.this.browseButton.setEnabled(false);
                }
            }
        }
    }
}

